/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown.basic;

import java.util.HashMap;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownParameterRefreshEvent;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownParameterRefreshListener;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownParameterTable;
import org.pentaho.reporting.designer.core.editor.drilldown.basic.DefaultXulDrillDownController;
import org.pentaho.reporting.designer.core.editor.drilldown.model.DrillDownModel;
import org.pentaho.reporting.designer.core.editor.drilldown.model.DrillDownParameter;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;

public class SelfDrillDownController
extends DefaultXulDrillDownController {
    @Override
    public void init(ReportDesignerContext reportDesignerContext, DrillDownModel model, String[] fields) {
        super.init(reportDesignerContext, model, fields);
        DrillDownParameterTable drillDownTable = this.getTable();
        if (drillDownTable != null) {
            drillDownTable.addDrillDownParameterRefreshListener(new UpdateParametersHandler());
        }
        this.getWrapper().setDrillDownConfig("self");
        this.getWrapper().setDrillDownPath(null);
    }

    @Override
    public void deactivate() {
    }

    private class UpdateParametersHandler
    implements DrillDownParameterRefreshListener {
        private UpdateParametersHandler() {
        }

        @Override
        public void requestParameterRefresh(DrillDownParameterRefreshEvent event) {
            HashMap<String, DrillDownParameter> entries = new HashMap<String, DrillDownParameter>();
            DrillDownParameter[] originalParams = event.getParameter();
            for (int i = 0; i < originalParams.length; ++i) {
                DrillDownParameter param = originalParams[i];
                param.setType(DrillDownParameter.Type.MANUAL);
                entries.put(param.getName(), param);
            }
            ReportDocumentContext activeContext = SelfDrillDownController.this.getReportDesignerContext().getActiveContext();
            MasterReport masterReportElement = (MasterReport)activeContext.getContextRoot();
            ReportParameterDefinition reportParams = masterReportElement.getParameterDefinition();
            ParameterDefinitionEntry[] parameterDefinitionEntries = reportParams.getParameterDefinitions();
            for (int i = 0; i < parameterDefinitionEntries.length; ++i) {
                ParameterDefinitionEntry entry = parameterDefinitionEntries[i];
                if (!entries.containsKey(entry.getName())) {
                    entries.put(entry.getName(), new DrillDownParameter(entry.getName(), null, DrillDownParameter.Type.PREDEFINED, false, false));
                    continue;
                }
                DrillDownParameter parameter = (DrillDownParameter)entries.get(entry.getName());
                parameter.setType(DrillDownParameter.Type.PREDEFINED);
            }
            DrillDownParameter[] parameters = entries.values().toArray(new DrillDownParameter[entries.size()]);
            SelfDrillDownController.this.getWrapper().setDrillDownParameter(parameters);
            SelfDrillDownController.this.getTable().setDrillDownParameter(parameters);
        }
    }
}

