/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown.basic;

import java.util.Arrays;
import java.util.Locale;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownUi;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownUiProfile;
import org.pentaho.reporting.designer.core.editor.drilldown.basic.XulDrillDownUi;
import org.pentaho.reporting.engine.classic.extensions.drilldown.DrillDownProfile;
import org.pentaho.reporting.engine.classic.extensions.drilldown.DrillDownProfileMetaData;

public abstract class XulDrillDownUiProfile
implements DrillDownUiProfile {
    private DrillDownProfile drillDownProfile;
    private String[] names;

    public XulDrillDownUiProfile(String name) {
        this(new String[]{name.toString()});
    }

    public XulDrillDownUiProfile(String[] names) {
        this.init(names);
    }

    protected XulDrillDownUiProfile() {
    }

    protected void init(String[] names) {
        if (names == null || names.length == 0) {
            throw new IllegalArgumentException();
        }
        this.drillDownProfile = DrillDownProfileMetaData.getInstance().getDrillDownProfile(names[0]);
        if (this.drillDownProfile == null) {
            throw new IllegalArgumentException();
        }
        this.names = names;
    }

    @Override
    public DrillDownUi createUI() {
        return new XulDrillDownUi(this.names, this.drillDownProfile.getAttribute("group"));
    }

    @Override
    public String getDisplayName() {
        return this.drillDownProfile.getGroupDisplayName(Locale.getDefault());
    }

    @Override
    public boolean canHandle(String profileName) {
        for (int i = 0; i < this.names.length; ++i) {
            String name = this.names[i];
            if (!name.equals(profileName)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XulDrillDownUiProfile that = (XulDrillDownUiProfile)o;
        return Arrays.equals(this.names, that.names);
    }

    public int hashCode() {
        return Arrays.hashCode(this.names);
    }
}

