/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown.swing;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;

public abstract class DocumentBindingListener
implements DocumentListener {
    @Override
    public void insertUpdate(DocumentEvent e) {
        this.dataUpdated(e.getDocument());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.dataUpdated(e.getDocument());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.dataUpdated(e.getDocument());
    }

    private void dataUpdated(Document document) {
        try {
            String data = document.getText(document.getStartPosition().getOffset(), document.getEndPosition().getOffset() - 1);
            this.setData(data);
        }
        catch (BadLocationException ex) {
            UncaughtExceptionsModel.getInstance().addException(ex);
        }
    }

    protected abstract void setData(String var1);
}

