/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown.swing;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownParameterRefreshEvent;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownParameterRefreshListener;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownParameterTable;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownUi;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownUiException;
import org.pentaho.reporting.designer.core.editor.drilldown.basic.DrillDownModelWrapper;
import org.pentaho.reporting.designer.core.editor.drilldown.model.DrillDownModel;
import org.pentaho.reporting.designer.core.editor.drilldown.model.DrillDownParameter;
import org.pentaho.reporting.designer.core.editor.drilldown.swing.DocumentBindingListener;
import org.pentaho.reporting.designer.core.editor.drilldown.swing.SwingGenericUrlDrillDownUiProfile;
import org.pentaho.reporting.designer.core.editor.drilldown.swing.TooltipAndTargetPanel;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class SwingGenericUrlDrillDownUi
implements DrillDownUi {
    private JPanel editor;
    private TooltipAndTargetPanel tatPanel;
    private JTextField pathField;
    private DrillDownParameterTable table;
    private DrillDownModelWrapper wrapper;
    private ReportDesignerContext reportDesignerContext;
    private PathChangeHandler pathHandler;

    public SwingGenericUrlDrillDownUi() {
        SpringLayout layout = new SpringLayout();
        int layoutIndent = 2;
        this.editor = new JPanel();
        this.editor.setLayout(layout);
        JLabel pathLabel = new JLabel(Messages.getString("DrillDownDialog.PathInput.Label", new Object[0]));
        this.editor.add(pathLabel);
        layout.putConstraint("North", (Component)pathLabel, 2, "North", (Component)this.editor);
        layout.putConstraint("East", (Component)pathLabel, 2, "East", (Component)this.editor);
        layout.putConstraint("West", (Component)pathLabel, 2, "West", (Component)this.editor);
        this.pathField = new JTextField();
        this.pathField.getDocument().addDocumentListener(new DocumentBindingListener(){

            @Override
            protected void setData(String data) {
                SwingGenericUrlDrillDownUi.this.getModel().setDrillDownPath(data);
            }
        });
        this.editor.add(this.pathField);
        layout.putConstraint("North", (Component)this.pathField, 2, "South", (Component)pathLabel);
        layout.putConstraint("East", (Component)this.pathField, 0, "East", (Component)this.editor);
        layout.putConstraint("West", (Component)this.pathField, 2, "West", (Component)this.editor);
        this.tatPanel = new TooltipAndTargetPanel();
        this.tatPanel.getTargetComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SwingGenericUrlDrillDownUi.this.getModel().setTargetFormula(e.getItem().toString());
            }
        });
        this.tatPanel.getTooltipPanel().addPropertyChangeListener("formula", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwingGenericUrlDrillDownUi.this.getModel().setTooltipFormula(evt.getNewValue().toString());
            }
        });
        this.editor.add(this.tatPanel);
        layout.putConstraint("North", (Component)this.tatPanel, 2, "South", (Component)this.pathField);
        layout.putConstraint("East", (Component)this.tatPanel, 0, "East", (Component)this.editor);
        layout.putConstraint("West", (Component)this.tatPanel, 2, "West", (Component)this.editor);
        this.table = new DrillDownParameterTable();
        this.table.setShowRefreshButton(false);
        this.table.setAllowCustomParameter(true);
        this.table.setSingleTabMode(true);
        this.table.setShowHideParameterUiCheckbox(false);
        this.table.addDrillDownParameterRefreshListener(new UpdateParametersHandler());
        this.table.addPropertyChangeListener("drillDownParameter", new TableModelBinding());
        this.editor.add(this.table);
        layout.putConstraint("North", (Component)this.table, 2, "South", (Component)this.tatPanel);
        layout.putConstraint("East", (Component)this.table, -2, "East", (Component)this.editor);
        layout.putConstraint("South", (Component)this.table, -2, "South", (Component)this.editor);
        layout.putConstraint("West", (Component)this.table, 2, "West", (Component)this.editor);
    }

    @Override
    public Component getEditorPanel() {
        return this.editor;
    }

    @Override
    public DrillDownModel getModel() {
        return this.wrapper.getModel();
    }

    protected DrillDownModelWrapper getWrapper() {
        return this.wrapper;
    }

    protected DrillDownParameterTable getTable() {
        return this.table;
    }

    @Override
    public void init(Component parent, ReportDesignerContext reportDesignerContext, DrillDownModel model, String[] extraFields) throws DrillDownUiException {
        this.reportDesignerContext = reportDesignerContext;
        this.wrapper = new DrillDownModelWrapper(model);
        model.setDrillDownConfig(SwingGenericUrlDrillDownUiProfile.NAME_DEFAULT);
        this.pathHandler = new PathChangeHandler();
        this.getModel().addPropertyChangeListener("drillDownPath", this.pathHandler);
        if (this.getModel().isLimitedEditor()) {
            this.tatPanel.hideContent();
        }
        if (this.getModel().getTooltipFormula() != null) {
            this.tatPanel.getTooltipPanel().setFormula(this.getModel().getTooltipFormula());
        }
        if (this.getModel().getTargetFormula() != null) {
            this.tatPanel.getTargetComboBox().setSelectedItem(this.getModel().getTargetFormula());
        }
        if (this.getModel().getDrillDownPath() != null) {
            this.pathField.setText(this.getModel().getDrillDownPath());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingGenericUrlDrillDownUi.this.getTable().refreshParameterData();
            }
        });
    }

    @Override
    public void deactivate() {
        this.getModel().removePropertyChangeListener("drillDownPath", this.pathHandler);
    }

    public ReportDesignerContext getReportDesignerContext() {
        return this.reportDesignerContext;
    }

    private class PathChangeHandler
    implements PropertyChangeListener {
        private PathChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String path = SwingGenericUrlDrillDownUi.this.getModel().getDrillDownPath();
            if (StringUtils.isEmpty((String)path)) {
                return;
            }
            if (path.matches("\\w+\\://.*")) {
                SwingGenericUrlDrillDownUi.this.getModel().setDrillDownConfig("generic-url");
            } else {
                SwingGenericUrlDrillDownUi.this.getModel().setDrillDownConfig("local-url");
            }
        }
    }

    private class UpdateParametersHandler
    implements DrillDownParameterRefreshListener {
        private UpdateParametersHandler() {
        }

        @Override
        public void requestParameterRefresh(DrillDownParameterRefreshEvent event) {
            HashMap<String, DrillDownParameter> entries = new HashMap<String, DrillDownParameter>();
            DrillDownParameter[] originalParams = event.getParameter();
            for (int i = 0; i < originalParams.length; ++i) {
                DrillDownParameter param = originalParams[i];
                param.setType(DrillDownParameter.Type.MANUAL);
                entries.put(param.getName(), param);
            }
            ReportDocumentContext activeContext = SwingGenericUrlDrillDownUi.this.getReportDesignerContext().getActiveContext();
            MasterReport masterReportElement = (MasterReport)activeContext.getContextRoot();
            ReportParameterDefinition reportParams = masterReportElement.getParameterDefinition();
            ParameterDefinitionEntry[] parameterDefinitionEntries = reportParams.getParameterDefinitions();
            for (int i = 0; i < parameterDefinitionEntries.length; ++i) {
                ParameterDefinitionEntry entry = parameterDefinitionEntries[i];
                if (!entries.containsKey(entry.getName())) {
                    entries.put(entry.getName(), new DrillDownParameter(entry.getName(), null, DrillDownParameter.Type.PREDEFINED, false, false));
                    continue;
                }
                DrillDownParameter parameter = (DrillDownParameter)entries.get(entry.getName());
                parameter.setType(DrillDownParameter.Type.PREDEFINED);
            }
            DrillDownParameter[] parameters = entries.values().toArray(new DrillDownParameter[entries.size()]);
            SwingGenericUrlDrillDownUi.this.getWrapper().setDrillDownParameter(parameters);
            SwingGenericUrlDrillDownUi.this.getTable().setDrillDownParameter(parameters);
        }
    }

    private class TableModelBinding
    implements PropertyChangeListener {
        private TableModelBinding() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SwingGenericUrlDrillDownUi.this.wrapper.setDrillDownParameter(SwingGenericUrlDrillDownUi.this.table.getDrillDownParameter());
        }
    }
}

