/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.expressions;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.pentaho.plugin.jfreereport.reportcharts.AbstractChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.ChartExpression;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.expressions.EditorExpressionsMessages;
import org.pentaho.reporting.designer.core.editor.expressions.ExpressionPropertiesTableModel;
import org.pentaho.reporting.designer.core.util.table.GroupedName;
import org.pentaho.reporting.designer.core.util.table.GroupingHeader;
import org.pentaho.reporting.designer.core.util.undo.CompoundUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.ExpressionPropertyChangeUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoManager;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyMetaData;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class DynamicExpressionTableModel
extends ExpressionPropertiesTableModel {
    public DynamicExpressionTableModel() {
        this.setFilterInlineExpressionProperty(true);
    }

    @Override
    protected boolean isFiltered(ExpressionPropertyMetaData metaData) {
        if ("linesDataSource".equals(metaData.getName())) {
            return true;
        }
        if ("secondaryDataSet".equals(metaData.getName())) {
            return true;
        }
        if ("dataSource".equals(metaData.getName())) {
            return true;
        }
        return super.isFiltered(metaData);
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return super.getColumnName(column);
            }
            case 1: {
                return super.getColumnName(column);
            }
            case 2: {
                return EditorExpressionsMessages.getString("ExpressionPropertiesTableModel.ExpressionColumn");
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ExpressionPropertyMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return this.getGroupings(rowIndex);
        }
        switch (columnIndex) {
            case 0: {
                return super.getValueAt(rowIndex, columnIndex);
            }
            case 1: {
                return super.getValueAt(rowIndex, columnIndex);
            }
            case 2: {
                for (int i = 0; i < this.getData().length; ++i) {
                    AbstractChartExpression exp;
                    LinkedHashMap exprMap;
                    Expression expression = this.getData()[i];
                    if (!(expression instanceof ChartExpression) || null == (exprMap = (LinkedHashMap)(exp = (AbstractChartExpression)expression).getExpressionMap()).get(metaData.getName())) continue;
                    FormulaExpression fe = (FormulaExpression)exprMap.get(metaData.getName());
                    return fe;
                }
                return null;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        ExpressionPropertyMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return false;
        }
        switch (columnIndex) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ExpressionPropertyMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                return;
            }
            case 1: {
                super.setValueAt(aValue, rowIndex, columnIndex);
                break;
            }
            case 2: {
                if (!this.defineExpressionValue(metaData, aValue)) break;
                if (this.getActiveContext() != null) {
                    AbstractReportDefinition abstractReportDefinition = this.getActiveContext().getReportDefinition();
                    for (int i = 0; i < this.getData().length; ++i) {
                        Expression expression = this.getData()[i];
                        abstractReportDefinition.fireModelLayoutChanged((ReportElement)abstractReportDefinition, 0, (Object)expression);
                    }
                }
                this.fireTableDataChanged();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    private boolean defineExpressionValue(ExpressionPropertyMetaData metaData, Object value) {
        boolean changed = false;
        FormulaExpression newExpression = (FormulaExpression)value;
        for (int i = 0; i < this.getData().length; ++i) {
            String newFormulaExpression;
            Expression expression = this.getData()[i];
            AbstractChartExpression exp = (AbstractChartExpression)expression;
            FormulaExpression oldExpression = (FormulaExpression)exp.getExpressionMap().get(metaData.getName());
            String oldFormulaExpression = null == oldExpression ? "" : oldExpression.getFormulaExpression();
            if (ObjectUtilities.equal((Object)oldFormulaExpression, (Object)(newFormulaExpression = null == newExpression ? "" : newExpression.getFormulaExpression()))) continue;
            changed = true;
        }
        if (changed) {
            ReportDocumentContext activeContext1 = this.getActiveContext();
            ArrayList<ExpressionPropertyChangeUndoEntry> undos = new ArrayList<ExpressionPropertyChangeUndoEntry>();
            for (int i = 0; i < this.getData().length; ++i) {
                AbstractChartExpression exp;
                Expression expression = this.getData()[i];
                String name = metaData.getName();
                if (activeContext1 != null) {
                    exp = (AbstractChartExpression)expression;
                    Object oldValue = exp.getExpressionMap().get(name);
                    undos.add(new ExpressionPropertyChangeUndoEntry(this.getData()[i], name, oldValue, value));
                }
                exp = (AbstractChartExpression)expression;
                if (null == value) {
                    exp.removeExpression(name);
                    continue;
                }
                FormulaExpression fe = (FormulaExpression)value;
                exp.addExpression(metaData.getName(), (Expression)fe);
            }
            if (activeContext1 != null) {
                UndoManager undo = activeContext1.getUndo();
                undo.addChange(EditorExpressionsMessages.getString("ExpressionPropertiesTableModel.UndoName"), new CompoundUndoEntry(undos.toArray(new UndoEntry[undos.size()])));
            }
        }
        return changed;
    }

    @Override
    public PropertyEditor getEditorForCell(int aRowIndex, int aColumnIndex) {
        ExpressionPropertyMetaData metaData = this.getMetaData(aRowIndex);
        if (metaData == null) {
            return null;
        }
        switch (aColumnIndex) {
            case 0: {
                return null;
            }
            case 1: {
                return super.getEditorForCell(aRowIndex, aColumnIndex);
            }
            case 2: {
                return null;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Class getClassForCell(int rowIndex, int columnIndex) {
        ExpressionPropertyMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return GroupingHeader.class;
        }
        switch (columnIndex) {
            case 0: {
                return GroupedName.class;
            }
            case 1: {
                return super.getClassForCell(rowIndex, columnIndex);
            }
            case 2: {
                if (metaData.isDesignTimeProperty()) {
                    return Object.class;
                }
                return Expression.class;
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

