/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.expressions;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.pentaho.reporting.designer.core.ReportDesignerBoot;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.expressions.EditorExpressionsMessages;
import org.pentaho.reporting.designer.core.editor.expressions.ExpressionEditor;
import org.pentaho.reporting.designer.core.editor.expressions.ExpressionPropertiesEditorPanel;
import org.pentaho.reporting.designer.core.editor.expressions.ExpressionUtil;
import org.pentaho.reporting.designer.core.util.ExpressionListCellRenderer;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.MetaDataLookupException;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.VerticalLayout;

public class ExpressionEditorDialog
extends CommonDialog {
    private static final String PREFIX = "org.pentaho.reporting.designer.core.editor.expressions.plugins.";
    private JTabbedPane viewPane;
    private ExpressionPropertiesEditorPanel expressionEditorPane;
    private JComboBox expressionEditor;
    private Expression expression;
    private ExpressionEditorWrapper wrapper;
    private HashMap<String, Class> editorPlugins;
    private ReportDesignerContext designerContext;
    private DefaultComboBoxModel model;
    private boolean expressionsOnly;
    private boolean showStandaloneProperties;

    public ExpressionEditorDialog() {
        this.init();
    }

    public ExpressionEditorDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public ExpressionEditorDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    protected void init() {
        this.editorPlugins = new HashMap();
        this.loadPlugins();
        this.setDefaultCloseOperation(2);
        this.setTitle(EditorExpressionsMessages.getString("ExpressionEditorDialog.Title"));
        this.setModal(true);
        this.setResizable(true);
        this.expressionEditorPane = new ExpressionPropertiesEditorPanel();
        this.wrapper = new ExpressionEditorWrapper();
        this.viewPane = new JTabbedPane();
        this.viewPane.addTab(EditorExpressionsMessages.getString("ExpressionEditorDialog.Properties"), new JScrollPane(this.expressionEditorPane));
        this.viewPane.setEnabledAt(0, false);
        this.viewPane.addChangeListener(new TabSelectionListener());
        ExpressionMetaData[] knownExpressions = ExpressionUtil.getInstance().getKnownExpressions();
        this.model = new DefaultComboBoxModel<ExpressionMetaData>(knownExpressions);
        this.model.addListDataListener(new ExpressionSelectionHandler());
        this.expressionEditor = new JComboBox(this.model);
        this.expressionEditor.setEditable(false);
        this.expressionEditor.setRenderer(new ExpressionListCellRenderer());
        super.init();
        this.setExpressionsOnly(true);
        this.setExpression(null);
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.ExpressionEditor";
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        if (this.viewPane.getTabCount() == 2) {
            this.viewPane.removeTabAt(1);
        }
        this.expression = expression;
        if (expression == null) {
            this.expressionEditor.setSelectedItem(null);
            this.wrapper.setEditor(null);
            this.expressionEditorPane.setData(new Expression[0]);
            this.viewPane.setEnabledAt(0, false);
        } else {
            try {
                this.viewPane.setEnabledAt(0, true);
                this.expressionEditor.setSelectedItem(ExpressionRegistry.getInstance().getExpressionMetaData(expression.getClass().getName()));
                this.expressionEditorPane.setData(new Expression[]{this.expression});
                ExpressionEditor plugin = this.createEditorForClass(expression);
                if (plugin != null) {
                    this.wrapper.setEditor(plugin);
                    this.viewPane.addTab(plugin.getTitle(), this.wrapper);
                    this.viewPane.setSelectedIndex(1);
                } else {
                    this.wrapper.setEditor(null);
                }
            }
            catch (MetaDataLookupException e) {
                UncaughtExceptionsModel.getInstance().addException(e);
                this.expressionEditor.setSelectedItem(null);
            }
        }
    }

    private ExpressionEditor createEditorForClass(Expression expression) {
        Class plugin = this.editorPlugins.get(expression.getClass().getName());
        if (plugin == null) {
            return null;
        }
        try {
            ExpressionEditor ed = (ExpressionEditor)plugin.newInstance();
            ed.initialize(expression, this.designerContext);
            return ed;
        }
        catch (Throwable e) {
            UncaughtExceptionsModel.getInstance().addException(e);
            return null;
        }
    }

    public boolean isExpressionsOnly() {
        return this.expressionsOnly;
    }

    public void setExpressionsOnly(boolean expressionsOnly) {
        if (this.expressionsOnly == expressionsOnly) {
            return;
        }
        this.expressionsOnly = expressionsOnly;
        this.model.removeAllElements();
        this.model.addElement(null);
        ExpressionMetaData[] knownExpressions = expressionsOnly ? ExpressionUtil.getInstance().getKnownExpressions() : ExpressionUtil.getInstance().getKnownFunctions();
        for (ExpressionMetaData knownExpression : knownExpressions) {
            this.model.addElement(knownExpression);
        }
    }

    private void loadPlugins() {
        ClassLoader classLoader = ObjectUtilities.getClassLoader(ExpressionEditorDialog.class);
        Configuration config = ReportDesignerBoot.getInstance().getGlobalConfig();
        Iterator keys = config.findPropertyKeys(PREFIX);
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String expressionClass = key.substring(PREFIX.length());
            try {
                String editorClass = config.getConfigProperty(key);
                Class<?> c = Class.forName(editorClass, false, classLoader);
                if (c == null) continue;
                this.editorPlugins.put(expressionClass, c);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    protected Component createContentPane() {
        JPanel headerPanel = new JPanel((LayoutManager)new VerticalLayout(5, 2, 1));
        headerPanel.add(new JLabel(EditorExpressionsMessages.getString("ExpressionEditorDialog.SelectedExpression")));
        headerPanel.add(this.expressionEditor);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.viewPane, "Center");
        panel.add((Component)headerPanel, "North");
        return panel;
    }

    public Expression performEditExpression(ReportDesignerContext context, Expression expression) {
        FormulaExpression formulaExpression;
        if (context == null) {
            throw new NullPointerException();
        }
        this.setShowStandaloneProperties(false);
        this.setExpressionsOnly(true);
        this.designerContext = context;
        if (expression == null) {
            this.setExpression((Expression)new FormulaExpression());
        } else {
            this.setExpression(expression.getInstance());
        }
        if (!super.performEdit()) {
            return null;
        }
        this.wrapper.stopEditing();
        if (this.expression instanceof FormulaExpression && StringUtils.isEmpty((String)(formulaExpression = (FormulaExpression)this.expression).getFormula())) {
            return null;
        }
        return this.expression;
    }

    public void setShowStandaloneProperties(boolean showStandaloneProperties) {
        this.showStandaloneProperties = showStandaloneProperties;
    }

    public boolean isShowStandaloneProperties() {
        return this.showStandaloneProperties;
    }

    private class TabSelectionListener
    implements ChangeListener {
        private TabSelectionListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (ExpressionEditorDialog.this.viewPane.getSelectedIndex() == 0) {
                if (ExpressionEditorDialog.this.viewPane.getTabCount() == 2) {
                    ExpressionEditorDialog.this.wrapper.getEditor().stopEditing();
                }
            } else {
                ExpressionEditorDialog.this.expressionEditorPane.stopEditing();
                ExpressionEditorDialog.this.wrapper.getEditor().initialize(ExpressionEditorDialog.this.expression, ExpressionEditorDialog.this.designerContext);
            }
        }
    }

    private static class ExpressionEditorWrapper
    extends JComponent {
        private JComponent disabledPanel = new JPanel();
        private CardLayout cardLayout;
        private JPanel enabledPanel;
        private ExpressionEditor editor;

        private ExpressionEditorWrapper() {
            this.disabledPanel.setLayout(new BorderLayout());
            this.disabledPanel.add(new JLabel(EditorExpressionsMessages.getString("ExpressionEditorDialog.NoExtendedEditor")));
            this.cardLayout = new CardLayout();
            this.enabledPanel = new JPanel();
            this.enabledPanel.setLayout(new BorderLayout());
            this.setLayout(this.cardLayout);
            this.add((Component)this.disabledPanel, "disabled");
            this.add((Component)this.enabledPanel, "enabled");
            this.cardLayout.first(this);
        }

        public ExpressionEditor getEditor() {
            return this.editor;
        }

        public void setEditor(ExpressionEditor editor) {
            if (this.editor != null) {
                this.editor.stopEditing();
            }
            this.editor = editor;
            if (editor == null) {
                this.cardLayout.first(this);
            } else {
                JComponent editorComponent = editor.getEditorComponent();
                this.enabledPanel.removeAll();
                this.enabledPanel.add(editorComponent);
                this.enabledPanel.revalidate();
                this.cardLayout.last(this);
            }
        }

        public void stopEditing() {
            if (this.editor != null) {
                this.editor.stopEditing();
            }
        }
    }

    private class ExpressionSelectionHandler
    implements ListDataListener {
        private ExpressionSelectionHandler() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            ExpressionMetaData selectedItem = (ExpressionMetaData)ExpressionEditorDialog.this.expressionEditor.getSelectedItem();
            Expression expression = ExpressionEditorDialog.this.getExpression();
            if (selectedItem == null) {
                if (expression != null) {
                    ExpressionEditorDialog.this.setExpression(null);
                }
                return;
            }
            if (expression == null || !ObjectUtilities.equal((Object)selectedItem.getExpressionType(), expression.getClass())) {
                ExpressionEditorDialog.this.setExpression(selectedItem.create());
            }
        }
    }
}

