/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.expressions;

import java.util.ArrayList;
import java.util.Collections;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.engine.classic.core.function.Function;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.GroupedMetaDataComparator;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;

public class ExpressionUtil {
    private static ExpressionUtil instance;
    private ExpressionMetaData[] expressions;
    private ExpressionMetaData[] functions;

    public static synchronized ExpressionUtil getInstance() {
        if (instance == null) {
            instance = new ExpressionUtil();
        }
        return instance;
    }

    public ExpressionMetaData[] getKnownFunctions() {
        return (ExpressionMetaData[])this.functions.clone();
    }

    public ExpressionMetaData[] getKnownExpressions() {
        return (ExpressionMetaData[])this.expressions.clone();
    }

    private ExpressionUtil() {
        ArrayList<ExpressionMetaData> allRealExpressions = new ArrayList<ExpressionMetaData>();
        ArrayList<ExpressionMetaData> allExpressions = new ArrayList<ExpressionMetaData>();
        for (ExpressionMetaData metaData : ExpressionRegistry.getInstance().getAllExpressionMetaDatas()) {
            if (metaData.isHidden() || !WorkspaceSettings.getInstance().isVisible((MetaData)metaData)) continue;
            if (!Function.class.isAssignableFrom(metaData.getExpressionType())) {
                allRealExpressions.add(metaData);
            }
            allExpressions.add(metaData);
        }
        Collections.sort(allRealExpressions, new GroupedMetaDataComparator());
        Collections.sort(allExpressions, new GroupedMetaDataComparator());
        this.expressions = allRealExpressions.toArray(new ExpressionMetaData[allRealExpressions.size()]);
        this.functions = allExpressions.toArray(new ExpressionMetaData[allExpressions.size()]);
    }
}

