/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.expressions;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.pentaho.reporting.designer.core.editor.expressions.EditorExpressionsMessages;
import org.pentaho.reporting.designer.core.editor.expressions.ExpressionEditor;

public abstract class ScriptingExpressionEditor
implements ExpressionEditor {
    private JPanel panel;
    private RSyntaxTextArea textArea;
    private JLabel statusText = new JLabel();

    public ScriptingExpressionEditor() {
        this.textArea = new RSyntaxTextArea();
        this.textArea.setSyntaxEditingStyle("text/plain");
        JPanel queryContentHolder = new JPanel(new BorderLayout());
        queryContentHolder.add("North", new JLabel(EditorExpressionsMessages.getString("ScriptingExpressionEditor.Script")));
        queryContentHolder.add("Center", (Component)new RTextScrollPane(500, 300, (RTextArea)this.textArea, true));
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)queryContentHolder, "Center");
    }

    protected void addValidateButton(Action action) {
        JPanel validatePanel = new JPanel();
        validatePanel.setLayout(new BorderLayout());
        validatePanel.add((Component)new JButton(action), "East");
        validatePanel.add((Component)this.statusText, "Center");
        this.panel.add((Component)validatePanel, "South");
    }

    public String getStatus() {
        return this.statusText.getText();
    }

    public void setStatus(String text) {
        this.statusText.setText(text);
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setText(String t) {
        this.textArea.setText(t);
    }

    public String getSyntaxEditingStyle() {
        return this.textArea.getSyntaxEditingStyle();
    }

    public void setSyntaxEditingStyle(String styleKey) {
        this.textArea.setSyntaxEditingStyle(styleKey);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.panel;
    }

    @Override
    public String getTitle() {
        return EditorExpressionsMessages.getString("ScriptingExpressionEditor.Script");
    }
}

