/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.fieldselector;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportFieldNode;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class FieldCellRenderer
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!(value instanceof ReportFieldNode)) {
            return this;
        }
        ReportFieldNode fieldNode = (ReportFieldNode)value;
        ContextAwareDataSchemaModel model = fieldNode.getDataSchemaModel();
        DataAttributes attributes = model.getDataSchema().getAttributes(fieldNode.getFieldName());
        this.setToolTipText(fieldNode.getFieldClass().getSimpleName());
        if (attributes == null) {
            this.setText(fieldNode.toString());
            this.setIcon(IconLoader.getInstance().getBlankDocumentIcon());
        } else {
            this.configureFieldText(fieldNode, model, attributes);
            this.configureFieldIcon(model, attributes);
        }
        return this;
    }

    protected void configureFieldText(ReportFieldNode fieldNode, ContextAwareDataSchemaModel model, DataAttributes attributes) {
        String displayName = (String)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/formatting", "label", String.class, model.getDataAttributeContext());
        this.setText(this.formatFieldType(displayName, fieldNode.getFieldName(), fieldNode.getFieldClass()));
    }

    protected void configureFieldIcon(ContextAwareDataSchemaModel model, DataAttributes attributes) {
        Object source = attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "source", String.class, model.getDataAttributeContext());
        if ("environment".equals(source)) {
            this.setIcon(IconLoader.getInstance().getPropertiesDataSetIcon());
        } else if ("expression".equals(source)) {
            this.setIcon(IconLoader.getInstance().getFunctionIcon());
        } else if ("parameter".equals(source)) {
            this.setIcon(IconLoader.getInstance().getParameterIcon());
        } else if ("table".equals(source)) {
            this.setIcon(IconLoader.getInstance().getDataSetsIcon());
        } else {
            this.setIcon(IconLoader.getInstance().getBlankDocumentIcon());
        }
    }

    private String formatFieldType(String displayName, String fieldName, Class fieldClass) {
        if (displayName == null || ObjectUtilities.equal((Object)displayName, (Object)fieldName)) {
            if (fieldClass == null) {
                return fieldName;
            }
            return Messages.getString("FieldCellRenderer.TypedFieldMessage", fieldName, fieldClass.getSimpleName());
        }
        if (fieldClass == null) {
            return Messages.getString("FieldCellRenderer.TypedFieldMessage", displayName, fieldName);
        }
        return Messages.getString("FieldCellRenderer.AliasedTypedFieldMessage", displayName, fieldName, fieldClass.getSimpleName());
    }
}

