/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.format;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.editor.format.BorderRenderPanel;
import org.pentaho.reporting.designer.core.editor.format.BorderSelection;
import org.pentaho.reporting.designer.core.editor.format.BorderSelectionEvent;
import org.pentaho.reporting.designer.core.editor.format.BorderSelectionListener;
import org.pentaho.reporting.designer.core.editor.format.SelectCustomColorAction;
import org.pentaho.reporting.engine.classic.core.style.BorderStyle;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.libraries.designtime.swing.ColorComboBox;
import org.pentaho.reporting.libraries.designtime.swing.EllipsisButton;

public class BorderPropertiesPane
extends JPanel {
    private JSpinner cornerWidth;
    private JSpinner cornerHeight;
    private JSpinner paddingLeft;
    private JSpinner paddingTop;
    private JSpinner paddingBottom;
    private JSpinner paddingRight;
    private JComboBox colorSelectorBox;
    private JList styleList;
    private BorderRenderPanel borderEditorPanel;
    private JSpinner borderWidth;
    private JTextField minimumWidth;
    private JTextField minimumHeight;

    public BorderPropertiesPane() {
        BorderStyleUpdateHandler updateHandler = new BorderStyleUpdateHandler();
        this.styleList = new JList(this.createBorderStyleModel());
        this.styleList.addListSelectionListener(updateHandler);
        this.colorSelectorBox = new ColorComboBox();
        this.colorSelectorBox.addActionListener(updateHandler);
        this.minimumWidth = new JTextField();
        this.minimumHeight = new JTextField();
        this.paddingTop = new FloatSpinner();
        this.paddingLeft = new FloatSpinner();
        this.paddingBottom = new FloatSpinner();
        this.paddingRight = new FloatSpinner();
        this.cornerWidth = new FloatSpinner();
        this.cornerWidth.addChangeListener(updateHandler);
        this.cornerHeight = new FloatSpinner();
        this.cornerHeight.addChangeListener(updateHandler);
        this.borderEditorPanel = new BorderRenderPanel();
        this.borderEditorPanel.setMinimumSize(new Dimension(100, 100));
        this.borderEditorPanel.setPreferredSize(new Dimension(250, 250));
        this.borderEditorPanel.setMaximumSize(new Dimension(250, 250));
        this.borderEditorPanel.getSelectionModel().addBorderSelectionListener(new BorderSelectionUpdateHandler());
        this.borderWidth = new FloatSpinner();
        this.borderWidth.addChangeListener(updateHandler);
        JPanel borderCornerCarrier = new JPanel(new GridBagLayout());
        borderCornerCarrier.setBorder(BorderFactory.createTitledBorder(Messages.getString("BorderPropertiesPane.RoundedCorners", new Object[0])));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 0);
        borderCornerCarrier.add((Component)new JLabel(Messages.getString("BorderPropertiesPane.Width", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        borderCornerCarrier.add((Component)this.cornerWidth, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 0);
        borderCornerCarrier.add((Component)new JLabel(Messages.getString("BorderPropertiesPane.Height", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        borderCornerCarrier.add((Component)this.cornerHeight, gbc);
        JPanel arrangementPanel = new JPanel();
        arrangementPanel.setLayout(new FlowLayout());
        arrangementPanel.add(new JButton(new SelectNoneBordersAction()));
        arrangementPanel.add(new JButton(new SelectAllBordersAction()));
        arrangementPanel.add(new JButton(new SelectHorizontalBordersAction()));
        arrangementPanel.add(new JButton(new SelectVerticalBordersAction()));
        arrangementPanel.add(new JButton(new SelectLeftBordersAction()));
        arrangementPanel.add(new JButton(new SelectRightBordersAction()));
        JPanel borderPanel = new JPanel();
        borderPanel.setLayout(new BorderLayout());
        borderPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("BorderPropertiesPane.Borders", new Object[0])));
        borderPanel.add((Component)arrangementPanel, "North");
        borderPanel.add((Component)this.borderEditorPanel, "Center");
        JPanel borderEditorCarrier = new JPanel(new BorderLayout());
        borderEditorCarrier.add((Component)borderPanel, "Center");
        borderEditorCarrier.add((Component)borderCornerCarrier, "South");
        JPanel styleListPanel = new JPanel();
        styleListPanel.setLayout(new BorderLayout());
        styleListPanel.add((Component)new JLabel(Messages.getString("BorderPropertiesPane.Style", new Object[0])), "North");
        styleListPanel.add((Component)new JScrollPane(this.styleList), "Center");
        JPanel styleColorPanel = new JPanel();
        styleColorPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 5);
        styleColorPanel.add((Component)new JLabel(Messages.getString("BorderPropertiesPane.Width", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 5);
        styleColorPanel.add((Component)this.borderWidth, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 5);
        styleColorPanel.add((Component)new JLabel(Messages.getString("BorderPropertiesPane.Color", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 5);
        styleColorPanel.add((Component)this.colorSelectorBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.fill = 3;
        styleColorPanel.add((Component)new EllipsisButton((Action)new SelectCustomColorAction(this.colorSelectorBox)), gbc);
        JPanel linestylePanel = new JPanel();
        linestylePanel.setLayout(new BorderLayout());
        linestylePanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("BorderPropertiesPane.LineStyle", new Object[0])));
        linestylePanel.add((Component)styleListPanel, "Center");
        linestylePanel.add((Component)styleColorPanel, "South");
        JPanel paddingPanel = new JPanel();
        paddingPanel.setLayout(new GridBagLayout());
        paddingPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("BorderPropertiesPane.Paddings", new Object[0])));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 0);
        paddingPanel.add((Component)new JLabel(Messages.getString("BorderPropertiesPane.Left", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        paddingPanel.add((Component)this.paddingLeft, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 0);
        paddingPanel.add((Component)new JLabel(Messages.getString("BorderPropertiesPane.Right", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        paddingPanel.add((Component)this.paddingRight, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 0);
        paddingPanel.add((Component)new JLabel(Messages.getString("BorderPropertiesPane.Top", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        paddingPanel.add((Component)this.paddingTop, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 0);
        paddingPanel.add((Component)new JLabel(Messages.getString("BorderPropertiesPane.Bottom", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        paddingPanel.add((Component)this.paddingBottom, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.weighty = 100.0;
        gbc.anchor = 17;
        paddingPanel.add((Component)new JPanel(), gbc);
        JPanel minSizePanel = new JPanel();
        minSizePanel.setLayout(new GridBagLayout());
        minSizePanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("BorderPropertiesPane.MinimumSize", new Object[0])));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 0);
        minSizePanel.add((Component)new JLabel(Messages.getString("BorderPropertiesPane.Width", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        minSizePanel.add((Component)this.minimumWidth, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 0);
        minSizePanel.add((Component)new JLabel(Messages.getString("BorderPropertiesPane.Height", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        minSizePanel.add((Component)this.minimumHeight, gbc);
        JPanel paddingsAndSizePanel = new JPanel();
        paddingsAndSizePanel.setLayout(new BorderLayout());
        paddingsAndSizePanel.add((Component)minSizePanel, "North");
        paddingsAndSizePanel.add((Component)paddingPanel, "Center");
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 12;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)paddingsAndSizePanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 11;
        gbc.weightx = 3.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)borderEditorCarrier, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)linestylePanel, gbc);
    }

    private DefaultListModel createBorderStyleModel() {
        DefaultListModel<BorderStyle> model = new DefaultListModel<BorderStyle>();
        model.addElement(BorderStyle.SOLID);
        model.addElement(BorderStyle.DASHED);
        model.addElement(BorderStyle.DOT_DASH);
        model.addElement(BorderStyle.DOT_DOT_DASH);
        model.addElement(BorderStyle.DOTTED);
        model.addElement(BorderStyle.HIDDEN);
        model.addElement(BorderStyle.NONE);
        model.addElement(BorderStyle.DOUBLE);
        model.addElement(BorderStyle.GROOVE);
        model.addElement(BorderStyle.INSET);
        model.addElement(BorderStyle.OUTSET);
        model.addElement(BorderStyle.RIDGE);
        model.addElement(BorderStyle.WAVE);
        return model;
    }

    protected void applyBorder(BorderSelection borderSelection) {
        ElementStyleSheet styleSheet = this.borderEditorPanel.getElementStyleSheet();
        if (BorderSelection.TOP.equals((Object)borderSelection)) {
            Color color = (Color)this.colorSelectorBox.getSelectedItem();
            Number width = (Number)this.borderWidth.getValue();
            styleSheet.setStyleProperty(ElementStyleKeys.BORDER_TOP_COLOR, (Object)color);
            styleSheet.setStyleProperty(ElementStyleKeys.BORDER_TOP_WIDTH, (Object)new Float(width.floatValue()));
            styleSheet.setStyleProperty(ElementStyleKeys.BORDER_TOP_STYLE, this.styleList.getSelectedValue());
        } else if (BorderSelection.LEFT.equals((Object)borderSelection)) {
            Color color = (Color)this.colorSelectorBox.getSelectedItem();
            Number width = (Number)this.borderWidth.getValue();
            styleSheet.setStyleProperty(ElementStyleKeys.BORDER_LEFT_COLOR, (Object)color);
            styleSheet.setStyleProperty(ElementStyleKeys.BORDER_LEFT_WIDTH, (Object)new Float(width.floatValue()));
            styleSheet.setStyleProperty(ElementStyleKeys.BORDER_LEFT_STYLE, this.styleList.getSelectedValue());
        } else if (BorderSelection.BOTTOM.equals((Object)borderSelection)) {
            Color color = (Color)this.colorSelectorBox.getSelectedItem();
            Number width = (Number)this.borderWidth.getValue();
            styleSheet.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_COLOR, (Object)color);
            styleSheet.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_WIDTH, (Object)new Float(width.floatValue()));
            styleSheet.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_STYLE, this.styleList.getSelectedValue());
        } else if (BorderSelection.RIGHT.equals((Object)borderSelection)) {
            Color color = (Color)this.colorSelectorBox.getSelectedItem();
            Number width = (Number)this.borderWidth.getValue();
            styleSheet.setStyleProperty(ElementStyleKeys.BORDER_RIGHT_COLOR, (Object)color);
            styleSheet.setStyleProperty(ElementStyleKeys.BORDER_RIGHT_WIDTH, (Object)new Float(width.floatValue()));
            styleSheet.setStyleProperty(ElementStyleKeys.BORDER_RIGHT_STYLE, this.styleList.getSelectedValue());
        } else if (BorderSelection.TOP_LEFT.equals((Object)borderSelection)) {
            Number width = (Number)this.cornerWidth.getValue();
            Number height = (Number)this.cornerHeight.getValue();
            styleSheet.setStyleProperty(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_WIDTH, (Object)new Float(width.floatValue()));
            styleSheet.setStyleProperty(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_HEIGHT, (Object)new Float(height.floatValue()));
        } else if (BorderSelection.TOP_RIGHT.equals((Object)borderSelection)) {
            Number width = (Number)this.cornerWidth.getValue();
            Number height = (Number)this.cornerHeight.getValue();
            styleSheet.setStyleProperty(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_WIDTH, (Object)new Float(width.floatValue()));
            styleSheet.setStyleProperty(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_HEIGHT, (Object)new Float(height.floatValue()));
        } else if (BorderSelection.BOTTOM_LEFT.equals((Object)borderSelection)) {
            Number width = (Number)this.cornerWidth.getValue();
            Number height = (Number)this.cornerHeight.getValue();
            styleSheet.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_WIDTH, (Object)new Float(width.floatValue()));
            styleSheet.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_HEIGHT, (Object)new Float(height.floatValue()));
        } else if (BorderSelection.BOTTOM_RIGHT.equals((Object)borderSelection)) {
            Number width = (Number)this.cornerWidth.getValue();
            Number height = (Number)this.cornerHeight.getValue();
            styleSheet.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_WIDTH, (Object)new Float(width.floatValue()));
            styleSheet.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_HEIGHT, (Object)new Float(height.floatValue()));
        }
        this.borderEditorPanel.repaint();
    }

    public void initializeFromStyle(ElementStyleSheet styleSheet) {
        this.borderEditorPanel.updateElementStyleSheet(styleSheet);
        this.minimumWidth.setText(BorderPropertiesPane.printLength((Number)styleSheet.getStyleProperty(ElementStyleKeys.MIN_WIDTH)));
        this.minimumHeight.setText(BorderPropertiesPane.printLength((Number)styleSheet.getStyleProperty(ElementStyleKeys.MIN_HEIGHT)));
        this.paddingTop.setValue(styleSheet.getStyleProperty(ElementStyleKeys.PADDING_TOP, (Object)Float.valueOf(0.0f)));
        this.paddingLeft.setValue(styleSheet.getStyleProperty(ElementStyleKeys.PADDING_LEFT, (Object)Float.valueOf(0.0f)));
        this.paddingBottom.setValue(styleSheet.getStyleProperty(ElementStyleKeys.PADDING_BOTTOM, (Object)Float.valueOf(0.0f)));
        this.paddingRight.setValue(styleSheet.getStyleProperty(ElementStyleKeys.PADDING_RIGHT, (Object)Float.valueOf(0.0f)));
    }

    public void commitValues(ElementStyleSheet styleSheet) {
        styleSheet.setStyleProperty(ElementStyleKeys.PADDING_TOP, (Object)BorderPropertiesPane.parseLength((Number)this.paddingTop.getValue()));
        styleSheet.setStyleProperty(ElementStyleKeys.PADDING_LEFT, (Object)BorderPropertiesPane.parseLength((Number)this.paddingLeft.getValue()));
        styleSheet.setStyleProperty(ElementStyleKeys.PADDING_BOTTOM, (Object)BorderPropertiesPane.parseLength((Number)this.paddingBottom.getValue()));
        styleSheet.setStyleProperty(ElementStyleKeys.PADDING_RIGHT, (Object)BorderPropertiesPane.parseLength((Number)this.paddingRight.getValue()));
        styleSheet.setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)BorderPropertiesPane.parseLength(this.minimumWidth.getText()));
        styleSheet.setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)BorderPropertiesPane.parseLength(this.minimumHeight.getText()));
        this.borderEditorPanel.commitValues(styleSheet);
    }

    public static String printLength(Number length) {
        if (length == null) {
            return null;
        }
        if (length.floatValue() >= 0.0f) {
            return String.valueOf(length);
        }
        return -length.floatValue() + "%";
    }

    public static Float parseLength(Number value) {
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value != null) {
            return new Float(value.floatValue());
        }
        return null;
    }

    public static Float parseLength(String value) {
        if (value == null) {
            return null;
        }
        try {
            String tvalue = value.trim();
            if (tvalue.length() > 0 && tvalue.charAt(tvalue.length() - 1) == '%') {
                String number = tvalue.substring(0, tvalue.length() - 1);
                return Float.valueOf(Float.parseFloat(number) * -1.0f);
            }
            return Float.valueOf(Float.parseFloat(tvalue));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static class FloatSpinner
    extends JSpinner {
        public FloatSpinner() {
            super(FloatSpinner.createSpinnerModel());
        }

        @Override
        protected JComponent createEditor(SpinnerModel model) {
            return new JSpinner.NumberEditor((JSpinner)this, "0.0##");
        }

        protected static SpinnerNumberModel createSpinnerModel() {
            return new SpinnerNumberModel(new Float(0.0f), new Float(0.0f), new Float(32767.0f), new Float(1.0f));
        }
    }

    private class SelectRightBordersAction
    extends AbstractAction {
        private SelectRightBordersAction() {
            this.putValue("Name", Messages.getString("BorderPropertiesPane.Right", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().clearSelection();
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.TOP_RIGHT);
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.RIGHT);
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.BOTTOM_RIGHT);
        }
    }

    private class SelectLeftBordersAction
    extends AbstractAction {
        private SelectLeftBordersAction() {
            this.putValue("Name", Messages.getString("BorderPropertiesPane.Left", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().clearSelection();
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.TOP_LEFT);
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.LEFT);
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.BOTTOM_LEFT);
        }
    }

    private class SelectVerticalBordersAction
    extends AbstractAction {
        private SelectVerticalBordersAction() {
            this.putValue("Name", Messages.getString("BorderPropertiesPane.Vertical", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().clearSelection();
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.TOP_LEFT);
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.TOP_RIGHT);
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.LEFT);
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.RIGHT);
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.BOTTOM_LEFT);
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.BOTTOM_RIGHT);
        }
    }

    private class SelectHorizontalBordersAction
    extends AbstractAction {
        private SelectHorizontalBordersAction() {
            this.putValue("Name", Messages.getString("BorderPropertiesPane.Horizontal", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().clearSelection();
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.TOP);
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.TOP_LEFT);
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.TOP_RIGHT);
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.BOTTOM);
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.BOTTOM_LEFT);
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.BOTTOM_RIGHT);
        }
    }

    private class SelectAllBordersAction
    extends AbstractAction {
        private SelectAllBordersAction() {
            this.putValue("Name", Messages.getString("BorderPropertiesPane.All", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().clearSelection();
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.TOP);
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.TOP_LEFT);
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.TOP_RIGHT);
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.LEFT);
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.RIGHT);
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.BOTTOM);
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.BOTTOM_LEFT);
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().addSelection(BorderSelection.BOTTOM_RIGHT);
        }
    }

    private class SelectNoneBordersAction
    extends AbstractAction {
        private SelectNoneBordersAction() {
            this.putValue("Name", Messages.getString("BorderPropertiesPane.None", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().clearSelection();
        }
    }

    private class BorderStyleUpdateHandler
    implements ListSelectionListener,
    ActionListener,
    ChangeListener {
        private BorderStyleUpdateHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BorderSelection[] selections = BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().getSelections();
            for (int i = 0; i < selections.length; ++i) {
                BorderSelection borderSelection = selections[i];
                BorderPropertiesPane.this.applyBorder(borderSelection);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            BorderSelection[] selections = BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().getSelections();
            for (int i = 0; i < selections.length; ++i) {
                BorderSelection borderSelection = selections[i];
                BorderPropertiesPane.this.applyBorder(borderSelection);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            BorderSelection[] selections = BorderPropertiesPane.this.borderEditorPanel.getSelectionModel().getSelections();
            for (int i = 0; i < selections.length; ++i) {
                BorderSelection borderSelection = selections[i];
                BorderPropertiesPane.this.applyBorder(borderSelection);
            }
        }
    }

    private class BorderSelectionUpdateHandler
    implements BorderSelectionListener {
        private BorderSelectionUpdateHandler() {
        }

        @Override
        public void selectionAdded(BorderSelectionEvent event) {
            BorderSelection borderSelection = event.getSelection();
            BorderPropertiesPane.this.applyBorder(borderSelection);
        }

        @Override
        public void selectionRemoved(BorderSelectionEvent event) {
        }
    }
}

