/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.format;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.ResolverStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.style.resolver.SimpleStyleResolver;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class EditableStyleSheet
extends ElementStyleSheet {
    private HashSet<StyleKey> editedKeys = new HashSet();
    private HashSet<StyleKey> removedKeys = new HashSet();
    private HashMap<StyleKey, Object> parentValues = new HashMap();

    public void copyParentValues(ElementStyleSheet parent) {
        if (parent != null) {
            StyleKey[] definedPropertyNamesArray = parent.getDefinedPropertyNamesArray();
            for (int i = 0; i < definedPropertyNamesArray.length; ++i) {
                StyleKey styleKey = definedPropertyNamesArray[i];
                if (styleKey == null) continue;
                this.setStyleProperty(styleKey, parent.getStyleProperty(styleKey));
            }
            StyleKey[] propertyKeys = parent.getPropertyKeys();
            for (int i = 0; i < propertyKeys.length; ++i) {
                StyleKey propertyKey = propertyKeys[i];
                this.parentValues.put(propertyKey, parent.getStyleProperty(propertyKey));
            }
        }
        this.editedKeys.clear();
        this.removedKeys.clear();
    }

    public void clearEdits() {
        this.editedKeys.clear();
        this.removedKeys.clear();
        StyleKey[] propertyKeys = this.getPropertyKeys();
        for (int i = 0; i < propertyKeys.length; ++i) {
            StyleKey propertyKey = propertyKeys[i];
            this.parentValues.put(propertyKey, this.getStyleProperty(propertyKey));
        }
    }

    public static EditableStyleSheet create(List<Element> visualElements) {
        return EditableStyleSheet.create(visualElements.toArray(new Element[visualElements.size()]));
    }

    public static EditableStyleSheet create(Element ... visualElements) {
        int i;
        SimpleStyleResolver styleResolver = new SimpleStyleResolver(true);
        StyleKey[] keys = StyleKey.getDefinedStyleKeys();
        Object[] values = new Object[keys.length];
        ResolverStyleSheet[] styles = new ResolverStyleSheet[visualElements.length];
        for (i = 0; i < styles.length; ++i) {
            ResolverStyleSheet style = new ResolverStyleSheet();
            styleResolver.resolve((ReportElement)visualElements[i], style);
            styles[i] = style;
        }
        block1: for (i = 0; i < keys.length; ++i) {
            StyleKey styleKey = keys[i];
            for (int elementIdx = 0; elementIdx < visualElements.length; ++elementIdx) {
                Object o = styles[elementIdx].getStyleProperty(styleKey);
                if (values[i] == null) {
                    values[i] = o;
                    continue;
                }
                if (ObjectUtilities.equal((Object)values[i], (Object)o)) continue;
                values[i] = null;
                continue block1;
            }
        }
        EditableStyleSheet styleSheet = new EditableStyleSheet();
        for (int i2 = 0; i2 < keys.length; ++i2) {
            StyleKey styleKey = keys[i2];
            styleSheet.setStyleProperty(styleKey, values[i2]);
        }
        return styleSheet;
    }

    public void setStyleProperty(StyleKey key, Object value) {
        Object styleProperty = this.parentValues.get(key);
        if (styleProperty == value || ObjectUtilities.equal((Object)styleProperty, (Object)value)) {
            return;
        }
        this.editedKeys.add(key);
        if (value == null) {
            this.removedKeys.add(key);
        } else {
            this.removedKeys.remove(key);
        }
        super.setStyleProperty(key, value);
    }

    public Object getStyleProperty(StyleKey key, Object defaultValue) {
        if (this.removedKeys.contains(key)) {
            return defaultValue;
        }
        return super.getStyleProperty(key, defaultValue);
    }

    public StyleKey[] getDefinedPropertyNamesArray() {
        StyleKey[] keys = this.getPropertyKeys();
        for (int i = 0; i < keys.length; ++i) {
            StyleKey key = keys[i];
            if (this.editedKeys.contains(key)) continue;
            keys[i] = null;
        }
        return keys;
    }
}

