/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.groups;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.editor.ReportDataChangeListener;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.undo.EditGroupUndoEntry;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.libraries.base.util.CSVQuoter;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.bulk.BulkDataProvider;
import org.pentaho.reporting.libraries.designtime.swing.bulk.DefaultBulkListModel;
import org.pentaho.reporting.libraries.designtime.swing.bulk.RemoveBulkAction;
import org.pentaho.reporting.libraries.designtime.swing.bulk.SortBulkDownAction;
import org.pentaho.reporting.libraries.designtime.swing.bulk.SortBulkUpAction;

public class EditGroupDetailsDialog
extends CommonDialog
implements ReportDataChangeListener {
    private DefaultBulkListModel availableFieldsModel;
    private DefaultBulkListModel groupFieldsModel;
    private JTextField nameTextField;
    private JList availableFields;
    private JList groupFields;

    public EditGroupDetailsDialog() throws HeadlessException {
        this.init();
    }

    public EditGroupDetailsDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public EditGroupDetailsDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    protected void init() {
        this.setTitle(Messages.getString("EditGroupDetailsDialog.Title", new Object[0]));
        this.setModal(true);
        this.availableFieldsModel = new DefaultBulkListModel();
        this.groupFieldsModel = new DefaultBulkListModel();
        this.nameTextField = new JTextField(25);
        this.availableFields = new JList(this.availableFieldsModel);
        this.availableFields.setDragEnabled(true);
        this.availableFields.setTransferHandler(new ListTransferHandler(this.availableFields, this.availableFieldsModel));
        this.availableFields.setDropMode(DropMode.ON);
        this.availableFields.addMouseListener(new DoubleClickHandler(this.availableFields.getSelectionModel()));
        this.groupFields = new JList(this.groupFieldsModel);
        this.groupFields.setTransferHandler(new ListTransferHandler(this.groupFields, this.groupFieldsModel));
        this.groupFields.setDragEnabled(true);
        this.groupFields.setDropMode(DropMode.ON);
        super.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.EditGroupDetails";
    }

    protected Component createContentPane() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.createNamePanel(), "North");
        contentPane.add((Component)this.createSelectionPane(), "Center");
        return contentPane;
    }

    protected DefaultBulkListModel getAvailableFieldsModel() {
        return this.availableFieldsModel;
    }

    protected DefaultBulkListModel getGroupFieldsModel() {
        return this.groupFieldsModel;
    }

    public String getGroupName() {
        if (this.nameTextField.getText().length() == 0) {
            return null;
        }
        return this.nameTextField.getText();
    }

    public void setGroupName(String name) {
        this.nameTextField.setText(name);
    }

    public String[] getFields() {
        DefaultBulkListModel data = this.getGroupFieldsModel();
        String[] fields = new String[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            fields[i] = (String)data.get(i);
        }
        return fields;
    }

    public void setFields(String[] groupFields) {
        DefaultBulkListModel data = this.getGroupFieldsModel();
        data.clear();
        for (int i = 0; i < groupFields.length; ++i) {
            data.addElement(groupFields[i]);
        }
    }

    @Override
    public void dataModelChanged(ReportDocumentContext context) {
        String[] columnNames = context.getReportDataSchemaModel().getColumnNames();
        DefaultBulkListModel availableFieldsModel = this.getAvailableFieldsModel();
        availableFieldsModel.clear();
        for (int i = 0; i < columnNames.length; ++i) {
            availableFieldsModel.addElement(columnNames[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean editGroupData(String name, String[] groupFields, ReportDocumentContext reportRenderContext) {
        if (reportRenderContext == null) {
            throw new NullPointerException();
        }
        this.setGroupName(name);
        this.setFields(groupFields);
        try {
            this.nameTextField.setText(name);
            reportRenderContext.addReportDataChangeListener(this);
            this.dataModelChanged(reportRenderContext);
            if (!this.performEdit()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            reportRenderContext.removeReportDataChangeListener(this);
        }
    }

    public EditGroupUndoEntry editGroup(RelationalGroup group, ReportDocumentContext reportRenderContext, boolean addGroup) {
        if (addGroup) {
            this.setTitle(Messages.getString("EditGroupDetailsDialog.AddTitle", new Object[0]));
        } else {
            this.setTitle(Messages.getString("EditGroupDetailsDialog.Title", new Object[0]));
        }
        String oldName = group.getName();
        String[] oldFields = group.getFieldsArray();
        if (this.editGroupData(oldName, oldFields, reportRenderContext)) {
            return new EditGroupUndoEntry(group.getObjectID(), oldName, this.getGroupName(), oldFields, this.getFields());
        }
        return null;
    }

    private JPanel createNamePanel() {
        JPanel theNamePanel = new JPanel(new FlowLayout(0, 5, 5));
        theNamePanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        theNamePanel.add(new JLabel(Messages.getString("EditGroupDetailsDialog.Name", new Object[0])));
        theNamePanel.add(this.nameTextField);
        return theNamePanel;
    }

    private JPanel createSelectionPane() {
        BorderlessButton columnsAdd = new BorderlessButton((Action)new AddSelectionAction(this.availableFields.getSelectionModel()));
        JLabel columnsLabel = new JLabel(Messages.getString("EditGroupDetailsDialog.SelectedItems", new Object[0]));
        ListSelectionModel columnsSelectionModel = this.groupFields.getSelectionModel();
        BorderlessButton columnsSortUp = new BorderlessButton((Action)new SortBulkUpAction((BulkDataProvider)this.groupFieldsModel, columnsSelectionModel));
        BorderlessButton columnsSortDown = new BorderlessButton((Action)new SortBulkDownAction((BulkDataProvider)this.groupFieldsModel, columnsSelectionModel));
        BorderlessButton columnsRemove = new BorderlessButton((Action)new RemoveBulkAction((BulkDataProvider)this.groupFieldsModel, columnsSelectionModel));
        JPanel tablesPane = new JPanel();
        tablesPane.setLayout(new GridBagLayout());
        JLabel tablesColumnsLabel = new JLabel(Messages.getString("EditGroupDetailsDialog.AvailableFields", new Object[0]));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        tablesPane.add((Component)tablesColumnsLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weighty = 5.0;
        gbc.gridheight = 1;
        gbc.weightx = 2.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 5, 5, 5);
        JScrollPane comp = new JScrollPane(this.availableFields, 20, 30);
        tablesPane.add((Component)comp, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)columnsLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)columnsSortUp, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)columnsSortDown, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)columnsRemove, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 4;
        gbc.insets = new Insets(0, 5, 5, 0);
        tablesPane.add((Component)new JScrollPane(this.groupFields, 20, 30), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.insets = new Insets(5, 5, 5, 0);
        tablesPane.add((Component)columnsAdd, gbc);
        return tablesPane;
    }

    private class ListTransferHandler
    extends TransferHandler {
        private JList targetList;
        private DefaultBulkListModel listModel;

        private ListTransferHandler(JList targetList, DefaultBulkListModel listModel) {
            this.targetList = targetList;
            this.listModel = listModel;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!support.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return false;
            }
            if (!support.isDrop()) {
                return false;
            }
            try {
                String transferData = (String)support.getTransferable().getTransferData(DataFlavor.stringFlavor);
                if (transferData == null) {
                    return false;
                }
                CSVTokenizer tokenizer = new CSVTokenizer(transferData, ",", "\"");
                ArrayList<String> items = new ArrayList<String>();
                while (tokenizer.hasMoreElements()) {
                    items.add(tokenizer.nextToken());
                }
                TransferHandler.DropLocation dropLocation = support.getDropLocation();
                Point point = dropLocation.getDropPoint();
                int idx = this.targetList.locationToIndex(point);
                if (idx == -1) {
                    for (int i = 0; i < items.size(); ++i) {
                        String item = (String)items.get(i);
                        this.listModel.addElement((Object)item);
                    }
                } else {
                    for (int i = items.size() - 1; i >= 0; --i) {
                        String item = (String)items.get(i);
                        this.listModel.add(idx, (Object)item);
                    }
                }
            }
            catch (Exception e) {
                UncaughtExceptionsModel.getInstance().addException(e);
            }
            return super.importData(support);
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDrop()) {
                return false;
            }
            return support.isDataFlavorSupported(DataFlavor.stringFlavor);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            JList lcomp = (JList)c;
            StringBuilder b = new StringBuilder();
            CSVQuoter quoter = new CSVQuoter(',', '\"');
            Object[] selectedValues = lcomp.getSelectedValues();
            for (int i = 0; i < selectedValues.length; ++i) {
                if (i != 0) {
                    b.append(',');
                }
                Object value = selectedValues[i];
                b.append(quoter.doQuoting(String.valueOf(value)));
            }
            return new StringSelection(b.toString());
        }
    }

    private class DoubleClickHandler
    extends MouseAdapter {
        private ListSelectionModel selectionModel;

        private DoubleClickHandler(ListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                DefaultBulkListModel data = EditGroupDetailsDialog.this.getGroupFieldsModel();
                DefaultBulkListModel fields = EditGroupDetailsDialog.this.getAvailableFieldsModel();
                for (int i = 0; i < fields.getSize(); ++i) {
                    if (!this.selectionModel.isSelectedIndex(i)) continue;
                    data.addElement(fields.getElementAt(i));
                }
            }
        }
    }

    private class AddSelectionAction
    extends AbstractAction
    implements ListSelectionListener {
        private ListSelectionModel selectionModel;

        private AddSelectionAction(ListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
            this.putValue("SmallIcon", IconLoader.getInstance().getFowardArrowIcon());
            this.putValue("ShortDescription", Messages.getString("EditGroupDetailsDialog.AddColumn", new Object[0]));
            selectionModel.addListSelectionListener(this);
            this.setEnabled(!selectionModel.isSelectionEmpty());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!this.selectionModel.isSelectionEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultBulkListModel data = EditGroupDetailsDialog.this.getGroupFieldsModel();
            DefaultBulkListModel fields = EditGroupDetailsDialog.this.getAvailableFieldsModel();
            for (int i = 0; i < fields.getSize(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                data.addElement(fields.getElementAt(i));
            }
        }
    }
}

