/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.groups;

import java.util.ArrayList;
import java.util.HashMap;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.groups.GroupDataEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.SubGroupBody;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class EditGroupsUndoEntry
implements UndoEntry {
    private GroupDataEntry[] oldGroupData;
    private GroupDataEntry[] newGroupData;

    public EditGroupsUndoEntry(GroupDataEntry[] oldGroupData, GroupDataEntry[] newGroupData) {
        this.oldGroupData = oldGroupData;
        this.newGroupData = newGroupData;
    }

    @Override
    public void undo(ReportDocumentContext renderContext) {
        EditGroupsUndoEntry.applyGroupData(renderContext.getReportDefinition(), this.oldGroupData);
    }

    @Override
    public void redo(ReportDocumentContext renderContext) {
        EditGroupsUndoEntry.applyGroupData(renderContext.getReportDefinition(), this.newGroupData);
    }

    @Override
    public UndoEntry merge(UndoEntry newEntry) {
        return null;
    }

    public static GroupDataEntry[] buildGroupData(AbstractReportDefinition abstractReportDefinition) {
        Group group = abstractReportDefinition.getRootGroup();
        ArrayList<GroupDataEntry> data = new ArrayList<GroupDataEntry>();
        while (group instanceof RelationalGroup) {
            RelationalGroup rgroup = (RelationalGroup)group;
            data.add(new GroupDataEntry(group.getObjectID(), group.getName(), rgroup.getFieldsArray()));
            GroupBody body = rgroup.getBody();
            if (body instanceof SubGroupBody) {
                SubGroupBody subGroupBody = (SubGroupBody)body;
                group = subGroupBody.getGroup();
                continue;
            }
            group = null;
        }
        return data.toArray(new GroupDataEntry[data.size()]);
    }

    public static void applyGroupData(AbstractReportDefinition abstractReportDefinition, GroupDataEntry[] newEntries) {
        HashMap<InstanceID, RelationalGroup> groups = new HashMap<InstanceID, RelationalGroup>();
        RelationalGroup innermostGroup = null;
        Group group = abstractReportDefinition.getRootGroup();
        while (group instanceof RelationalGroup) {
            RelationalGroup rgroup;
            innermostGroup = rgroup = (RelationalGroup)group;
            groups.put(group.getObjectID(), rgroup);
            GroupBody body = rgroup.getBody();
            if (body instanceof SubGroupBody) {
                SubGroupBody subGroupBody = (SubGroupBody)body;
                group = subGroupBody.getGroup();
                continue;
            }
            group = null;
        }
        RelationalGroup[] resultGroups = new RelationalGroup[newEntries.length];
        for (int i = 0; i < newEntries.length; ++i) {
            GroupDataEntry o = newEntries[i];
            RelationalGroup sourceGroup = (RelationalGroup)groups.get(o.getInstanceID());
            resultGroups[i] = sourceGroup == null ? new RelationalGroup() : sourceGroup;
            resultGroups[i].setName(o.getName());
            resultGroups[i].setFieldsArray(o.getFields());
        }
        Object innermostBody = innermostGroup == null ? new SubGroupBody(abstractReportDefinition.getRootGroup()) : innermostGroup.getBody();
        if (resultGroups.length > 0) {
            for (int i = 0; i < resultGroups.length; ++i) {
                SubGroupBody sgb;
                RelationalGroup resultGroup = resultGroups[i];
                if (i == 0) {
                    abstractReportDefinition.setRootGroup((Group)resultGroup);
                    continue;
                }
                RelationalGroup prevGroup = resultGroups[i - 1];
                GroupBody body = prevGroup.getBody();
                if (body instanceof SubGroupBody) {
                    sgb = (SubGroupBody)body;
                    sgb.setGroup((Group)resultGroup);
                    continue;
                }
                sgb = new SubGroupBody();
                sgb.setGroup((Group)resultGroup);
                prevGroup.setBody((GroupBody)sgb);
            }
            resultGroups[resultGroups.length - 1].setBody(innermostBody);
        } else {
            RelationalGroup relationalGroup = new RelationalGroup();
            relationalGroup.setBody(innermostBody);
            abstractReportDefinition.setRootGroup((Group)relationalGroup);
        }
    }
}

