/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.parameters;

import java.awt.Component;
import java.awt.Image;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.pentaho.reporting.designer.core.editor.parameters.DataFactoryWrapper;
import org.pentaho.reporting.designer.core.editor.parameters.Messages;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;

public class DataFactoryTreeCellRenderer
extends DefaultTreeCellRenderer {
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.setToolTipText(null);
        if (value == tree.getModel().getRoot()) {
            this.setText("<ROOT> (should be invisible)");
            return this;
        }
        if (value instanceof DataFactoryWrapper) {
            String connectionName;
            DataFactoryWrapper wrapper = (DataFactoryWrapper)value;
            if (wrapper.isRemoved()) {
                throw new IllegalArgumentException("Try to render a node that has been removed.");
            }
            DataFactory dfac = wrapper.getEditedDataFactory();
            DataFactoryMetaData data = dfac.getMetaData();
            Image image = data.getIcon(Locale.getDefault(), 2);
            if (image != null) {
                this.setIcon(new ImageIcon(image));
            }
            if ((connectionName = data.getDisplayConnectionName(dfac)) != null) {
                this.setText(Messages.getString("DataFactoryTreeCellRenderer.DataFactoryWithName", data.getDisplayName(Locale.getDefault()), connectionName));
            } else {
                this.setText(Messages.getString("DataFactoryTreeCellRenderer.DataFactoryWithoutName", data.getDisplayName(Locale.getDefault())));
            }
        }
        return this;
    }
}

