/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.report.layouting.ElementRenderer;
import org.pentaho.reporting.designer.core.util.CanvasImageLoader;

public class ResizeRootBandComponent
extends JPanel {
    private boolean mousePressed;
    private boolean mouseInside;
    private Color hoverColor;
    private Color normalColor;
    private Border hoverBorder;
    private Border normalBorder;
    private ElementRenderer rootBandRenderer;
    private ReportDocumentContext renderContext;
    private boolean linealComponent;

    public ResizeRootBandComponent(boolean linealComponent, ElementRenderer renderer, ReportDocumentContext renderContext) {
        if (renderer == null) {
            throw new NullPointerException();
        }
        if (renderContext == null) {
            throw new NullPointerException();
        }
        this.linealComponent = linealComponent;
        this.renderContext = renderContext;
        this.rootBandRenderer = renderer;
        if (linealComponent) {
            this.normalColor = new Color(212, 212, 212);
            this.normalBorder = BorderFactory.createLineBorder(new Color(188, 188, 188), 1);
            this.hoverColor = new Color(212, 212, 212);
            this.hoverBorder = BorderFactory.createLineBorder(new Color(128, 128, 128), 1);
        } else {
            this.normalColor = new Color(255, 255, 255, 0);
            this.hoverColor = new Color(255, 255, 255, 0);
            this.hoverBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            this.normalBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        }
        this.setOpaque(false);
        this.setBorder(this.normalBorder);
        this.setMinimumSize(new Dimension(6, 4));
        this.setPreferredSize(new Dimension(6, 4));
        this.setBackground(this.normalColor);
        MouseUpdateHandler handler = new MouseUpdateHandler();
        this.addMouseListener(handler);
        this.addMouseMotionListener(handler);
        this.setCursor(Cursor.getPredefinedCursor(8));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.linealComponent) {
            g.setColor(Color.WHITE);
            g.fillRect(this.getWidth() - 15, 0, this.getWidth(), this.getHeight());
            ImageIcon leftBorder = CanvasImageLoader.getInstance().getLeftShadowImage();
            g.drawImage(leftBorder.getImage(), this.getWidth() - 23, 0, leftBorder.getIconWidth(), this.getHeight(), null);
            g.setColor(Color.DARK_GRAY);
            g.drawLine(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
        }
    }

    protected void updateState(boolean mousePressed, boolean mouseInside) {
        this.mousePressed = mousePressed;
        this.mouseInside = mouseInside;
        if (mouseInside || this.mousePressed) {
            this.setBorder(this.hoverBorder);
            this.setBackground(this.hoverColor);
        } else {
            this.setBorder(this.normalBorder);
            this.setBackground(this.normalColor);
        }
        this.repaint();
    }

    public boolean isMouseInside() {
        return this.mouseInside;
    }

    public boolean isMousePressed() {
        return this.mousePressed;
    }

    public ElementRenderer getRootBandRenderer() {
        return this.rootBandRenderer;
    }

    protected ReportDocumentContext getRenderContext() {
        return this.renderContext;
    }

    private class MouseUpdateHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private int startPosition;

        private MouseUpdateHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.startPosition = e.getY();
            ResizeRootBandComponent.this.updateState(true, ResizeRootBandComponent.this.isMouseInside());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.startPosition = -1;
            ResizeRootBandComponent.this.updateState(false, ResizeRootBandComponent.this.isMouseInside());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ResizeRootBandComponent.this.updateState(ResizeRootBandComponent.this.isMousePressed(), true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ResizeRootBandComponent.this.updateState(ResizeRootBandComponent.this.isMousePressed(), false);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int diff = this.startPosition - e.getY();
            ElementRenderer rootBandRenderer = ResizeRootBandComponent.this.getRootBandRenderer();
            float zoomAsPercentage = ResizeRootBandComponent.this.getRenderContext().getZoomModel().getZoomAsPercentage();
            double height = rootBandRenderer.getVisualHeight() - (double)((float)diff / zoomAsPercentage);
            if (height < 0.0) {
                return;
            }
            rootBandRenderer.setVisualHeight(height);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

