/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report;

import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateSimpleStructureProcessStep;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;

public class SelectLayoutNodes
extends IterateSimpleStructureProcessStep {
    private static final Log logger = LogFactory.getLog(SelectLayoutNodes.class);
    private HashSet<InstanceID> ids = new HashSet();
    private StrictBounds bounds;

    public StrictBounds select(HashSet<InstanceID> ids, LogicalPageBox box, Section section) {
        if (ids == null) {
            throw new NullPointerException();
        }
        this.ids.clear();
        this.ids.addAll(ids);
        this.bounds = null;
        this.startProcessing((RenderNode)box);
        if (this.bounds == null) {
            this.recurse(box, section.getParentSection());
            if (this.bounds == null) {
                return new StrictBounds();
            }
        }
        return this.bounds;
    }

    private void recurse(LogicalPageBox box, Section section) {
        if (section != null) {
            this.ids.clear();
            this.ids.add(section.getObjectID());
            this.bounds = null;
            this.startProcessing((RenderNode)box);
            if (this.bounds == null) {
                this.recurse(box, section.getParentSection());
                return;
            }
            this.bounds.setRect(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), 0L);
        }
    }

    private boolean isValidDrawTarget(RenderNode node) {
        while (node != null) {
            if (this.ids.contains(node.getInstanceId())) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    protected void processOtherNode(RenderNode node) {
        if (this.isValidDrawTarget(node)) {
            if (this.bounds == null) {
                this.bounds = new StrictBounds(node.getX(), node.getY(), node.getWidth(), node.getHeight());
            } else {
                this.bounds.add(node.getX(), node.getY(), node.getWidth(), node.getHeight());
            }
        }
    }

    protected boolean startBox(RenderBox box) {
        if (this.isValidDrawTarget((RenderNode)box)) {
            if (this.bounds == null) {
                this.bounds = new StrictBounds(box.getX(), box.getY(), box.getWidth(), box.getHeight());
            } else {
                this.bounds.add(box.getX(), box.getY(), box.getWidth(), box.getHeight());
            }
        }
        return true;
    }
}

