/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import org.pentaho.reporting.designer.core.model.CachedLayoutData;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.DrawSelectionType;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public class SelectionOverlayInformation {
    private static final Color SELECTION_COLOR = Color.BLUE;
    private double zoomFactor;
    private Element selectedElement;
    private Rectangle2D.Double elementBounds;
    private Rectangle2D.Double nearRangeElementBounds;
    private long layoutAge;
    private static final BasicStroke DOTTED_STROKE = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{2.0f, 2.0f}, 1.0f);
    private static final int SELECTION_RANGE = 3;
    private CachedLayoutData selectedElementData;

    public SelectionOverlayInformation(Element selectedElement) {
        this.selectedElement = selectedElement;
        this.selectedElementData = ModelUtility.getCachedLayoutData(selectedElement);
        this.elementBounds = new Rectangle2D.Double();
        this.nearRangeElementBounds = new Rectangle2D.Double();
        this.layoutAge = -1L;
    }

    public Element getSelectedElement() {
        return this.selectedElement;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void validate(double zoomFactor) {
        double oldZoom = this.zoomFactor;
        if (oldZoom != zoomFactor || this.layoutAge != this.selectedElementData.getLayoutAge()) {
            this.zoomFactor = zoomFactor;
            this.layoutAge = this.selectedElementData.getLayoutAge();
            double x = StrictGeomUtility.toExternalValue((long)this.selectedElementData.getX());
            double y = StrictGeomUtility.toExternalValue((long)this.selectedElementData.getY());
            double width = StrictGeomUtility.toExternalValue((long)this.selectedElementData.getWidth());
            double height = StrictGeomUtility.toExternalValue((long)this.selectedElementData.getHeight());
            this.elementBounds.setFrame(x * zoomFactor, y * zoomFactor, width * zoomFactor, height * zoomFactor);
            this.nearRangeElementBounds.setFrame(this.elementBounds.getX() - 3.0, this.elementBounds.getY() - 3.0, this.elementBounds.getWidth() + 6.0, this.elementBounds.getHeight() + 6.0);
        }
    }

    public InRangeIndicator getMouseInRangeIndicator(Point2D normalizedPoint) {
        double y;
        double x = normalizedPoint.getX() * this.zoomFactor;
        if (!this.nearRangeElementBounds.contains(x, y = normalizedPoint.getY() * this.zoomFactor)) {
            return InRangeIndicator.NOT_IN_RANGE;
        }
        if (this.isNear(x, this.elementBounds.getX())) {
            if (this.isNear(y, this.elementBounds.getY())) {
                return InRangeIndicator.TOP_LEFT;
            }
            if (this.isNear(y, this.elementBounds.getY() + this.elementBounds.getHeight() / 2.0)) {
                return InRangeIndicator.MIDDLE_LEFT;
            }
            if (this.isNear(y, this.elementBounds.getY() + this.elementBounds.getHeight())) {
                return InRangeIndicator.BOTTOM_LEFT;
            }
        } else if (this.isNear(x, this.elementBounds.getX() + this.elementBounds.getWidth() / 2.0)) {
            if (this.isNear(y, this.elementBounds.getY())) {
                return InRangeIndicator.TOP_CENTER;
            }
            if (this.isNear(y, this.elementBounds.getY() + this.elementBounds.getHeight())) {
                return InRangeIndicator.BOTTOM_CENTER;
            }
        } else if (this.isNear(x, this.elementBounds.getX() + this.elementBounds.getWidth())) {
            if (this.isNear(y, this.elementBounds.getY())) {
                return InRangeIndicator.TOP_RIGHT;
            }
            if (this.isNear(y, this.elementBounds.getY() + this.elementBounds.getHeight() / 2.0)) {
                return InRangeIndicator.MIDDLE_RIGHT;
            }
            if (this.isNear(y, this.elementBounds.getY() + this.elementBounds.getHeight())) {
                return InRangeIndicator.BOTTOM_RIGHT;
            }
        }
        if (!this.elementContainsPoint(x, y)) {
            return InRangeIndicator.NOT_IN_RANGE;
        }
        return InRangeIndicator.MOVE;
    }

    private boolean elementContainsPoint(double x, double y) {
        if (this.elementBounds.contains(x, y)) {
            return true;
        }
        return this.elementBounds.getHeight() < 1.0 || this.elementBounds.getWidth() < 1.0;
    }

    private boolean isNear(double location, double center) {
        return Math.abs(location - center) < 3.0;
    }

    public void draw(Graphics2D g2, ImageObserver obs) {
        g2.setStroke(new BasicStroke(1.0f));
        if (WorkspaceSettings.getInstance().isAlwaysDrawElementFrames()) {
            g2.setColor(Color.LIGHT_GRAY);
            g2.draw(this.elementBounds);
        }
        if (this.selectedElement instanceof RootLevelBand) {
            return;
        }
        DrawSelectionType type = WorkspaceSettings.getInstance().getDrawSelectionType();
        if (type == DrawSelectionType.CLAMP) {
            g2.setColor(SELECTION_COLOR);
            this.drawClampRectangle(g2, this.elementBounds);
        } else if (type == DrawSelectionType.OUTLINE) {
            g2.setColor(Color.GRAY);
            g2.setStroke(DOTTED_STROKE);
            g2.draw(this.elementBounds);
            Image img = IconLoader.getInstance().getSelectionEdge().getImage();
            int halfWidth = img.getWidth(null) / 2;
            int halfHeight = img.getHeight(null) / 2;
            int leftEdge = -halfWidth + (int)this.elementBounds.getX();
            int rightEdge = -halfWidth + (int)(this.elementBounds.getX() + this.elementBounds.getWidth());
            int bottomEdge = -halfHeight + (int)(this.elementBounds.getY() + this.elementBounds.getHeight());
            int centerHeight = -halfHeight + (int)(this.elementBounds.getY() + this.elementBounds.getHeight() / 2.0);
            int centerWidth = -halfWidth + (int)(this.elementBounds.getX() + this.elementBounds.getWidth() / 2.0);
            int topEdge = -halfHeight + (int)this.elementBounds.getY();
            g2.drawImage(img, leftEdge, topEdge, obs);
            g2.drawImage(img, centerWidth, topEdge, obs);
            g2.drawImage(img, rightEdge, topEdge, obs);
            g2.drawImage(img, leftEdge, centerHeight, obs);
            g2.drawImage(img, rightEdge, centerHeight, obs);
            g2.drawImage(img, leftEdge, bottomEdge, obs);
            g2.drawImage(img, centerWidth, bottomEdge, obs);
            g2.drawImage(img, rightEdge, bottomEdge, obs);
        }
    }

    private void drawClampRectangle(Graphics2D g2d, Rectangle2D rect) {
        double x = rect.getX();
        int x1 = (int)x;
        int y1 = (int)rect.getY();
        g2d.drawLine(x1, y1, x1 + 3, y1);
        g2d.drawLine(x1, y1, x1, y1 + 3);
        double width = rect.getWidth();
        double centerX = x + width / 2.0;
        g2d.drawLine((int)centerX - 2, y1, (int)centerX + 2, y1);
        g2d.drawLine((int)centerX, y1 + 1, (int)centerX, y1 + 2);
        double x2 = x + width;
        g2d.drawLine((int)(x2 - 3.0), y1, (int)x2, y1);
        g2d.drawLine((int)x2, y1, (int)x2, y1 + 3);
        double centerY = rect.getY() + rect.getHeight() / 2.0;
        g2d.drawLine(x1, (int)centerY - 2, x1, (int)centerY + 2);
        g2d.drawLine(x1 + 1, (int)centerY, x1 + 2, (int)centerY);
        g2d.drawLine((int)x2, (int)centerY - 2, (int)x2, (int)centerY + 2);
        g2d.drawLine((int)(x2 - 2.0), (int)centerY, (int)x2 - 1, (int)centerY);
        double y2 = rect.getY() + rect.getHeight();
        g2d.drawLine(x1, (int)(y2 - 3.0), x1, (int)y2);
        g2d.drawLine(x1, (int)y2, x1 + 3, (int)y2);
        g2d.drawLine((int)centerX - 2, (int)y2, (int)centerX + 2, (int)y2);
        g2d.drawLine((int)centerX, (int)y2 - 2, (int)centerX, (int)y2 - 1);
        g2d.drawLine((int)(x2 - 3.0), (int)y2, (int)x2, (int)y2);
        g2d.drawLine((int)x2, (int)(y2 - 3.0), (int)x2, (int)y2);
    }

    public String toString() {
        return "org.pentaho.reporting.designer.core.editor.report.SelectionOverlayInformation{zoomFactor=" + this.zoomFactor + ", selectedElement=" + this.selectedElement + ", elementBounds=" + this.elementBounds + ", layoutAge=" + this.layoutAge + '}';
    }

    public static enum InRangeIndicator {
        NOT_IN_RANGE,
        MOVE,
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        MIDDLE_LEFT,
        MIDDLE_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;

    }
}

