/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.drag;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.pentaho.reporting.designer.core.editor.report.drag.MouseDragOperation;
import org.pentaho.reporting.designer.core.editor.report.snapping.SnapPositionsModel;
import org.pentaho.reporting.designer.core.model.CachedLayoutData;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public abstract class AbstractMouseDragOperation
implements MouseDragOperation {
    private Element[] selectedVisualElements;
    private long[] elementX;
    private long[] elementY;
    private long[] elementWidth;
    private long[] elementHeight;
    private SnapPositionsModel horizontalSnapModel;
    private SnapPositionsModel verticalSnapModel;
    private long originPointX;
    private long originPointY;

    protected AbstractMouseDragOperation(List<Element> selectedVisualElements, Point2D originPoint, SnapPositionsModel horizontalSnapModel, SnapPositionsModel verticalSnapModel) {
        Element element;
        int i;
        ArrayList<Element> nonDescendants = new ArrayList<Element>(selectedVisualElements.size());
        for (i = 0; i < selectedVisualElements.size(); ++i) {
            element = selectedVisualElements.get(i);
            if (this.isDescendant(element, selectedVisualElements)) continue;
            nonDescendants.add(element);
        }
        this.selectedVisualElements = nonDescendants.toArray(new Element[nonDescendants.size()]);
        this.originPointX = StrictGeomUtility.toInternalValue((double)originPoint.getX());
        this.originPointY = StrictGeomUtility.toInternalValue((double)originPoint.getY());
        this.horizontalSnapModel = horizontalSnapModel;
        this.verticalSnapModel = verticalSnapModel;
        this.elementX = new long[this.selectedVisualElements.length];
        this.elementY = new long[this.selectedVisualElements.length];
        this.elementWidth = new long[this.selectedVisualElements.length];
        this.elementHeight = new long[this.selectedVisualElements.length];
        for (i = 0; i < this.selectedVisualElements.length; ++i) {
            element = this.selectedVisualElements[i];
            CachedLayoutData data = ModelUtility.getCachedLayoutData(element);
            this.elementX[i] = data.getX();
            this.elementY[i] = data.getY();
            this.elementWidth[i] = data.getWidth();
            this.elementHeight[i] = data.getHeight();
        }
    }

    protected boolean isDescendant(Element element, List<Element> elements) {
        HashSet<Section> parents = new HashSet<Section>();
        for (Section parent = element.getParentSection(); parent != null; parent = parent.getParent()) {
            parents.add(parent);
        }
        for (Element visualReportElement : elements) {
            if (element == visualReportElement) continue;
            if (visualReportElement instanceof AbstractReportDefinition) {
                return false;
            }
            if (visualReportElement instanceof RootLevelBand) {
                return true;
            }
            if (!parents.contains(visualReportElement)) continue;
            return true;
        }
        return false;
    }

    public Element[] getSelectedVisualElements() {
        return this.selectedVisualElements;
    }

    public long[] getElementX() {
        return this.elementX;
    }

    public long[] getElementY() {
        return this.elementY;
    }

    public long[] getElementWidth() {
        return this.elementWidth;
    }

    public long[] getElementHeight() {
        return this.elementHeight;
    }

    public SnapPositionsModel getHorizontalSnapModel() {
        return this.horizontalSnapModel;
    }

    public SnapPositionsModel getVerticalSnapModel() {
        return this.verticalSnapModel;
    }

    public long getOriginPointX() {
        return this.originPointX;
    }

    public long getOriginPointY() {
        return this.originPointY;
    }

    protected boolean isCanvasElement(Element reportElement) {
        ElementStyleSheet styleSheet = reportElement.getStyle();
        Object o = styleSheet.getStyleProperty(BandStyleKeys.LAYOUT);
        if ("canvas".equals(o)) {
            return true;
        }
        return o == null;
    }
}

