/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.drag;

import java.awt.geom.Point2D;
import java.util.List;
import org.pentaho.reporting.designer.core.editor.report.drag.AbstractMouseDragOperation;
import org.pentaho.reporting.designer.core.editor.report.snapping.SnapPositionsModel;
import org.pentaho.reporting.designer.core.model.CachedLayoutData;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public class ResizeBottomDragOperation
extends AbstractMouseDragOperation {
    private long snapThreshold = WorkspaceSettings.getInstance().getSnapThreshold();

    public ResizeBottomDragOperation(List<Element> selectedVisualElements, Point2D originPoint, SnapPositionsModel horizontalSnapModel, SnapPositionsModel verticalSnapModel) {
        super(selectedVisualElements, originPoint, horizontalSnapModel, verticalSnapModel);
    }

    @Override
    public void update(Point2D normalizedPoint, double zoomFactor) {
        SnapPositionsModel verticalSnapModel = this.getVerticalSnapModel();
        Element[] selectedVisualElements = this.getSelectedVisualElements();
        long originPointY = this.getOriginPointY();
        long[] elementHeight = this.getElementHeight();
        long py = StrictGeomUtility.toInternalValue((double)normalizedPoint.getY());
        long dy = py - originPointY;
        for (int i = 0; i < selectedVisualElements.length; ++i) {
            Element element = selectedVisualElements[i];
            if (element instanceof RootLevelBand) continue;
            ElementStyleSheet styleSheet = element.getStyle();
            double elementMinHeight = styleSheet.getDoubleStyleProperty(ElementStyleKeys.MIN_HEIGHT, 0.0);
            long targetheight = elementHeight[i] + dy;
            CachedLayoutData data = ModelUtility.getCachedLayoutData(element);
            long elementY = data.getY();
            long targetY2 = elementY + targetheight;
            if (elementMinHeight >= 0.0) {
                float position;
                long localHeight;
                long snapPosition = verticalSnapModel.getNearestSnapPosition(targetY2, element.getObjectID());
                if (Math.abs(snapPosition - targetY2) > this.snapThreshold) {
                    localHeight = Math.max(0L, targetY2 - elementY);
                    position = (float)StrictGeomUtility.toExternalValue((long)localHeight);
                    styleSheet.setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(position));
                } else {
                    localHeight = Math.max(0L, snapPosition - elementY);
                    position = (float)StrictGeomUtility.toExternalValue((long)localHeight);
                    styleSheet.setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(position));
                }
            } else {
                Section parent = element.getParentSection();
                CachedLayoutData parentData = ModelUtility.getCachedLayoutData((Element)parent);
                long parentBase = this.isCanvasElement((Element)parent) ? parentData.getHeight() : parentData.getWidth();
                if (parentBase > 0L) {
                    long percentage;
                    long localHeight;
                    long snapPosition = verticalSnapModel.getNearestSnapPosition(targetY2, element.getObjectID());
                    if (Math.abs(snapPosition - targetY2) > this.snapThreshold) {
                        localHeight = Math.max(0L, targetY2 - elementY);
                        percentage = StrictGeomUtility.toInternalValue((double)(localHeight * 100L / parentBase));
                        styleSheet.setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(StrictGeomUtility.toExternalValue((long)(-percentage))));
                    } else {
                        localHeight = Math.max(0L, snapPosition - elementY);
                        percentage = StrictGeomUtility.toInternalValue((double)(localHeight * 100L / parentBase));
                        styleSheet.setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(StrictGeomUtility.toExternalValue((long)(-percentage))));
                    }
                }
            }
            element.notifyNodePropertiesChanged();
        }
    }

    @Override
    public void finish() {
    }
}

