/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.drag;

import java.awt.geom.Point2D;
import java.util.List;
import org.pentaho.reporting.designer.core.editor.report.drag.AbstractMouseDragOperation;
import org.pentaho.reporting.designer.core.editor.report.snapping.SnapPositionsModel;
import org.pentaho.reporting.designer.core.model.CachedLayoutData;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public class ResizeLeftDragOperation
extends AbstractMouseDragOperation {
    private long snapThreshold = WorkspaceSettings.getInstance().getSnapThreshold();

    public ResizeLeftDragOperation(List<Element> selectedVisualElements, Point2D originPoint, SnapPositionsModel horizontalSnapModel, SnapPositionsModel verticalSnapModel) {
        super(selectedVisualElements, originPoint, horizontalSnapModel, verticalSnapModel);
    }

    @Override
    public void update(Point2D normalizedPoint, double zoomFactor) {
        SnapPositionsModel horizontalSnapModel = this.getHorizontalSnapModel();
        Element[] selectedVisualElements = this.getSelectedVisualElements();
        long originPointX = this.getOriginPointX();
        long[] elementWidth = this.getElementWidth();
        long[] elementX = this.getElementX();
        long px = StrictGeomUtility.toInternalValue((double)normalizedPoint.getX());
        long dx = px - originPointX;
        for (int i = 0; i < selectedVisualElements.length; ++i) {
            long computedPositionX;
            Element element = selectedVisualElements[i];
            if (element instanceof RootLevelBand) continue;
            ElementStyleSheet styleSheet = element.getStyle();
            double definedElementX = styleSheet.getDoubleStyleProperty(ElementStyleKeys.POS_X, 0.0);
            long targetPositionX = elementX[i] + dx;
            Section parent = element.getParentSection();
            CachedLayoutData parentData = ModelUtility.getCachedLayoutData((Element)parent);
            long layoutedParentX = parentData.getX();
            if (targetPositionX < layoutedParentX) continue;
            if (definedElementX >= 0.0) {
                float position;
                long localXPosition;
                long snapPosition = horizontalSnapModel.getNearestSnapPosition(targetPositionX, element.getObjectID());
                if (Math.abs(snapPosition - targetPositionX) > this.snapThreshold) {
                    computedPositionX = targetPositionX;
                    localXPosition = Math.max(0L, targetPositionX - layoutedParentX);
                    position = (float)StrictGeomUtility.toExternalValue((long)localXPosition);
                    styleSheet.setStyleProperty(ElementStyleKeys.POS_X, (Object)new Float(position));
                } else {
                    computedPositionX = snapPosition;
                    localXPosition = Math.max(0L, snapPosition - layoutedParentX);
                    position = (float)StrictGeomUtility.toExternalValue((long)localXPosition);
                    styleSheet.setStyleProperty(ElementStyleKeys.POS_X, (Object)new Float(position));
                }
            } else {
                long localXPosition;
                long parentBase = parentData.getWidth();
                if (parentBase <= 0L) continue;
                long snapPosition = horizontalSnapModel.getNearestSnapPosition(targetPositionX, element.getObjectID());
                if (Math.abs(snapPosition - targetPositionX) > this.snapThreshold) {
                    computedPositionX = targetPositionX;
                    localXPosition = Math.max(0L, targetPositionX - layoutedParentX);
                    long percentage = StrictGeomUtility.toInternalValue((double)(localXPosition * 100L / parentBase));
                    styleSheet.setStyleProperty(ElementStyleKeys.POS_X, (Object)new Float(StrictGeomUtility.toExternalValue((long)(-percentage))));
                } else {
                    computedPositionX = snapPosition;
                    localXPosition = Math.max(0L, snapPosition - layoutedParentX);
                    long percentage = StrictGeomUtility.toInternalValue((double)(localXPosition * 100L / parentBase));
                    styleSheet.setStyleProperty(ElementStyleKeys.POS_X, (Object)new Float(StrictGeomUtility.toExternalValue((long)(-percentage))));
                }
            }
            double elementMinWidth = styleSheet.getDoubleStyleProperty(ElementStyleKeys.MIN_WIDTH, 0.0);
            long targetX2 = elementX[i] + elementWidth[i];
            if (elementMinWidth >= 0.0) {
                long localWidth = Math.max(0L, targetX2 - computedPositionX);
                float position = (float)StrictGeomUtility.toExternalValue((long)localWidth);
                styleSheet.setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)new Float(position));
            } else {
                long parentBase = parentData.getWidth();
                if (parentBase > 0L) {
                    long localWidth = Math.max(0L, targetX2 - computedPositionX);
                    long percentage = StrictGeomUtility.toInternalValue((double)(localWidth * 100L / parentBase));
                    styleSheet.setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)new Float(StrictGeomUtility.toExternalValue((long)(-percentage))));
                }
            }
            element.notifyNodePropertiesChanged();
        }
    }

    @Override
    public void finish() {
    }
}

