/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.drag;

import java.awt.geom.Point2D;
import java.util.List;
import org.pentaho.reporting.designer.core.editor.report.drag.AbstractMouseDragOperation;
import org.pentaho.reporting.designer.core.editor.report.snapping.SnapPositionsModel;
import org.pentaho.reporting.designer.core.model.CachedLayoutData;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public class ResizeTopDragOperation
extends AbstractMouseDragOperation {
    private long snapThreshold = WorkspaceSettings.getInstance().getSnapThreshold();

    public ResizeTopDragOperation(List<Element> selectedVisualElements, Point2D originPoint, SnapPositionsModel horizontalSnapModel, SnapPositionsModel verticalSnapModel) {
        super(selectedVisualElements, originPoint, horizontalSnapModel, verticalSnapModel);
    }

    @Override
    public void update(Point2D normalizedPoint, double zoomFactor) {
        SnapPositionsModel verticalSnapModel = this.getVerticalSnapModel();
        Element[] selectedVisualElements = this.getSelectedVisualElements();
        long originPointY = this.getOriginPointY();
        long[] elementHeight = this.getElementHeight();
        long[] elementY = this.getElementY();
        long py = StrictGeomUtility.toInternalValue((double)normalizedPoint.getY());
        long dy = py - originPointY;
        for (int i = 0; i < selectedVisualElements.length; ++i) {
            long computedPositionY;
            Element element = selectedVisualElements[i];
            if (element instanceof RootLevelBand) continue;
            ElementStyleSheet styleSheet = element.getStyle();
            double definedElementY = styleSheet.getDoubleStyleProperty(ElementStyleKeys.POS_Y, 0.0);
            long targetPositionY = elementY[i] + dy;
            Section parent = element.getParentSection();
            CachedLayoutData parentData = ModelUtility.getCachedLayoutData((Element)parent);
            long layoutedParentY = parentData.getY();
            if (targetPositionY < layoutedParentY) continue;
            if (definedElementY >= 0.0) {
                float position;
                long localYPosition;
                long snapPosition = verticalSnapModel.getNearestSnapPosition(targetPositionY, element.getObjectID());
                if (Math.abs(snapPosition - targetPositionY) > this.snapThreshold) {
                    computedPositionY = targetPositionY;
                    localYPosition = Math.max(0L, targetPositionY - layoutedParentY);
                    position = (float)StrictGeomUtility.toExternalValue((long)localYPosition);
                    styleSheet.setStyleProperty(ElementStyleKeys.POS_Y, (Object)new Float(position));
                } else {
                    computedPositionY = snapPosition;
                    localYPosition = Math.max(0L, snapPosition - layoutedParentY);
                    position = (float)StrictGeomUtility.toExternalValue((long)localYPosition);
                    styleSheet.setStyleProperty(ElementStyleKeys.POS_Y, (Object)new Float(position));
                }
            } else {
                long localYPosition;
                long parentBase = this.isCanvasElement((Element)parent) ? parentData.getHeight() : parentData.getWidth();
                if (parentBase <= 0L) continue;
                long snapPosition = verticalSnapModel.getNearestSnapPosition(targetPositionY, element.getObjectID());
                if (Math.abs(snapPosition - targetPositionY) > this.snapThreshold) {
                    computedPositionY = targetPositionY;
                    localYPosition = Math.max(0L, targetPositionY - layoutedParentY);
                    long percentage = StrictGeomUtility.toInternalValue((double)(localYPosition * 100L / parentBase));
                    styleSheet.setStyleProperty(ElementStyleKeys.POS_Y, (Object)new Float(StrictGeomUtility.toExternalValue((long)(-percentage))));
                } else {
                    computedPositionY = snapPosition;
                    localYPosition = Math.max(0L, snapPosition - layoutedParentY);
                    long percentage = StrictGeomUtility.toInternalValue((double)(localYPosition * 100L / parentBase));
                    styleSheet.setStyleProperty(ElementStyleKeys.POS_Y, (Object)new Float(StrictGeomUtility.toExternalValue((long)(-percentage))));
                }
            }
            double elementMinHeight = styleSheet.getDoubleStyleProperty(ElementStyleKeys.MIN_HEIGHT, 0.0);
            long targetY2 = elementY[i] + elementHeight[i];
            if (elementMinHeight >= 0.0) {
                long localHeight = Math.max(0L, targetY2 - computedPositionY);
                float position = (float)StrictGeomUtility.toExternalValue((long)localHeight);
                styleSheet.setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(position));
            } else {
                long parentBase = parentData.getHeight();
                if (parentBase > 0L) {
                    long localHeight = Math.max(0L, targetY2 - computedPositionY);
                    long percentage = StrictGeomUtility.toInternalValue((double)(localHeight * 100L / parentBase));
                    styleSheet.setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(StrictGeomUtility.toExternalValue((long)(-percentage))));
                }
            }
            element.notifyNodePropertiesChanged();
        }
    }

    @Override
    public void finish() {
    }
}

