/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.elements;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.parameters.SubReportDataSourceDialog;
import org.pentaho.reporting.designer.core.editor.report.ReportElementEditorContext;
import org.pentaho.reporting.engine.classic.core.AbstractRootLevelBand;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

abstract class AbstractSubreportHandler<T extends SubReport>
implements Runnable {
    final Component component;
    final ReportDesignerContext designerContext;
    final ReportDocumentContext renderContext;
    final T subReport;
    final Band parent;
    final boolean rootband;

    AbstractSubreportHandler(T subReport, Band parent, ReportElementEditorContext dragContext, boolean rootband) {
        ArgumentNullException.validate((String)"subReport", subReport);
        ArgumentNullException.validate((String)"parent", (Object)parent);
        ArgumentNullException.validate((String)"dragContext", (Object)dragContext);
        this.subReport = subReport;
        this.parent = parent;
        this.component = dragContext.getRepresentationContainer();
        this.designerContext = dragContext.getDesignerContext();
        this.renderContext = dragContext.getRenderContext();
        this.rootband = rootband;
    }

    AbstractSubreportHandler(T subReport, Band parent, ReportDesignerContext designerContext, ReportDocumentContext renderContext) {
        ArgumentNullException.validate((String)"subReport", subReport);
        ArgumentNullException.validate((String)"parent", (Object)parent);
        ArgumentNullException.validate((String)"designerContext", (Object)designerContext);
        ArgumentNullException.validate((String)"renderContext", (Object)renderContext);
        this.subReport = subReport;
        this.parent = parent;
        this.component = designerContext.getView().getParent();
        this.designerContext = designerContext;
        this.renderContext = renderContext;
        this.rootband = parent instanceof AbstractRootLevelBand;
    }

    @Override
    public void run() {
        if (!this.showConfirmationDialog()) {
            return;
        }
        this.createSubReportTab();
        this.showDataSourceDialog();
        this.completeExecution();
    }

    abstract boolean showConfirmationDialog();

    abstract void createSubReportTab();

    void showDataSourceDialog() {
        SubReportDataSourceDialog dialog = this.createSubReportDataSourceDialog();
        String queryName = dialog.performSelection(this.designerContext);
        if (queryName == null) {
            this.subReport.setDataFactory((DataFactory)new CompoundDataFactory());
        } else {
            this.subReport.setQuery(queryName);
            this.doSetQuery(queryName);
        }
    }

    void doSetQuery(String queryName) {
    }

    SubReportDataSourceDialog createSubReportDataSourceDialog() {
        Window window = LibSwingUtil.getWindowAncestor((Component)this.designerContext.getView().getParent());
        if (window instanceof Dialog) {
            return new SubReportDataSourceDialog((Dialog)window);
        }
        if (window instanceof Frame) {
            return new SubReportDataSourceDialog((Frame)window);
        }
        return new SubReportDataSourceDialog();
    }

    void completeExecution() {
        this.subReport.addInputParameter("*", "*");
        this.renderContext.getSelectionModel().setSelectedElements(new Object[]{this.subReport});
    }
}

