/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.elements;

import java.awt.geom.Point2D;
import java.util.Locale;
import javax.swing.SwingUtilities;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.report.ReportElementEditorContext;
import org.pentaho.reporting.designer.core.editor.report.elements.AbstractSubReportElementDragHandler;
import org.pentaho.reporting.designer.core.editor.report.elements.CrosstabConfigureHandler;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.CrosstabElement;
import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;

public class CrosstabReportElementDragHandler
extends AbstractSubReportElementDragHandler {
    @Override
    protected void postProcessDrop(Element visualElement, Band target, ReportElementEditorContext dragContext, Point2D point) {
        Element rootBand = this.findRootBand(dragContext, point);
        SwingUtilities.invokeLater(new CrosstabConfigureHandler((CrosstabElement)visualElement, target, dragContext, rootBand == target));
    }

    @Override
    protected Element createElement(ElementMetaData elementMetaData, String fieldName, ReportDocumentContext context) throws InstantiationException {
        ElementType type = elementMetaData.create();
        CrosstabElement visualElement = new CrosstabElement();
        visualElement.setElementType(type);
        visualElement.setRootGroup((Group)new CrosstabGroup());
        CrosstabConfigureHandler.configureDefaults(visualElement);
        type.configureDesignTimeDefaults((ReportElement)visualElement, Locale.getDefault());
        ElementStyleSheet styleSheet = visualElement.getStyle();
        styleSheet.setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)DEFAULT_WIDTH);
        styleSheet.setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)DEFAULT_HEIGHT);
        return visualElement;
    }
}

