/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.layouting;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.report.DesignerPageDrawable;
import org.pentaho.reporting.designer.core.editor.report.layouting.DesignerOutputProcessorMetaData;
import org.pentaho.reporting.designer.core.editor.report.layouting.ElementRenderer;
import org.pentaho.reporting.designer.core.editor.report.layouting.MigrateReportTask;
import org.pentaho.reporting.designer.core.editor.report.layouting.SharedElementRenderer;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.model.lineal.LinealModel;
import org.pentaho.reporting.designer.core.util.BreakPositionsList;
import org.pentaho.reporting.designer.core.util.Unit;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.designtime.AttributeChange;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportModelListener;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.ItemBandType;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.ReportFooterType;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.ReportHeaderType;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public abstract class AbstractElementRenderer
implements ElementRenderer {
    private final SharedLayoutUpdateHandler sharedLayoutUpdateHandler;
    private SharedElementRenderer sharedRenderer;
    private Section element;
    private ReportDocumentContext reportRenderContext;
    private EventListenerList listenerList;
    private Rectangle2D computedBounds;
    private BreakPositionsList verticalEdgePositions;
    private DesignerPageDrawable logicalPageDrawable;
    private ResourceManager resourceManager;
    private Map<InstanceID, Element> elementsById;

    protected AbstractElementRenderer(Section element, ReportDocumentContext reportRenderContext) {
        if (element == null) {
            throw new NullPointerException();
        }
        if (reportRenderContext == null) {
            throw new NullPointerException();
        }
        this.sharedLayoutUpdateHandler = new SharedLayoutUpdateHandler();
        this.sharedRenderer = reportRenderContext.getSharedRenderer();
        this.sharedRenderer.addChangeListener(this.sharedLayoutUpdateHandler);
        this.element = element;
        this.reportRenderContext = reportRenderContext;
        this.elementsById = new HashMap<InstanceID, Element>();
        this.listenerList = new EventListenerList();
        this.verticalEdgePositions = new BreakPositionsList();
        this.resourceManager = reportRenderContext.getResourceManager();
        reportRenderContext.getReportDefinition().addReportModelListener((ReportModelListener)new VisualHeightUpdateListener());
        Object d = element.getAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "visual-height");
        if (!(d instanceof Double)) {
            if (element.getElementType() instanceof ReportHeaderType) {
                this.setVisualHeight(Unit.INCH.getDotsPerUnit() * 1.5);
            } else if (element.getElementType() instanceof ReportFooterType) {
                this.setVisualHeight(Unit.INCH.getDotsPerUnit() * 1.5);
            } else if (element.getElementType() instanceof ItemBandType) {
                this.setVisualHeight(Unit.INCH.getDotsPerUnit() * 1.5);
            } else {
                this.setVisualHeight(Unit.INCH.getDotsPerUnit());
            }
        }
    }

    @Override
    public void dispose() {
        this.sharedRenderer.removeChangeListener(this.sharedLayoutUpdateHandler);
    }

    public ReportDocumentContext getReportRenderContext() {
        return this.reportRenderContext;
    }

    @Override
    public Section getElement() {
        return this.element;
    }

    @Override
    public ElementType getElementType() {
        return this.element.getElementType();
    }

    @Override
    public InstanceID getRepresentationId() {
        return this.element.getObjectID();
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public void fireChangeEvent() {
        ChangeEvent ce = new ChangeEvent(this);
        ChangeListener[] changeListeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        for (int i = 0; i < changeListeners.length; ++i) {
            ChangeListener listener = changeListeners[i];
            listener.stateChanged(ce);
        }
    }

    @Override
    public double getVisualHeight() {
        Object d = this.element.getAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "visual-height");
        if (d instanceof Double) {
            return (Double)d;
        }
        return 0.0;
    }

    @Override
    public void setVisualHeight(double visualHeight) {
        if (visualHeight < 0.0) {
            throw new IllegalArgumentException();
        }
        double oldHeight = this.getVisualHeight();
        if (visualHeight != oldHeight) {
            this.element.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "visual-height", (Object)visualHeight, false);
            this.fireChangeEvent();
        }
    }

    @Override
    public boolean isHideInLayout() {
        return ModelUtility.isHideInLayoutGui((ReportElement)this.element);
    }

    @Override
    public LinealModel getVerticalLinealModel() {
        return ModelUtility.getVerticalLinealModel((Element)this.element);
    }

    @Override
    public synchronized double getLayoutHeight() {
        if (this.computedBounds == null || !this.sharedRenderer.isLayoutValid()) {
            this.computedBounds = this.performLayouting();
        }
        return Math.max(this.computedBounds.getHeight(), this.getVisualHeight());
    }

    @Override
    public synchronized void invalidateLayout() {
        this.computedBounds = null;
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.computedBounds == null || !this.sharedRenderer.isLayoutValid()) {
            this.computedBounds = this.performLayouting();
        }
        return new Rectangle2D.Double(0.0, this.computedBounds.getY(), this.computedBounds.getWidth(), Math.max(this.computedBounds.getHeight(), this.getVisualHeight()));
    }

    @Override
    public StrictBounds getRootElementBounds() {
        if (this.logicalPageDrawable == null) {
            return new StrictBounds();
        }
        return (StrictBounds)this.logicalPageDrawable.getRootElementBounds().clone();
    }

    protected Rectangle2D performLayouting() {
        if (this.sharedRenderer.performLayouting()) {
            this.fireChangeEvent();
            if (this.computedBounds == null) {
                this.refreshLayoutFromSharedRenderer();
            }
            return this.computedBounds;
        }
        this.logicalPageDrawable = null;
        this.fireChangeEvent();
        return new Rectangle2D.Double();
    }

    private void refreshLayoutFromSharedRenderer() {
        LogicalPageBox pageBox = this.sharedRenderer.getPageBox();
        if (pageBox == null) {
            this.computedBounds = this.sharedRenderer.getFallbackBounds();
            return;
        }
        this.elementsById.clear();
        this.sharedRenderer.transferLocalLayout(this.getElement(), this.elementsById, this.verticalEdgePositions);
        DesignerOutputProcessorMetaData outputProcessorMetaData = this.sharedRenderer.getLayouter().getOutputProcessorMetaData();
        this.logicalPageDrawable = new DesignerPageDrawable(pageBox, (OutputProcessorMetaData)outputProcessorMetaData, this.resourceManager, this.element);
        StrictBounds bounds = this.logicalPageDrawable.getRootElementBounds();
        this.computedBounds = StrictGeomUtility.createAWTRectangle((long)0L, (long)bounds.getY(), (long)pageBox.getWidth(), (long)bounds.getHeight());
        if (this.getVisualHeight() < this.computedBounds.getHeight()) {
            this.setVisualHeight(this.computedBounds.getHeight());
        }
    }

    @Override
    public boolean draw(Graphics2D graphics2D) {
        Rectangle2D bounds1 = this.getBounds();
        if (this.logicalPageDrawable == null) {
            return false;
        }
        Graphics2D graphics = (Graphics2D)graphics2D.create();
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.logicalPageDrawable.draw(graphics, bounds1);
        graphics.dispose();
        return true;
    }

    @Override
    public void handleError(ReportDesignerContext designerContext, ReportDocumentContext reportContext) {
        if (this.sharedRenderer.isMigrationError()) {
            SwingUtilities.invokeLater(new MigrateReportTask(designerContext, reportContext, this.sharedRenderer.getMinimumVersionNeeded()));
            this.sharedRenderer.clearMigrationError();
        }
    }

    @Override
    public BreakPositionsList getHorizontalEdgePositions() {
        return this.sharedRenderer.getHorizontalEdgePositions();
    }

    @Override
    public long[] getHorizontalEdgePositionKeys() {
        return this.getHorizontalEdgePositions().getKeys();
    }

    @Override
    public BreakPositionsList getVerticalEdgePositions() {
        return this.verticalEdgePositions;
    }

    @Override
    public Element[] getElementsAt(double x, double y, double width, double height) {
        if (this.logicalPageDrawable == null) {
            return new Element[0];
        }
        RenderNode[] nodes = this.logicalPageDrawable.getNodesAt(x, y, width, height, null, null);
        if (nodes.length == 0) {
            return new Element[0];
        }
        LinkedHashSet<Element> elements = new LinkedHashSet<Element>(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            RenderNode node = nodes[i];
            Element reportElement = this.elementsById.get(node.getInstanceId());
            if (reportElement == null) continue;
            elements.add(reportElement);
        }
        return elements.toArray(new Element[elements.size()]);
    }

    @Override
    public Element[] getElementsAt(double x, double y) {
        if (this.logicalPageDrawable == null) {
            return new Element[0];
        }
        RenderNode[] nodes = this.logicalPageDrawable.getNodesAt(x, y, null, null);
        if (nodes.length == 0) {
            return new Element[0];
        }
        LinkedHashSet<Element> elements = new LinkedHashSet<Element>(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            RenderNode node = nodes[i];
            Element reportElement = this.elementsById.get(node.getInstanceId());
            if (reportElement == null) continue;
            elements.add(reportElement);
        }
        return elements.toArray(new Element[elements.size()]);
    }

    protected DesignerPageDrawable getLogicalPageDrawable() {
        return this.logicalPageDrawable;
    }

    private class SharedLayoutUpdateHandler
    implements ChangeListener {
        private SharedLayoutUpdateHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            AbstractElementRenderer.this.refreshLayoutFromSharedRenderer();
        }
    }

    private class VisualHeightUpdateListener
    implements ReportModelListener {
        private VisualHeightUpdateListener() {
        }

        public void nodeChanged(ReportModelEvent event) {
            AttributeChange attributeChange;
            if (event.getElement() != AbstractElementRenderer.this.element && event.getParameter() instanceof AttributeChange && "http://reporting.pentaho.org/namespaces/report-designer/2.0".equals((attributeChange = (AttributeChange)event.getParameter()).getNamespace()) && "visual-height".equals(attributeChange.getName())) {
                AbstractElementRenderer.this.fireChangeEvent();
            }
        }
    }
}

