/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.layouting;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableRectangle;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class DesignerTableContentProducer
extends TableContentProducer {
    private HashMap<InstanceID, Set<InstanceID>> conflicts = new HashMap();
    private LinkedHashSet<InstanceID> conflictsPerCell = new LinkedHashSet();

    public DesignerTableContentProducer(SheetLayout sheetLayout, OutputProcessorMetaData metaData) {
        super(sheetLayout, metaData);
        this.setProcessWatermark(false);
    }

    protected boolean startBox(RenderBox box) {
        this.conflicts.remove(box.getInstanceId());
        return super.startBox(box);
    }

    protected boolean isProcessed(RenderBox box) {
        return false;
    }

    protected void handleContentConflict(RenderBox box) {
        super.handleContentConflict(box);
        TableRectangle lookupRectangle = this.getLookupRectangle();
        int rectX2 = lookupRectangle.getX2();
        int rectY2 = lookupRectangle.getY2();
        this.conflictsPerCell.clear();
        for (int r = lookupRectangle.getY1(); r < rectY2; ++r) {
            for (int c = lookupRectangle.getX1(); c < rectX2; ++c) {
                RenderBox content = this.getContent(r, c);
                if (content == null) continue;
                this.conflictsPerCell.add(content.getInstanceId());
            }
        }
        this.conflicts.put(box.getInstanceId(), new LinkedHashSet<InstanceID>(this.conflictsPerCell));
    }

    public Map<InstanceID, Set<InstanceID>> computeConflicts(LogicalPageBox box, Map<InstanceID, Set<InstanceID>> collectedConflicts) {
        if (collectedConflicts == null) {
            throw new NullPointerException();
        }
        this.conflicts.clear();
        this.compute(box, false);
        collectedConflicts.putAll(this.conflicts);
        return collectedConflicts;
    }

    public Map<InstanceID, Set<InstanceID>> computeWatermarkConflics(LogicalPageBox box, Map<InstanceID, Set<InstanceID>> collectedConflicts) {
        if (collectedConflicts == null) {
            throw new NullPointerException();
        }
        this.conflicts.clear();
        this.computeDesigntimeConflicts((RenderBox)box.getWatermarkArea());
        collectedConflicts.putAll(this.conflicts);
        return collectedConflicts;
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.processBoxChilds((RenderBox)box);
    }
}

