/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.lineal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.text.DecimalFormat;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ZoomModel;
import org.pentaho.reporting.designer.core.editor.ZoomModelListener;
import org.pentaho.reporting.designer.core.editor.report.layouting.AbstractElementRenderer;
import org.pentaho.reporting.designer.core.editor.report.layouting.ElementRenderer;
import org.pentaho.reporting.designer.core.editor.report.lineal.AddVerticalGuidelineUndoEntry;
import org.pentaho.reporting.designer.core.editor.report.lineal.RemoveVerticalGuidelineUndoEntry;
import org.pentaho.reporting.designer.core.editor.report.lineal.UpdateVerticalGuidelineUndoEntry;
import org.pentaho.reporting.designer.core.model.lineal.GuideLine;
import org.pentaho.reporting.designer.core.model.lineal.LinealModel;
import org.pentaho.reporting.designer.core.model.lineal.LinealModelEvent;
import org.pentaho.reporting.designer.core.model.lineal.LinealModelListener;
import org.pentaho.reporting.designer.core.settings.SettingsListener;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.CanvasImageLoader;
import org.pentaho.reporting.designer.core.util.GuideLineDialog;
import org.pentaho.reporting.designer.core.util.Unit;
import org.pentaho.reporting.designer.core.util.dnd.InsertationUtil;
import org.pentaho.reporting.designer.core.util.undo.UndoManager;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportModelListener;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.engine.classic.core.util.PageFormatFactory;
import org.pentaho.reporting.libraries.designtime.swing.ColorUtility;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class VerticalLinealComponent
extends JComponent {
    protected static final String ADD_GUIDE_LINE = "addVerticalGuideLine";
    protected static final String REMOVE_GUIDE_LINE = "removeVerticalGuideLine";
    protected static final String MOVE_GUIDE_LINE = "moveGuideLine";
    protected static final String ACTIVATE_GUIDE_LINE = "activateGuideLine";
    protected static final String DEACTIVATE_GUIDE_LINE = "deactivateGuideLine";
    private final DecimalFormat decimalFormat = new DecimalFormat("0.0##");
    private final DecimalFormat decimalFormatNumbersOneDigit = new DecimalFormat("0.0");
    private final DecimalFormat decimalFormatInteger = new DecimalFormat("0");
    private PageDefinition pageDefinition;
    private boolean showTopBorder;
    private ZoomModel zoomModel;
    private LinealModel linealModel;
    private GuideLine activeGuidLine;
    private GuideLine draggedGuideLine;
    private LinealUpdateHandler linealUpdateHandler;
    private ElementRenderer reportElement;
    private RootBandChangeHandler changeHandler;
    private ReportDocumentContext renderContext;
    private String name;
    private double padding;
    private boolean renderNamesVertically;

    public VerticalLinealComponent(boolean showTopBorder, ReportDocumentContext renderContext) {
        if (renderContext == null) {
            throw new NullPointerException();
        }
        this.setFont(new Font("Dialog", 0, 12));
        this.renderContext = renderContext;
        ((MasterReport)this.renderContext.getContextRoot()).addReportModelListener((ReportModelListener)new PageFormatUpdateHandler());
        this.changeHandler = new RootBandChangeHandler();
        this.showTopBorder = showTopBorder;
        this.zoomModel = renderContext.getZoomModel();
        this.linealModel = new LinealModel();
        this.linealUpdateHandler = new LinealUpdateHandler();
        this.linealModel.addLinealModelListener(this.linealUpdateHandler);
        this.renderContext.getZoomModel().addZoomModelListener(this.changeHandler);
        DragAndDropHandler andDropHandler = new DragAndDropHandler();
        this.addMouseListener(andDropHandler);
        this.addMouseMotionListener(andDropHandler);
        this.addMouseListener(new GuidelinePopupHandler());
        WorkspaceSettings.getInstance().addSettingsListener(new UnitSettingsListener());
    }

    public boolean isRenderNamesVertically() {
        return this.renderNamesVertically;
    }

    public void setRenderNamesVertically(boolean renderNamesVertically) {
        this.renderNamesVertically = renderNamesVertically;
    }

    public PageDefinition getPageDefinition() {
        return this.pageDefinition;
    }

    protected void updatePageDefinition(PageDefinition pageDefinition) {
        this.pageDefinition = pageDefinition;
    }

    public void setPageDefinition(PageDefinition pageDefinition, ElementRenderer reportElement) {
        if (this.reportElement != null) {
            this.reportElement.removeChangeListener(this.changeHandler);
        }
        this.linealModel.removeLinealModelListener(this.linealUpdateHandler);
        this.reportElement = reportElement;
        this.pageDefinition = pageDefinition;
        if (reportElement == null) {
            this.linealModel = new LinealModel();
            this.name = null;
        } else {
            this.linealModel = reportElement.getVerticalLinealModel();
            this.name = reportElement.getElementType().getMetaData().getDisplayName(Locale.getDefault());
        }
        this.linealModel.addLinealModelListener(this.linealUpdateHandler);
        if (this.reportElement != null) {
            this.reportElement.addChangeListener(this.changeHandler);
        }
        this.revalidate();
        this.repaint();
    }

    protected void popup(MouseEvent me) {
        if (!me.isPopupTrigger()) {
            return;
        }
        int padding = (int)this.getPadding();
        if (me.getX() < padding) {
            return;
        }
        double start = 0.0;
        if (this.pageDefinition == null) {
            return;
        }
        if (this.showTopBorder) {
            start = this.getTopBorder();
        }
        GuideLine[] guideLines = this.linealModel.getGuideLines();
        for (int i = 0; i < guideLines.length; ++i) {
            GuideLine guideLine = guideLines[i];
            int y = (int)((guideLine.getPosition() + start) * (double)this.zoomModel.getZoomAsPercentage());
            if (y > me.getY() + 2 || y < me.getY() - 2) continue;
            JPopupMenu popupMenu = this.createPopupMenu(guideLine, i);
            popupMenu.show(this, me.getX(), me.getY());
            break;
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.renderNamesVertically) {
            Rectangle2D bounds = font.getStringBounds("100%", new FontRenderContext(null, true, true));
            this.padding = bounds.getWidth() - bounds.getHeight();
        } else {
            Rectangle2D bounds = font.getStringBounds("xxxPage Headerxxx", new FontRenderContext(null, true, true));
            this.padding = bounds.getWidth();
        }
    }

    protected double getPadding() {
        return this.padding;
    }

    protected double getTopBorder() {
        if (this.pageDefinition == null) {
            return 0.0;
        }
        PageFormat pageFormat = this.pageDefinition.getPageFormat(0);
        PageFormatFactory pageFormatFactory = PageFormatFactory.getInstance();
        return pageFormatFactory.getTopBorder(pageFormat.getPaper());
    }

    protected boolean isShowTopBorder() {
        return this.showTopBorder;
    }

    protected double getBottomBorder() {
        if (this.pageDefinition == null) {
            return 0.0;
        }
        PageFormat pageFormat = this.pageDefinition.getPageFormat(0);
        PageFormatFactory pageFormatFactory = PageFormatFactory.getInstance();
        return pageFormatFactory.getBottomBorder(pageFormat.getPaper());
    }

    private JPopupMenu createPopupMenu(GuideLine guideLine, int index) {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new GuidelinePropertiesAction(guideLine, index));
        if (guideLine.isActive()) {
            popupMenu.add(new DeactivateGuidelineAction(guideLine, index));
        } else {
            popupMenu.add(new ActivateGuidelineAction(guideLine, index));
        }
        popupMenu.add(new DeleteGuidelineAction(guideLine));
        return popupMenu;
    }

    protected final int getActiveGuideIndex(MouseEvent e) {
        if (this.pageDefinition == null) {
            this.setToolTipText(null);
            return -1;
        }
        Unit unit = WorkspaceSettings.getInstance().getUnit();
        GuideLine[] lines = this.linealModel.getGuideLines();
        for (int i = 0; i < lines.length; ++i) {
            int y;
            GuideLine guideLine = lines[i];
            double start = 0.0;
            if (this.showTopBorder) {
                start = this.getTopBorder();
            }
            if ((y = (int)((guideLine.getPosition() + start) * (double)this.zoomModel.getZoomAsPercentage())) > e.getY() + 2 || y < e.getY() - 2) continue;
            double unitValue = unit.convertFromPoints(guideLine.getPosition());
            this.setToolTipText(this.decimalFormat.format(unitValue));
            return i;
        }
        this.setToolTipText(null);
        return -1;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        float zoom = this.renderContext.getZoomModel().getZoomAsPercentage();
        int padding = (int)this.getPadding();
        int width = padding + 15;
        if (this.reportElement == null || zoom == 0.0f) {
            return new Dimension(width, 0);
        }
        double height = this.reportElement.getLayoutHeight();
        if (this.showTopBorder && this.pageDefinition != null) {
            return new Dimension(width, (int)((double)zoom * (this.getTopBorder() + height)));
        }
        return new Dimension(width, (int)((double)zoom * height));
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        AbstractElementRenderer renderer;
        Object selectedBand;
        super.paintComponent(graphics);
        int padding = (int)this.getPadding();
        Graphics2D g2 = (Graphics2D)graphics.create();
        g2.setColor(new Color(255, 255, 255, 0));
        if (this.reportElement instanceof AbstractElementRenderer && (selectedBand = InsertationUtil.getInsertationPoint(this.renderContext)) == (renderer = (AbstractElementRenderer)this.reportElement).getElement()) {
            g2.setColor(new Color(128, 128, 128, 128));
        }
        g2.fillRect(0, 0, padding, this.getHeight());
        g2.setColor(this.getForeground());
        Rectangle componentBounds = this.getBounds();
        if (this.name != null) {
            if (this.renderNamesVertically) {
                Rectangle2D sb = g2.getFontMetrics().getStringBounds(this.name, g2);
                this.drawRotatedText(g2, 0, (int)((double)(this.getHeight() / 2) - (sb.getWidth() + 1.0) / 2.0), this.name);
            } else {
                Rectangle2D stringBounds = g2.getFontMetrics().getStringBounds(this.name, g2);
                int x = (int)Math.max(0.0, componentBounds.getCenterX() - stringBounds.getWidth() / 2.0);
                int y = (int)Math.max(0.0, componentBounds.getHeight() / 2.0 - stringBounds.getHeight() / 2.0);
                this.drawText(g2, x - 7, y, this.name);
            }
        }
        ImageIcon leftBorder = CanvasImageLoader.getInstance().getLeftShadowImage();
        g2.drawImage(leftBorder.getImage(), padding - 8, 0, leftBorder.getIconWidth(), this.getHeight(), null);
        g2.translate(padding, 0);
        int effectiveWidth = Math.max(0, this.getWidth() - padding);
        g2.clipRect(0, 0, effectiveWidth + 1, this.getHeight());
        double start = 0.0;
        double end = 0.0;
        if (this.pageDefinition != null) {
            end = this.pageDefinition.getHeight();
            if (this.showTopBorder) {
                start = this.getTopBorder();
                end += this.getTopBorder();
                end += this.getBottomBorder();
            }
        }
        float scaleFactor = this.zoomModel.getZoomAsPercentage();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, (int)(start * (double)scaleFactor), effectiveWidth, this.getHeight());
        g2.setColor(Color.LIGHT_GRAY);
        g2.drawLine(effectiveWidth - 1, (int)(start * (double)scaleFactor), effectiveWidth - 1, this.getHeight());
        this.drawDots(g2, start, end);
        this.drawGuideLines(g2);
        this.drawNumbers(g2, start, end);
        g2.dispose();
    }

    private void drawDots(Graphics g, double start, double end) {
        g.setColor(Color.GRAY);
        Unit unit = WorkspaceSettings.getInstance().getUnit();
        float zoomAsPercentage = this.zoomModel.getZoomAsPercentage();
        double factorForUnitAndScale = unit.getTickSize(zoomAsPercentage);
        double increment = unit.getDotsPerUnit() * factorForUnitAndScale;
        for (double i = start += increment / 2.0; i < end; i += increment) {
            int x = (int)(i * (double)zoomAsPercentage);
            g.drawLine(9, x, 10, x);
        }
    }

    private void drawNumbers(Graphics g, double start, double end) {
        Unit unit = WorkspaceSettings.getInstance().getUnit();
        float zoomAsPercentage = this.zoomModel.getZoomAsPercentage();
        double factorForUnitAndScale = unit.getTickSize(zoomAsPercentage);
        double increment = unit.getDotsPerUnit() * factorForUnitAndScale;
        DecimalFormat df = this.decimalFormatInteger;
        if (factorForUnitAndScale < 1.0) {
            df = this.decimalFormatNumbersOneDigit;
        }
        g.setColor(Color.GRAY);
        double number = 0.0;
        for (double i = start; i < end - increment / 2.0; i += increment) {
            int x = (int)(i * (double)zoomAsPercentage);
            if (number > 0.0) {
                String s = df.format(number);
                Rectangle2D sb = g.getFontMetrics().getStringBounds(s, g);
                this.drawRotatedText((Graphics2D)g, 0, (int)((double)x - (sb.getWidth() + 1.0) / 2.0), s);
            }
            number += factorForUnitAndScale;
        }
    }

    private void drawRotatedText(Graphics2D g2d, int x, int y, String text) {
        FontRenderContext fontRenderContext = g2d.getFontRenderContext();
        Font font = this.getFont();
        Rectangle2D sb = font.getStringBounds(text, fontRenderContext);
        int width = (int)sb.getWidth() + 4;
        LineMetrics lineMetrics = font.getLineMetrics(text, fontRenderContext);
        float ascent = lineMetrics.getAscent();
        int height = (int)Math.ceil(lineMetrics.getHeight());
        g2d.setFont(font);
        AffineTransform oldTransform = g2d.getTransform();
        g2d.setColor(this.getForeground());
        AffineTransform trans = new AffineTransform();
        trans.concatenate(oldTransform);
        trans.translate(x, y - 2);
        trans.rotate(4.71238898038469, height / 2, width / 2);
        g2d.setTransform(trans);
        g2d.drawString(text, (float)((height - width) / 2), (float)((width - height) / 2) + ascent);
        g2d.setTransform(oldTransform);
    }

    private void drawText(Graphics2D g2d, int x, int y, String text) {
        FontRenderContext fontRenderContext = g2d.getFontRenderContext();
        Font font = this.getFont();
        LineMetrics lineMetrics = font.getLineMetrics(text, fontRenderContext);
        float ascent = lineMetrics.getAscent();
        g2d.setFont(font);
        g2d.setColor(this.getForeground());
        g2d.drawString(text, (float)x, (float)y + ascent);
    }

    private void drawGuideLines(Graphics g) {
        GuideLine[] guideLines = this.linealModel.getGuideLines();
        double startOffset = 0.0;
        if (this.showTopBorder) {
            startOffset = this.getTopBorder();
        }
        Color guideColor = WorkspaceSettings.getInstance().getGuideColor();
        Color guideFill = ColorUtility.convertToGray((Color)guideColor, (float)0.3f);
        Color guideHighlight = ColorUtility.convertToDarker((Color)guideFill);
        Color disabledGuideColor = ColorUtility.convertToDarker((Color)ColorUtility.convertToGray((Color)guideColor, (float)0.0f));
        Color disabledGuideFill = ColorUtility.convertToDarker((Color)ColorUtility.convertToGray((Color)guideFill, (float)0.0f));
        Color disabledHighlightGuide = ColorUtility.convertToDarker((Color)ColorUtility.convertToGray((Color)guideHighlight, (float)0.0f));
        int so = (int)(startOffset * (double)this.zoomModel.getZoomAsPercentage());
        for (GuideLine guideLine : guideLines) {
            int y = (int)(guideLine.getPosition() * (double)this.zoomModel.getZoomAsPercentage()) + so;
            if (guideLine.isActive()) {
                g.setColor(guideFill);
            } else {
                g.setColor(disabledGuideFill);
            }
            g.fillRect(1, y - 2, 13, 4);
            if (guideLine.isActive()) {
                g.setColor(guideColor);
            } else {
                g.setColor(disabledGuideColor);
            }
            g.drawRect(0, y - 2, 14, 4);
        }
        GuideLine highlightGuideLine = this.activeGuidLine;
        if (this.draggedGuideLine != null) {
            highlightGuideLine = this.draggedGuideLine;
        }
        if (highlightGuideLine != null) {
            int y = (int)(highlightGuideLine.getPosition() * (double)this.zoomModel.getZoomAsPercentage()) + so;
            if (highlightGuideLine.isActive()) {
                g.setColor(guideFill);
            } else {
                g.setColor(disabledGuideFill);
            }
            g.fillRect(1, y - 2, 13, 4);
            if (highlightGuideLine.isActive()) {
                g.setColor(guideHighlight);
            } else {
                g.setColor(disabledHighlightGuide);
            }
            g.drawRect(0, y - 2, 14, 4);
        }
    }

    protected GuideLine getActiveGuidLine() {
        return this.activeGuidLine;
    }

    protected void setActiveGuidLine(GuideLine activeGuidLine) {
        this.activeGuidLine = activeGuidLine;
    }

    protected GuideLine getDraggedGuideLine() {
        return this.draggedGuideLine;
    }

    protected void setDraggedGuideLine(GuideLine draggedGuideLine) {
        this.draggedGuideLine = draggedGuideLine;
    }

    protected LinealModel getLinealModel() {
        return this.linealModel;
    }

    protected ZoomModel getZoomModel() {
        return this.zoomModel;
    }

    protected ReportDocumentContext getRenderContext() {
        return this.renderContext;
    }

    protected void updateGuidelineHighlight(MouseEvent e) {
        int padding = (int)this.getPadding();
        if (e.getX() < padding) {
            return;
        }
        int agIndex = this.getActiveGuideIndex(e);
        GuideLine ag = agIndex == -1 ? null : this.linealModel.getGuideLine(agIndex);
        if (this.activeGuidLine != ag) {
            this.activeGuidLine = ag;
            this.repaint();
        }
    }

    protected InstanceID getInstanceID() {
        if (this.reportElement == null) {
            return null;
        }
        return this.reportElement.getRepresentationId();
    }

    private class UnitSettingsListener
    implements SettingsListener {
        private UnitSettingsListener() {
        }

        @Override
        public void settingsChanged() {
            VerticalLinealComponent.this.repaint();
        }
    }

    private class DragAndDropHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private int guideLineIndex;

        private DragAndDropHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            boolean activeGuide;
            int padding = (int)VerticalLinealComponent.this.getPadding();
            if (e.getX() < padding) {
                return;
            }
            double start = 0.0;
            PageDefinition pageDefinition = VerticalLinealComponent.this.getPageDefinition();
            if (pageDefinition == null) {
                return;
            }
            if (VerticalLinealComponent.this.isShowTopBorder()) {
                start = VerticalLinealComponent.this.getTopBorder();
            }
            boolean bl = activeGuide = VerticalLinealComponent.this.getActiveGuideIndex(e) == -1;
            if (!activeGuide) {
                return;
            }
            LinealModel linealModel = VerticalLinealComponent.this.getLinealModel();
            ZoomModel zoomModel = VerticalLinealComponent.this.getZoomModel();
            float pageHeight = pageDefinition.getHeight();
            double scaledHeight = (double)((float)e.getY() / zoomModel.getZoomAsPercentage()) - start;
            double position = Math.min((double)pageHeight, Math.max(0.0, scaledHeight));
            GuideLine guideLine = new GuideLine(position, e.getButton() == 1);
            UndoManager undo = VerticalLinealComponent.this.getRenderContext().getUndo();
            undo.addChange(Messages.getString("LinealComponent.AddGuideUndoName", new Object[0]), new AddVerticalGuidelineUndoEntry(guideLine, VerticalLinealComponent.this.getInstanceID()));
            linealModel.addGuidLine(guideLine);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int padding = (int)VerticalLinealComponent.this.getPadding();
            if (e.getX() < padding) {
                return;
            }
            if (e.getButton() == 1) {
                this.guideLineIndex = VerticalLinealComponent.this.getActiveGuideIndex(e);
                if (this.guideLineIndex != -1) {
                    VerticalLinealComponent.this.setDraggedGuideLine(VerticalLinealComponent.this.getLinealModel().getGuideLine(this.guideLineIndex));
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.guideLineIndex = -1;
            VerticalLinealComponent.this.setDraggedGuideLine(null);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            GuideLine dragged = VerticalLinealComponent.this.getDraggedGuideLine();
            if (dragged == null || this.guideLineIndex == -1) {
                return;
            }
            double start = 0.0;
            PageDefinition pageDefinition = VerticalLinealComponent.this.getPageDefinition();
            if (pageDefinition == null) {
                return;
            }
            if (VerticalLinealComponent.this.isShowTopBorder()) {
                start = VerticalLinealComponent.this.getTopBorder();
            }
            ZoomModel zoomModel = VerticalLinealComponent.this.getZoomModel();
            LinealModel linealModel = VerticalLinealComponent.this.getLinealModel();
            double scaledPos = (double)((float)e.getY() / zoomModel.getZoomAsPercentage()) - start;
            float pageHeight = pageDefinition.getHeight();
            double position = Math.min((double)pageHeight, Math.max(0.0, scaledPos));
            GuideLine newGuideLine = new GuideLine(position, dragged.isActive());
            UndoManager undo = VerticalLinealComponent.this.getRenderContext().getUndo();
            undo.addChange(Messages.getString("LinealComponent.ChangeGuideUndoName", new Object[0]), new UpdateVerticalGuidelineUndoEntry(this.guideLineIndex, newGuideLine, dragged, VerticalLinealComponent.this.getInstanceID()));
            linealModel.updateGuideLine(this.guideLineIndex, newGuideLine);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            VerticalLinealComponent.this.updateGuidelineHighlight(e);
        }
    }

    private class LinealUpdateHandler
    implements LinealModelListener {
        private LinealUpdateHandler() {
        }

        @Override
        public void modelChanged(LinealModelEvent event) {
            VerticalLinealComponent.this.setActiveGuidLine(null);
            VerticalLinealComponent.this.repaint();
        }
    }

    private class PageFormatUpdateHandler
    implements ReportModelListener {
        private PageFormatUpdateHandler() {
        }

        public void nodeChanged(ReportModelEvent event) {
            if (event.getElement() == event.getReport()) {
                VerticalLinealComponent.this.revalidate();
                VerticalLinealComponent.this.repaint();
                VerticalLinealComponent.this.updatePageDefinition(event.getReport().getPageDefinition());
            }
        }
    }

    private class RootBandChangeHandler
    implements ChangeListener,
    ZoomModelListener {
        private RootBandChangeHandler() {
        }

        @Override
        public void zoomFactorChanged() {
            VerticalLinealComponent.this.invalidate();
            VerticalLinealComponent.this.revalidate();
            VerticalLinealComponent.this.repaint();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            VerticalLinealComponent.this.invalidate();
            VerticalLinealComponent.this.revalidate();
            VerticalLinealComponent.this.repaint();
        }
    }

    private class DeleteGuidelineAction
    extends AbstractAction {
        private final GuideLine guideLine;

        private DeleteGuidelineAction(GuideLine guideLine) {
            super(Messages.getString("LinealComponent.Delete", new Object[0]));
            this.guideLine = guideLine;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LinealModel linealModel = VerticalLinealComponent.this.getLinealModel();
            UndoManager undo = VerticalLinealComponent.this.getRenderContext().getUndo();
            undo.addChange(Messages.getString("LinealComponent.DeleteGuideUndoName", new Object[0]), new RemoveVerticalGuidelineUndoEntry(this.guideLine, VerticalLinealComponent.this.getInstanceID()));
            linealModel.removeGuideLine(this.guideLine);
        }
    }

    private class ActivateGuidelineAction
    extends AbstractAction {
        private final GuideLine guideLine;
        private int index;

        private ActivateGuidelineAction(GuideLine guideLine, int index) {
            super(Messages.getString("LinealComponent.Activate", new Object[0]));
            this.guideLine = guideLine;
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuideLine newGuideLine = new GuideLine(this.guideLine.getPosition(), true);
            LinealModel linealModel = VerticalLinealComponent.this.getLinealModel();
            UndoManager undo = VerticalLinealComponent.this.getRenderContext().getUndo();
            undo.addChange(Messages.getString("LinealComponent.ActivateGuideUndoEntry", new Object[0]), new UpdateVerticalGuidelineUndoEntry(this.index, newGuideLine, this.guideLine, VerticalLinealComponent.this.getInstanceID()));
            linealModel.updateGuideLine(this.index, newGuideLine);
        }
    }

    private class DeactivateGuidelineAction
    extends AbstractAction {
        private final GuideLine guideLine;
        private int index;

        private DeactivateGuidelineAction(GuideLine guideLine, int index) {
            super(Messages.getString("LinealComponent.Deactivate", new Object[0]));
            this.guideLine = guideLine;
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuideLine newGuideLine = new GuideLine(this.guideLine.getPosition(), false);
            LinealModel linealModel = VerticalLinealComponent.this.getLinealModel();
            UndoManager undo = VerticalLinealComponent.this.getRenderContext().getUndo();
            undo.addChange(Messages.getString("LinealComponent.DeactivateGuideUndoEntry", new Object[0]), new UpdateVerticalGuidelineUndoEntry(this.index, newGuideLine, this.guideLine, VerticalLinealComponent.this.getInstanceID()));
            linealModel.updateGuideLine(this.index, newGuideLine);
        }
    }

    private class GuidelinePropertiesAction
    extends AbstractAction {
        private GuideLine guideLine;
        private int index;

        private GuidelinePropertiesAction(GuideLine guideLine, int index) {
            super(Messages.getString("LinealComponent.Properties", new Object[0]));
            this.guideLine = guideLine;
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LinealModel linealModel = VerticalLinealComponent.this.getLinealModel();
            if (linealModel == null) {
                return;
            }
            VerticalLinealComponent parent = VerticalLinealComponent.this;
            Window window = LibSwingUtil.getWindowAncestor((Component)parent);
            GuideLineDialog spinnerDialog = window instanceof JDialog ? new GuideLineDialog((JDialog)window) : (window instanceof JFrame ? new GuideLineDialog((JFrame)window) : new GuideLineDialog());
            spinnerDialog.setUnit(WorkspaceSettings.getInstance().getUnit());
            spinnerDialog.setPosition(this.guideLine.getPosition());
            if (spinnerDialog.showDialog()) {
                GuideLine newGuideLine = new GuideLine(spinnerDialog.getPosition(), this.guideLine.isActive());
                linealModel.updateGuideLine(this.index, newGuideLine);
                this.guideLine = newGuideLine;
            }
        }
    }

    private class GuidelinePopupHandler
    extends MouseAdapter {
        private GuidelinePopupHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            VerticalLinealComponent.this.updateGuidelineHighlight(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            int padding = (int)VerticalLinealComponent.this.getPadding();
            if (e.getX() < padding) {
                return;
            }
            if (VerticalLinealComponent.this.getActiveGuidLine() != null) {
                VerticalLinealComponent.this.setActiveGuidLine(null);
                VerticalLinealComponent.this.repaint();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            VerticalLinealComponent.this.updateGuidelineHighlight(e);
            VerticalLinealComponent.this.popup(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            VerticalLinealComponent.this.updateGuidelineHighlight(e);
            VerticalLinealComponent.this.popup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            VerticalLinealComponent.this.updateGuidelineHighlight(e);
            VerticalLinealComponent.this.popup(e);
        }
    }
}

