/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.structuretree;

import java.util.ArrayList;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportFieldNode;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportFunctionNode;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportQueryNode;
import org.pentaho.reporting.designer.core.model.DataSchemaUtility;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportEnvironmentDataRow;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeUtil;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionCollection;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public abstract class AbstractReportDataTreeModel
implements TreeModel {
    private EventListenerList eventListenerList;
    private ReportFunctionNode reportFunctionNode;
    private ReportDocumentContext context;
    private ReportEnvironmentDataRow reportEnvironmentDataRow;
    private Expression[] cachedExpressions;

    protected AbstractReportDataTreeModel(ReportDocumentContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.context = context;
        this.reportEnvironmentDataRow = new ReportEnvironmentDataRow(((MasterReport)context.getContextRoot()).getReportEnvironment());
        this.eventListenerList = new EventListenerList();
        this.reportFunctionNode = new ReportFunctionNode();
        this.refreshExpressionsCache();
    }

    protected AbstractReportDefinition getReportDefinition() {
        return this.context.getReportDefinition();
    }

    public ReportEnvironmentDataRow getReportEnvironmentDataRow() {
        return this.reportEnvironmentDataRow;
    }

    protected ReportDocumentContext getContext() {
        return this.context;
    }

    public ReportFunctionNode getReportFunctionNode() {
        return this.reportFunctionNode;
    }

    protected CompoundDataFactory getDataFactoryElement() {
        return (CompoundDataFactory)this.context.getReportDefinition().getDataFactory();
    }

    protected ExpressionCollection getExpressions() {
        return this.context.getReportDefinition().getExpressions();
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.getDataFactoryElement()) {
            CompoundDataFactory dataFactoryElement = this.getDataFactoryElement();
            return dataFactoryElement.getReference(index);
        }
        if (parent == this.reportEnvironmentDataRow) {
            String[] columnNames = this.reportEnvironmentDataRow.getColumnNames();
            String name = columnNames[index];
            Class targetClass = this.reportEnvironmentDataRow.isArray(name) ? Object[].class : Object.class;
            return new ReportFieldNode(this.getContext(), name, targetClass);
        }
        if (parent == this.reportFunctionNode) {
            return this.getExpressions().getExpression(index);
        }
        if (parent instanceof DataFactory) {
            DataFactory dataFactory = (DataFactory)parent;
            String[] queryNames = dataFactory.getQueryNames();
            return new ReportQueryNode(dataFactory, queryNames[index], true);
        }
        if (parent instanceof ReportQueryNode) {
            ReportQueryNode queryNode = (ReportQueryNode)parent;
            if (this.isSelectedDataSource(queryNode)) {
                String[] names = this.getDataFactoryColumns();
                String name = names[index];
                ContextAwareDataSchemaModel model = this.context.getReportDataSchemaModel();
                DataAttributes attributes = model.getDataSchema().getAttributes(name);
                Class type = (Class)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "value-type", Class.class, model.getDataAttributeContext());
                DataFactory dataFactory = queryNode.getDataFactory();
                return new ReportFieldNode(this.context, dataFactory, name, type);
            }
            throw new IndexOutOfBoundsException();
        }
        return null;
    }

    private boolean isSelectedDataSource(ReportQueryNode queryNode) {
        AbstractReportDefinition reportDefinition = this.context.getReportDefinition();
        return DesignTimeUtil.isSelectedDataSource((AbstractReportDefinition)reportDefinition, (DataFactory)queryNode.getDataFactory(), (String)queryNode.getQueryName());
    }

    private String[] getDataFactoryColumns() {
        ContextAwareDataSchemaModel model = this.context.getReportDataSchemaModel();
        String[] columnNames = model.getColumnNames();
        ArrayList<String> targetCols = new ArrayList<String>(columnNames.length);
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            DataAttributes attributes = model.getDataSchema().getAttributes(columnName);
            if (attributes == null || DataSchemaUtility.isFiltered(attributes, model.getDataAttributeContext()) || !"table".equals(attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "source", String.class, model.getDataAttributeContext()))) continue;
            targetCols.add(columnName);
        }
        return targetCols.toArray(new String[targetCols.size()]);
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.reportEnvironmentDataRow) {
            return this.reportEnvironmentDataRow.getColumnNames().length;
        }
        if (parent == this.getDataFactoryElement()) {
            CompoundDataFactory dataFactoryElement = this.getDataFactoryElement();
            return dataFactoryElement.size();
        }
        if (parent == this.reportFunctionNode) {
            return this.getExpressions().size();
        }
        if (parent instanceof DataFactory) {
            DataFactory df = (DataFactory)parent;
            return df.getQueryNames().length;
        }
        if (parent instanceof ReportQueryNode) {
            ReportQueryNode queryNode = (ReportQueryNode)parent;
            if (this.isSelectedDataSource(queryNode)) {
                return this.getDataFactoryColumns().length;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node == this.getDataFactoryElement()) {
            return false;
        }
        if (node instanceof DataFactory) {
            DataFactory dataFactory = (DataFactory)node;
            return dataFactory.getQueryNames().length == 0;
        }
        if (node instanceof ReportQueryNode) {
            ReportQueryNode queryNode = (ReportQueryNode)node;
            return !this.isSelectedDataSource(queryNode);
        }
        if (node instanceof Expression) {
            return true;
        }
        return node instanceof ReportFieldNode;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.reportEnvironmentDataRow) {
            if (!(child instanceof ReportFieldNode)) {
                return -1;
            }
            ReportFieldNode fieldNode = (ReportFieldNode)child;
            String[] columnNames = this.reportEnvironmentDataRow.getColumnNames();
            for (int i = 0; i < columnNames.length; ++i) {
                String columnName = columnNames[i];
                if (!columnName.equals(fieldNode.getFieldName())) continue;
                return i;
            }
            return -1;
        }
        if (parent == this.getDataFactoryElement()) {
            CompoundDataFactory dataFactoryElement = this.getDataFactoryElement();
            for (int i = 0; i < dataFactoryElement.size(); ++i) {
                DataFactory dataFactory = dataFactoryElement.getReference(i);
                if (dataFactory != child) continue;
                return i;
            }
            return -1;
        }
        if (parent instanceof DataFactory) {
            if (!(child instanceof ReportQueryNode)) {
                return -1;
            }
            ReportQueryNode rfn = (ReportQueryNode)child;
            if (rfn.getDataFactory() != parent) {
                return -1;
            }
            String[] queryNames = rfn.getDataFactory().getQueryNames();
            return this.indexOf(queryNames, rfn.getQueryName());
        }
        if (parent instanceof ReportQueryNode) {
            ReportQueryNode queryNode = (ReportQueryNode)parent;
            if (!(child instanceof ReportFieldNode)) {
                return -1;
            }
            ReportFieldNode node = (ReportFieldNode)child;
            if (node.getSource() != queryNode.getDataFactory()) {
                return -1;
            }
            if (!this.isSelectedDataSource(queryNode)) {
                return -1;
            }
            return this.indexOf(this.getDataFactoryColumns(), node.getFieldName());
        }
        if (parent == this.reportFunctionNode) {
            ExpressionCollection expressionCollection = this.getExpressions();
            for (int i = 0; i < expressionCollection.size(); ++i) {
                Expression dataFactory = expressionCollection.getExpression(i);
                if (dataFactory != child) continue;
                return i;
            }
            return -1;
        }
        return -1;
    }

    protected int indexOf(String[] array, String key) {
        for (int i = 0; i < array.length; ++i) {
            String value = array[i];
            if (!ObjectUtilities.equal((Object)key, (Object)value)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public void fireTreeDataChanged() {
        TreeModelListener[] treeModelListeners = this.getListeners();
        TreeModelEvent treeEvent = new TreeModelEvent((Object)this, new TreePath(this.getRoot()));
        for (int i = 0; i < treeModelListeners.length; ++i) {
            TreeModelListener listener = treeModelListeners[i];
            listener.treeStructureChanged(treeEvent);
        }
        this.refreshExpressionsCache();
    }

    private void refreshExpressionsCache() {
        this.cachedExpressions = this.getReportDefinition().getExpressions().getExpressions();
    }

    protected TreeModelListener[] getListeners() {
        return (TreeModelListener[])this.eventListenerList.getListeners(TreeModelListener.class);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this.eventListenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this.eventListenerList.remove(TreeModelListener.class, l);
    }

    public void fireTreeNodeChanged(Object element) {
        TreePath path = this.getPathForNode(element);
        if (path == null) {
            path = new TreePath(this.getRoot());
        }
        TreeModelListener[] treeModelListeners = this.getListeners();
        TreeModelEvent treeEvent = new TreeModelEvent((Object)this, path);
        for (int i = treeModelListeners.length - 1; i >= 0; --i) {
            TreeModelListener listener = treeModelListeners[i];
            listener.treeNodesChanged(treeEvent);
        }
    }

    public void fireTreeStructureChanged(Object element) {
        TreePath path = this.getPathForNode(element);
        if (path == null) {
            path = new TreePath(this.getRoot());
        }
        TreeModelListener[] treeModelListeners = this.getListeners();
        TreeModelEvent treeEvent = new TreeModelEvent((Object)this, path);
        for (int i = treeModelListeners.length - 1; i >= 0; --i) {
            TreeModelListener listener = treeModelListeners[i];
            listener.treeStructureChanged(treeEvent);
        }
        this.refreshExpressionsCache();
    }

    public void fireQueryChanged(Object query) {
        if (query == null) {
            return;
        }
        ArrayList<ReportQueryNode> nodes = new ArrayList<ReportQueryNode>();
        this.findAllQueryNodes(query, nodes, this.getDataFactoryElement());
        TreeModelListener[] treeModelListeners = this.getListeners();
        for (int n = 0; n < nodes.size(); ++n) {
            ReportQueryNode queryNode = nodes.get(n);
            TreePath path = this.getPathForNode(queryNode.getDataFactory());
            TreePath queryPath = path.pathByAddingChild(queryNode);
            TreeModelEvent treeEvent = new TreeModelEvent((Object)this, queryPath);
            for (int i = treeModelListeners.length - 1; i >= 0; --i) {
                TreeModelListener listener = treeModelListeners[i];
                listener.treeStructureChanged(treeEvent);
            }
        }
    }

    protected void findAllQueryNodes(Object query, ArrayList<ReportQueryNode> nodes, Object element) {
        int childCount = this.getChildCount(element);
        for (int i = 0; i < childCount; ++i) {
            ReportQueryNode queryNode;
            Object child = this.getChild(element, i);
            if (child instanceof ReportQueryNode && query.equals((queryNode = (ReportQueryNode)child).getQueryName())) {
                nodes.add(queryNode);
            }
            if (this.isLeaf(child)) continue;
            this.findAllQueryNodes(query, nodes, child);
        }
    }

    public void fireExpressionAdded(Expression parameter) {
        TreePath pathForNode = new TreePath(new Object[]{this.getRoot(), this.getReportFunctionNode()});
        TreeModelListener[] treeModelListeners = this.getListeners();
        int index = this.getIndexOfChild(this.getReportFunctionNode(), parameter);
        if (index == -1) {
            return;
        }
        TreeModelEvent treeEvent = new TreeModelEvent((Object)this, pathForNode, new int[]{index}, new Object[]{parameter});
        for (int i = treeModelListeners.length - 1; i >= 0; --i) {
            TreeModelListener listener = treeModelListeners[i];
            listener.treeNodesInserted(treeEvent);
        }
        this.refreshExpressionsCache();
    }

    public void fireExpressionRemoved(Expression parameter) {
        TreePath pathForNode = new TreePath(new Object[]{this.getRoot(), this.getReportFunctionNode()});
        TreeModelListener[] treeModelListeners = this.getListeners();
        int index = this.findExpressionInCache(parameter);
        if (index == -1) {
            return;
        }
        TreeModelEvent treeEvent = new TreeModelEvent((Object)this, pathForNode, new int[]{index}, new Object[]{parameter});
        for (int i = treeModelListeners.length - 1; i >= 0; --i) {
            TreeModelListener listener = treeModelListeners[i];
            listener.treeNodesRemoved(treeEvent);
        }
        this.refreshExpressionsCache();
    }

    private int findExpressionInCache(Expression parameter) {
        if (this.cachedExpressions == null) {
            return -1;
        }
        for (int i = 0; i < this.cachedExpressions.length; ++i) {
            Expression cachedExpression = this.cachedExpressions[i];
            if (cachedExpression != parameter) continue;
            return i;
        }
        return -1;
    }

    public TreePath getPathForNode(Object node) {
        if (node == this.getRoot()) {
            return new TreePath(new Object[]{this.getRoot()});
        }
        if (node instanceof Expression) {
            ReportFunctionNode functions = this.getReportFunctionNode();
            if (this.getIndexOfChild(functions, node) < 0) {
                return null;
            }
            return new TreePath(new Object[]{this.getRoot(), functions, node});
        }
        if (node instanceof DataFactory) {
            CompoundDataFactory dataFactoryElement = this.getDataFactoryElement();
            if (this.getIndexOfChild(dataFactoryElement, node) < 0) {
                return null;
            }
            return new TreePath(new Object[]{this.getRoot(), dataFactoryElement, node});
        }
        if (node == this.getDataFactoryElement()) {
            return new TreePath(new Object[]{this.getRoot(), this.getDataFactoryElement()});
        }
        return null;
    }
}

