/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.structuretree;

import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.pentaho.reporting.designer.core.editor.structuretree.TreeSelectionHelper;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.function.ExpressionCollection;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;

public class ReportStructureTreeModel
implements TreeModel {
    private AbstractReportDefinition report;
    private EventListenerList eventListenerList;

    public ReportStructureTreeModel(AbstractReportDefinition masterReportElement) {
        if (masterReportElement == null) {
            throw new NullPointerException();
        }
        this.report = masterReportElement;
        this.eventListenerList = new EventListenerList();
    }

    protected CompoundDataFactory getDataFactoryElement() {
        return (CompoundDataFactory)this.report.getDataFactory();
    }

    protected ExpressionCollection getExpressions() {
        return this.report.getExpressions();
    }

    public AbstractReportDefinition getReport() {
        return this.report;
    }

    @Override
    public Object getRoot() {
        return this.report;
    }

    @Override
    public Object getChild(Object parent, int index) {
        Section re;
        if (!(parent instanceof Section)) {
            throw new IndexOutOfBoundsException();
        }
        if (parent instanceof RootLevelBand && index >= (re = (Section)parent).getElementCount()) {
            int subReportIndex = index - re.getElementCount();
            RootLevelBand rl = (RootLevelBand)parent;
            return rl.getSubReport(subReportIndex);
        }
        Section br = (Section)parent;
        if (this.isStrictOrderNeeded(br)) {
            return br.getElement(index);
        }
        return br.getElement(br.getElementCount() - index - 1);
    }

    private boolean isStrictOrderNeeded(Section section) {
        if (section instanceof AbstractReportDefinition || section instanceof Group || section instanceof GroupBody) {
            return true;
        }
        if (section instanceof Band) {
            Band b = (Band)section;
            Object o = b.getStyle().getStyleProperty(BandStyleKeys.LAYOUT);
            return o != null && !"canvas".equals(o);
        }
        return false;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent != this.report && parent instanceof SubReport) {
            return 0;
        }
        if (parent instanceof RootLevelBand && parent instanceof Section) {
            RootLevelBand re = (RootLevelBand)parent;
            Section se = (Section)parent;
            return re.getSubReportCount() + se.getElementCount();
        }
        if (parent instanceof Section) {
            Section br = (Section)parent;
            return br.getElementCount();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        RootLevelBand re;
        int subreportIndexOf;
        if (child != this.report && child instanceof SubReport) {
            return -1;
        }
        if (!(parent instanceof Section)) {
            return -1;
        }
        Section br = (Section)parent;
        if (parent instanceof RootLevelBand && child instanceof SubReport && (subreportIndexOf = ModelUtility.findSubreportIndexOf(re = (RootLevelBand)parent, (SubReport)child)) != -1) {
            return br.getElementCount() + subreportIndexOf;
        }
        if (!(child instanceof Element)) {
            return -1;
        }
        if (this.isStrictOrderNeeded(br)) {
            return ModelUtility.findIndexOf(br, (Element)child);
        }
        return br.getElementCount() - ModelUtility.findIndexOf(br, (Element)child) - 1;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof Element && !(node instanceof Section)) {
            return true;
        }
        return node instanceof SubReport && node != this.getRoot();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public void fireTreeDataChanged(Object source) {
        TreeModelListener[] treeModelListeners = (TreeModelListener[])this.eventListenerList.getListeners(TreeModelListener.class);
        TreeModelEvent treeEvent = new TreeModelEvent((Object)this, TreeSelectionHelper.getPathForNode(this, source));
        for (int i = treeModelListeners.length - 1; i >= 0; --i) {
            TreeModelListener listener = treeModelListeners[i];
            listener.treeStructureChanged(treeEvent);
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.eventListenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.eventListenerList.remove(TreeModelListener.class, l);
    }

    public void fireTreeNodeChanged(Object element) {
        TreePath path = TreeSelectionHelper.getPathForNode(this, element);
        TreeModelListener[] treeModelListeners = (TreeModelListener[])this.eventListenerList.getListeners(TreeModelListener.class);
        TreeModelEvent treeEvent = new TreeModelEvent((Object)this, path);
        for (int i = treeModelListeners.length - 1; i >= 0; --i) {
            TreeModelListener listener = treeModelListeners[i];
            listener.treeNodesChanged(treeEvent);
        }
    }

    public void fireTreeStructureChanged(Object element) {
        TreePath path = TreeSelectionHelper.getPathForNode(this, element);
        if (path == null) {
            path = new TreePath(this.getRoot());
        }
        TreeModelListener[] treeModelListeners = (TreeModelListener[])this.eventListenerList.getListeners(TreeModelListener.class);
        TreeModelEvent treeEvent = new TreeModelEvent((Object)this, path);
        for (int i = treeModelListeners.length - 1; i >= 0; --i) {
            TreeModelListener listener = treeModelListeners[i];
            listener.treeStructureChanged(treeEvent);
        }
    }
}

