/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.structuretree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ActionMap;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.global.CopyAction;
import org.pentaho.reporting.designer.core.actions.global.CutAction;
import org.pentaho.reporting.designer.core.actions.global.PasteAction;
import org.pentaho.reporting.designer.core.editor.ContextMenuUtility;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.structuretree.AbstractReportTree;
import org.pentaho.reporting.designer.core.editor.structuretree.DataReportTree;
import org.pentaho.reporting.designer.core.editor.structuretree.LayoutReportTree;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.SidePanel;

public class StructureTreePanel
extends SidePanel {
    private AbstractReportTree tree;
    private Object leadSelection;
    private CutAction cutAction = new CutAction();
    private CopyAction copyAction = new CopyAction();
    private PasteAction pasteAction = new PasteAction();
    public static final String LEAD_SELECTION_PROPERTY = "leadSelection";

    public StructureTreePanel(AbstractReportTree.RenderType renderType) {
        this.tree = renderType == AbstractReportTree.RenderType.REPORT ? new LayoutReportTree() : new DataReportTree();
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeLeadSelectionListener());
        this.tree.addMouseListener(new ReportTreeContextMenuHandler());
        ActionMap map = this.tree.getActionMap();
        map.put(TransferHandler.getCutAction().getValue("Name"), this.cutAction);
        map.put(TransferHandler.getCopyAction().getValue("Name"), this.copyAction);
        map.put(TransferHandler.getPasteAction().getValue("Name"), this.pasteAction);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    @Override
    protected void updateDesignerContext(ReportDesignerContext oldContext, ReportDesignerContext newContext) {
        super.updateDesignerContext(oldContext, newContext);
        this.cutAction.setReportDesignerContext(newContext);
        this.copyAction.setReportDesignerContext(newContext);
        this.pasteAction.setReportDesignerContext(newContext);
        this.tree.setReportDesignerContext(newContext);
    }

    @Override
    protected void updateSelection(DocumentContextSelectionModel model) {
    }

    @Override
    protected void updateActiveContext(ReportDocumentContext oldContext, ReportDocumentContext newContext) {
        super.updateActiveContext(oldContext, newContext);
        this.tree.setRenderContext(newContext);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.tree.setEnabled(enabled);
    }

    public Object getLeadSelection() {
        return this.leadSelection;
    }

    protected void setLeadSelection(Object leadSelection) {
        Object oldvalue = this.leadSelection;
        this.leadSelection = leadSelection;
        this.firePropertyChange(LEAD_SELECTION_PROPERTY, oldvalue, leadSelection);
    }

    protected JTree getTree() {
        return this.tree;
    }

    private class ReportTreeContextMenuHandler
    extends MouseAdapter {
        private ReportTreeContextMenuHandler() {
        }

        private void createPopupMenu(MouseEvent e) {
            Object o;
            JPopupMenu pop;
            JTree tree = StructureTreePanel.this.getTree();
            ReportDesignerContext context = StructureTreePanel.this.getReportDesignerContext();
            if (context.getActiveContext() == null) {
                return;
            }
            TreePath path = tree.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            if (!tree.getSelectionModel().isPathSelected(path)) {
                tree.getSelectionModel().setSelectionPath(path);
            }
            if ((pop = ContextMenuUtility.getMenu(context, o = path.getLastPathComponent())) == null) {
                return;
            }
            pop.show(tree, e.getX(), e.getY());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.createPopupMenu(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.createPopupMenu(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.createPopupMenu(e);
            }
        }
    }

    private class TreeLeadSelectionListener
    implements TreeSelectionListener {
        private TreeLeadSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            JTree tree = StructureTreePanel.this.getTree();
            TreePath selectionPath = tree.getLeadSelectionPath();
            if (selectionPath == null) {
                StructureTreePanel.this.setLeadSelection(null);
                return;
            }
            StructureTreePanel.this.setLeadSelection(selectionPath.getLastPathComponent());
        }
    }
}

