/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.styles.styleeditor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.editor.styles.Messages;
import org.pentaho.reporting.designer.core.editor.styles.styleeditor.StyleDefinitionEditorContext;
import org.pentaho.reporting.designer.core.status.ExceptionDialog;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.StyleDefinitionWriter;
import org.pentaho.reporting.engine.classic.core.style.css.ElementStyleDefinition;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.background.BackgroundCancellableProcessHelper;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.CommonFileChooser;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.FileChooserService;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class StyleDefinitionUtilities {
    private static final String DEFAULT_EXTENSION = ".prptstyle";
    private static final String FILE_CHOOSER_TYPE = "style-definition";
    private static final Log logger = LogFactory.getLog(StyleDefinitionUtilities.class);

    private StyleDefinitionUtilities() {
    }

    public static File promptReportFilename(Component parent, File defaultFile) {
        FilesystemFilter filter = new FilesystemFilter(new String[]{DEFAULT_EXTENSION}, Messages.getString("StyleDefinitionUtilities.FileDescription", new Object[0]), true);
        CommonFileChooser fileChooser = FileChooserService.getInstance().getFileChooser(FILE_CHOOSER_TYPE);
        fileChooser.setSelectedFile(defaultFile);
        fileChooser.setFilters(new FileFilter[]{filter});
        logger.debug((Object)"Prompting for save filename");
        if (!fileChooser.showDialog(parent, 1)) {
            logger.debug((Object)"Save filename - cancel option selected");
            return null;
        }
        File selectedFile = StyleDefinitionUtilities.validateFileExtension(fileChooser.getSelectedFile(), parent);
        if (selectedFile == null) {
            return null;
        }
        if (selectedFile.exists()) {
            logger.debug((Object)("Selected file exists [" + selectedFile.getName() + "] - prompting for overwrite..."));
            int overwrite = JOptionPane.showConfirmDialog(parent, Messages.getString("StyleDefinitionUtilities.OverwriteDialog.Message", selectedFile.getAbsolutePath()), Messages.getString("StyleDefinitionUtilities.OverwriteDialog.Title", new Object[0]), 0);
            if (overwrite == 1) {
                return null;
            }
        }
        return selectedFile;
    }

    public static boolean saveStyleDefinitionAs(StyleDefinitionEditorContext activeContext, Component parent) {
        File defaultFile = activeContext.getSource();
        File target = StyleDefinitionUtilities.promptReportFilename(parent, defaultFile);
        if (target == null) {
            return false;
        }
        activeContext.setSource(target);
        if (StyleDefinitionUtilities.saveStyleDefinition(activeContext, target)) {
            return true;
        }
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        ExceptionDialog exceptionDialog = window instanceof Dialog ? new ExceptionDialog((Dialog)window) : (window instanceof Frame ? new ExceptionDialog((Frame)window) : new ExceptionDialog());
        exceptionDialog.showDialog();
        return false;
    }

    public static boolean saveStyleDefinition(StyleDefinitionEditorContext activeContext, Component parent) {
        File target = activeContext.getSource();
        target = target == null ? StyleDefinitionUtilities.promptReportFilename(parent, null) : StyleDefinitionUtilities.validateFileExtension(target, parent);
        if (target == null) {
            return false;
        }
        activeContext.setSource(target);
        if (StyleDefinitionUtilities.saveStyleDefinition(activeContext, target)) {
            return true;
        }
        ExceptionDialog.showDialog(parent);
        return false;
    }

    private static boolean saveStyleDefinition(StyleDefinitionEditorContext activeContext, File target) {
        if (activeContext == null) {
            throw new IllegalArgumentException();
        }
        if (target == null) {
            throw new IllegalArgumentException();
        }
        try {
            logger.debug((Object)("Saving report in filename [" + target.getAbsolutePath() + "]"));
            StyleDefinitionWriter writer = new StyleDefinitionWriter();
            writer.write(target, activeContext.getStyleDefinition());
            return true;
        }
        catch (Exception e1) {
            UncaughtExceptionsModel.getInstance().addException(new IOException(Messages.getString("StyleDefinitionUtilities.SaveFailed.Message", new Object[0]), e1));
            logger.error((Object)"Failed to save report", (Throwable)e1);
            return false;
        }
    }

    public static File validateFileExtension(File proposedFile, Component parent) {
        if (proposedFile == null) {
            return null;
        }
        String s = proposedFile.getName();
        if (s.endsWith(DEFAULT_EXTENSION)) {
            return proposedFile;
        }
        String extension = IOUtils.getInstance().getFileExtension(s);
        if ("".equals(extension)) {
            File parentFile = proposedFile.getParentFile();
            if (parentFile == null) {
                return new File(IOUtils.getInstance().stripFileExtension(s) + DEFAULT_EXTENSION);
            }
            return new File(parentFile, IOUtils.getInstance().stripFileExtension(s) + DEFAULT_EXTENSION);
        }
        logger.debug((Object)"The selected filename does not have the standard extension - prompting the user to see if they want to change the extension");
        int result = JOptionPane.showConfirmDialog(parent, Messages.getString("StyleDefinitionUtilities.VerifyFileExtension.Message", proposedFile.getAbsolutePath()), Messages.getString("StyleDefinitionUtilities.VerifyFileExtension.Title", new Object[0]), 1);
        if (result == 2) {
            return null;
        }
        if (result == 1) {
            return proposedFile;
        }
        File validatedFile = new File(proposedFile.getParent(), IOUtils.getInstance().stripFileExtension(s) + DEFAULT_EXTENSION);
        logger.debug((Object)("User has selected YES - the filename has been changed to [" + validatedFile.getName() + "]"));
        return validatedFile;
    }

    public static void openStyleDefinition(StyleDefinitionEditorContext context) {
        FilesystemFilter filter = new FilesystemFilter(new String[]{DEFAULT_EXTENSION}, Messages.getString("StyleDefinitionUtilities.FileDescription", new Object[0]), true);
        CommonFileChooser fileChooser = FileChooserService.getInstance().getFileChooser(FILE_CHOOSER_TYPE);
        fileChooser.setFilters(new FileFilter[]{filter});
        fileChooser.setAllowMultiSelection(true);
        if (!fileChooser.showDialog(context.getParent(), 0)) {
            return;
        }
        for (File selectedFile : fileChooser.getSelectedFiles()) {
            SwingUtilities.invokeLater(new OpenReportTask(selectedFile, context));
        }
    }

    private static class LoadStyleDefinitionTask
    implements Runnable {
        private File file;
        private ElementStyleDefinition styleDefinition;
        private Exception exception;

        private LoadStyleDefinitionTask(File file) {
            if (file == null) {
                throw new NullPointerException();
            }
            this.file = file;
        }

        @Override
        public void run() {
            try {
                ResourceManager mgr = new ResourceManager();
                Resource directly = mgr.createDirectly((Object)this.file, ElementStyleDefinition.class);
                this.styleDefinition = (ElementStyleDefinition)directly.getResource();
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        public ElementStyleDefinition getStyleDefinition() {
            return this.styleDefinition;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public static class OpenReportTask
    implements Runnable {
        private File selectedFile;
        private StyleDefinitionEditorContext context;

        public OpenReportTask(File selectedFile, StyleDefinitionEditorContext context) {
            this.selectedFile = selectedFile;
            this.context = context;
        }

        @Override
        public void run() {
            OpenReportTask.openReport(this.selectedFile, this.context);
        }

        private static void openReport(File selectedFile, StyleDefinitionEditorContext context) {
            if (selectedFile == null) {
                throw new NullPointerException();
            }
            if (context == null) {
                throw new NullPointerException();
            }
            LoadStyleDefinitionTask target = new LoadStyleDefinitionTask(selectedFile);
            Thread loadThread = new Thread(target);
            loadThread.setDaemon(true);
            BackgroundCancellableProcessHelper.executeProcessWithCancelDialog((Thread)loadThread, null, (Component)context.getParent(), (String)Messages.getString("StyleDefinitionUtilities.LoadMessage", new Object[0]));
            ElementStyleDefinition report = target.getStyleDefinition();
            if (report != null) {
                context.setStyleDefinition(report);
                context.setSource(selectedFile);
            } else {
                Exception exception = target.getException();
                if (exception instanceof ResourceCreationException) {
                    UncaughtExceptionsModel.getInstance().addException(exception);
                    ExceptionDialog.showDialog(context.getParent());
                } else if (exception != null) {
                    UncaughtExceptionsModel.getInstance().addException(exception);
                    ExceptionDialog.showDialog(context.getParent());
                }
            }
        }
    }
}

