/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.frame;

import java.io.File;
import java.util.List;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.ReportDesignerView;
import org.pentaho.reporting.designer.core.actions.global.OpenRecentReportAction;
import org.pentaho.reporting.designer.core.settings.SettingsListener;
import org.pentaho.reporting.designer.core.xul.ActionSwingMenuitem;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.components.XulMenuitem;
import org.pentaho.ui.xul.containers.XulMenupopup;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.tags.SwingMenuseparator;

public class RecentFilesUpdateHandler
implements SettingsListener {
    private final ReportDesignerView xulDesignerFrame;
    private ReportDesignerContext context;
    private XulMenupopup reopenMenu;
    private XulMenuitem clearMenu;

    public RecentFilesUpdateHandler(ReportDesignerContext context, XulMenupopup reopenMenu, XulMenuitem clearMenu) {
        this.context = context;
        this.xulDesignerFrame = context.getView();
        this.reopenMenu = reopenMenu;
        this.clearMenu = clearMenu;
    }

    @Override
    public void settingsChanged() {
        int i;
        File[] recentFiles = this.context.getRecentFilesModel().getRecentFiles();
        List xulComponents = this.reopenMenu.getChildNodes();
        XulComponent[] objects = xulComponents.toArray(new XulComponent[xulComponents.size()]);
        for (i = 0; i < objects.length; ++i) {
            XulComponent object = objects[i];
            this.reopenMenu.removeChild((Element)object);
        }
        if (recentFiles.length == 0) {
            this.clearMenu.setDisabled(true);
        } else {
            this.clearMenu.setDisabled(false);
            for (i = 0; i < recentFiles.length; ++i) {
                File file = recentFiles[i];
                if (!file.exists()) continue;
                OpenRecentReportAction action = new OpenRecentReportAction(file);
                ActionSwingMenuitem actionSwingMenuitem = this.xulDesignerFrame.createMenuItem(action);
                actionSwingMenuitem.setReportDesignerContext(this.context);
                this.reopenMenu.addChild((Element)actionSwingMenuitem);
            }
            this.reopenMenu.addChild((Element)new SwingMenuseparator(null, null, null, null));
        }
    }
}

