/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.inspections.impl;

import java.util.HashSet;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.inspections.Inspection;
import org.pentaho.reporting.designer.core.inspections.InspectionResult;
import org.pentaho.reporting.designer.core.inspections.InspectionResultListener;
import org.pentaho.reporting.designer.core.inspections.LocationInfo;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModel;

public class DuplicateFieldInspection
implements Inspection {
    @Override
    public boolean isInlineInspection() {
        return true;
    }

    @Override
    public void inspect(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler) throws ReportDataFactoryException {
        String columnName;
        AbstractReportDefinition reportDefinition = reportRenderContext.getReportDefinition();
        ContextAwareDataSchemaModel model = reportRenderContext.getReportDataSchemaModel();
        String[] columnNames = model.getColumnNames();
        HashSet<String> warnedNames = new HashSet<String>();
        HashSet<String> exprNames = new HashSet<String>();
        Expression[] expressions = reportDefinition.getExpressions().getExpressions();
        for (int i = 0; i < expressions.length; ++i) {
            Expression expression = expressions[i];
            columnName = expression.getName();
            if (exprNames.add(columnName)) continue;
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("DuplicateFieldInspection.ExpressionDuplicate", columnName), new LocationInfo(reportDefinition)));
            warnedNames.add(columnName);
        }
        HashSet<String> cols = new HashSet<String>();
        for (int i = 0; i < columnNames.length; ++i) {
            columnName = columnNames[i];
            if (warnedNames.contains(columnName) || cols.add(columnName)) continue;
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("DuplicateFieldInspection.OtherDuplicate", columnName), new LocationInfo(reportDefinition)));
        }
    }
}

