/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.inspections.impl;

import java.util.Locale;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.inspections.Inspection;
import org.pentaho.reporting.designer.core.inspections.InspectionResult;
import org.pentaho.reporting.designer.core.inspections.InspectionResultListener;
import org.pentaho.reporting.designer.core.inspections.LocationInfo;
import org.pentaho.reporting.designer.core.inspections.PropertyLocationInfo;
import org.pentaho.reporting.designer.core.inspections.impl.AbstractStructureInspection;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;

public class InvalidElementReferenceInspection
extends AbstractStructureInspection {
    @Override
    public boolean isInlineInspection() {
        return true;
    }

    @Override
    protected void inspectElement(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element) {
    }

    @Override
    protected void inspectExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, Expression expression, ExpressionMetaData expressionMetaData) {
        if (expressionMetaData == null) {
            return;
        }
        try {
            BeanUtility utility = new BeanUtility((Object)expression);
            ExpressionPropertyMetaData[] datas = expressionMetaData.getPropertyDescriptions();
            for (int i = 0; i < datas.length; ++i) {
                ExpressionPropertyMetaData metaData = datas[i];
                if (metaData.isHidden() || !WorkspaceSettings.getInstance().isVisible((MetaData)metaData) || !"ElementName".equals(metaData.getPropertyRole())) continue;
                Object o = utility.getProperty(metaData.getName());
                String[] elements = metaData.getReferencedElements(expression, o);
                for (int j = 0; j < elements.length; ++j) {
                    String element = elements[j];
                    AbstractReportDefinition reportDefinition = reportRenderContext.getReportDefinition();
                    ReportElement e = FunctionUtilities.findElementByAttribute((Section)reportDefinition, (String)"http://reporting.pentaho.org/namespaces/engine/attributes/core", (String)"name", (String)element);
                    if (e != null) continue;
                    resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("InvalidElementReferenceInspection.ExpressionReferencesInvalidName", expression.getName(), metaData.getDisplayName(Locale.getDefault())), new PropertyLocationInfo(expression, metaData.getName())));
                }
            }
        }
        catch (Exception e) {
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, e.getMessage(), new LocationInfo(expression)));
        }
    }
}

