/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.model;

import java.util.Arrays;

public final class HorizontalPositionsList {
    private static final long[] EMPTY_KEYS = new long[0];
    private static final long[] EMPTY_AGES = new long[0];
    private long[] keys;
    private long[] age;
    private int size;
    private int increment;
    private boolean enableQuickLookup;
    private long scaleFactor;

    public HorizontalPositionsList() {
        this(25, true);
    }

    public HorizontalPositionsList(int increment, boolean enableQuickLookup) {
        if (increment < 1) {
            throw new IllegalArgumentException();
        }
        this.increment = increment;
        this.keys = EMPTY_KEYS;
        this.age = EMPTY_AGES;
        this.enableQuickLookup = enableQuickLookup;
    }

    public void clear() {
        Arrays.fill(this.age, -1L);
        Arrays.fill(this.keys, 0L);
        this.scaleFactor = 0L;
        this.size = 0;
    }

    public boolean isEnableQuickLookup() {
        return this.enableQuickLookup;
    }

    public void setEnableQuickLookup(boolean enableQuickLookup) {
        this.enableQuickLookup = enableQuickLookup;
    }

    public int size() {
        return this.size;
    }

    public void ensureCapacity(int c) {
        if (this.keys.length <= c) {
            long[] newKeys = new long[Math.max(this.keys.length + this.increment, c + 1)];
            System.arraycopy(this.keys, 0, newKeys, 0, this.size);
            this.keys = newKeys;
            long[] newAges = new long[Math.max(this.age.length + this.increment, c + 1)];
            System.arraycopy(this.age, 0, newAges, 0, this.size);
            this.age = newAges;
        }
    }

    public long getAge(long key) {
        int pos = this.findKeyInternal(key);
        if (pos >= 0) {
            return this.age[pos];
        }
        return -1L;
    }

    public boolean add(long key, long age) {
        int position;
        int maxIdx;
        long lastVal;
        if (this.size > 0 && key > this.keys[this.size - 1]) {
            this.ensureCapacity(this.size + 1);
            this.keys[this.size] = key;
            this.age[this.size] = age;
            ++this.size;
            this.scaleFactor = key / (long)this.size;
            return true;
        }
        int start = 0;
        int end = this.size;
        if (this.enableQuickLookup && this.size > 0 && (lastVal = this.keys[maxIdx = this.size - 1]) > 0L) {
            boolean maxMorePos;
            int targetIdx = (int)(key / this.scaleFactor);
            int minTgtIdx = Math.max(0, Math.min(maxIdx, targetIdx - 7));
            int maxTgtIdx = Math.min(maxIdx, targetIdx + 7);
            long minKey = this.keys[minTgtIdx];
            long maxKey = this.keys[maxTgtIdx];
            boolean minLessPos = key >= minKey;
            boolean bl = maxMorePos = key <= maxKey;
            if (minLessPos) {
                start = minTgtIdx;
            }
            if (maxMorePos) {
                end = maxTgtIdx + 1;
            }
        }
        if ((position = this.binarySearch(this.keys, key, start, end)) >= 0) {
            this.age[position] = age;
            return false;
        }
        this.ensureCapacity(this.size + 1);
        int insertPoint = -(position + 1);
        if (insertPoint < this.size) {
            System.arraycopy(this.keys, insertPoint, this.keys, insertPoint + 1, this.size - insertPoint);
            System.arraycopy(this.age, insertPoint, this.age, insertPoint + 1, this.size - insertPoint);
        }
        this.keys[insertPoint] = key;
        this.age[insertPoint] = age;
        ++this.size;
        this.scaleFactor = insertPoint == this.size - 1 ? key / (long)this.size : this.keys[this.size - 1] / (long)this.size;
        return true;
    }

    private int findKeyInternal(long pos) {
        int i;
        int maxIdx;
        long lastVal;
        int start = 0;
        int end = this.size;
        if (this.enableQuickLookup && this.size > 0 && (lastVal = this.keys[maxIdx = this.size - 1]) > 0L) {
            boolean maxMorePos;
            int targetIdx = (int)(pos / this.scaleFactor);
            int minTgtIdx = Math.max(0, Math.min(maxIdx, targetIdx - 7));
            int maxTgtIdx = Math.min(maxIdx, targetIdx + 7);
            long minKey = this.keys[minTgtIdx];
            long maxKey = this.keys[maxTgtIdx];
            boolean minLessPos = pos >= minKey;
            boolean bl = maxMorePos = pos <= maxKey;
            if (minLessPos) {
                start = minTgtIdx;
            }
            if (maxMorePos) {
                end = maxTgtIdx + 1;
            }
        }
        if ((i = this.binarySearch(this.keys, pos, start, end)) > -1) {
            return i;
        }
        if (i == -1) {
            return -1;
        }
        return i;
    }

    public boolean remove(long key) {
        int position = this.findKeyInternal(key);
        if (position < 0) {
            return false;
        }
        int shiftElements = this.size - position - 1;
        if (shiftElements == 0) {
            this.keys[position] = 0L;
            --this.size;
            this.scaleFactor = this.keys[this.size - 1] / (long)this.size;
            return true;
        }
        --this.size;
        System.arraycopy(this.keys, position + 1, this.keys, position, shiftElements);
        this.keys[this.size] = 0L;
        this.scaleFactor = this.keys[this.size - 1] / (long)this.size;
        return true;
    }

    public long getNext(long key) {
        if (this.size == 0) {
            return key;
        }
        if (key > this.keys[this.size - 1]) {
            return this.keys[this.size - 1];
        }
        int position = this.findKeyInternal(key);
        if (position == -1) {
            return this.keys[0];
        }
        if (position < 0) {
            int insertPoint = -(position + 1);
            return this.keys[insertPoint];
        }
        return this.keys[position];
    }

    public long getPrevious(long key) {
        if (this.size == 0) {
            return key;
        }
        if (key > this.keys[this.size - 1]) {
            return this.keys[this.size - 1];
        }
        int position = this.findKeyInternal(key);
        if (position >= 0) {
            return this.keys[position];
        }
        if (position == -1) {
            return this.keys[0];
        }
        int insertPoint = -(position + 2);
        return this.keys[insertPoint];
    }

    public boolean containsKey(long key) {
        if (this.size > 0 && key > this.keys[this.size - 1]) {
            return false;
        }
        return this.findKeyInternal(key) >= 0;
    }

    private int binarySearch(long[] array, long key, int start, int end) {
        int low = start;
        int high = end - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = array[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public long[] getKeys() {
        if (this.size == 0) {
            return EMPTY_KEYS;
        }
        if (this.size == this.keys.length) {
            return (long[])this.keys.clone();
        }
        long[] retval = new long[this.size];
        System.arraycopy(this.keys, 0, retval, 0, this.size);
        return retval;
    }

    public long[] getKeys(long[] retval) {
        if (retval == null || retval.length < this.size) {
            retval = new long[this.size];
        }
        System.arraycopy(this.keys, 0, retval, 0, this.size);
        return retval;
    }

    public int findKeyPosition(long coordinate, boolean greater) {
        int pos = this.findKeyInternal(coordinate);
        if (pos == this.size) {
            return this.size - 1;
        }
        if (pos >= 0) {
            return pos;
        }
        if (pos == -(this.size + 1)) {
            return this.size - 1;
        }
        if (greater) {
            return -pos - 1;
        }
        return -pos - 2;
    }

    public long getKeyAt(int indexPosition) {
        if (indexPosition >= this.size || indexPosition < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.keys[indexPosition];
    }

    public long findKey(long key, boolean upperBounds) {
        int pos = this.findKeyPosition(key, upperBounds);
        return this.keys[pos];
    }

    public boolean removeAll(long age) {
        int sourcePosition;
        int targetPosition = 0;
        for (sourcePosition = 0; sourcePosition < this.size; ++sourcePosition) {
            long key = this.keys[sourcePosition];
            if (this.age[sourcePosition] < age) continue;
            this.keys[targetPosition] = key;
            ++targetPosition;
        }
        if (targetPosition == sourcePosition) {
            return false;
        }
        Arrays.fill(this.keys, targetPosition, this.size, 0L);
        this.size = targetPosition;
        this.scaleFactor = this.size > 0 ? this.keys[this.size - 1] / (long)this.size : 0L;
        return true;
    }
}

