/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.model;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.model.HorizontalPositionsList;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;

public class HorizontalPositionsModel {
    private HorizontalPositionsList backend = new HorizontalPositionsList();
    private EventListenerList listenerList = new EventListenerList();

    protected HorizontalPositionsModel() {
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public int size() {
        return this.backend.size();
    }

    public void fireChangeEvent() {
        ChangeListener[] changeListeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        if (changeListeners == null) {
            return;
        }
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = 0; i < changeListeners.length; ++i) {
            ChangeListener changeListener = changeListeners[i];
            changeListener.stateChanged(changeEvent);
        }
    }

    public synchronized long[] getBreaks() {
        return this.backend.getKeys();
    }

    public boolean add(long[] breaks, long age) {
        boolean retval = false;
        for (int i = 0; i < breaks.length; ++i) {
            long aBreak = breaks[i];
            if (!this.backend.add(aBreak, age)) continue;
            retval = true;
        }
        return retval;
    }

    public boolean clear(long age) {
        return this.backend.removeAll(age);
    }

    public static HorizontalPositionsModel getHorizontalPositionsModel(ReportRenderContext reportContext) {
        AbstractReportDefinition rootBand = reportContext.getReportDefinition();
        Object maybeLinealModel = rootBand.getAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "positions-model-object");
        if (maybeLinealModel instanceof HorizontalPositionsModel) {
            return (HorizontalPositionsModel)maybeLinealModel;
        }
        HorizontalPositionsModel linealModel = new HorizontalPositionsModel();
        rootBand.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "positions-model-object", (Object)linealModel, false);
        return linealModel;
    }
}

