/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.settings.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.designer.core.settings.DateFormatModel;
import org.pentaho.reporting.designer.core.settings.NumberFormatModel;
import org.pentaho.reporting.designer.core.settings.SettingsMessages;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.settings.ui.FormatEditorDialog;
import org.pentaho.reporting.designer.core.settings.ui.SettingsPlugin;
import org.pentaho.reporting.designer.core.settings.ui.ValidationResult;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.engine.classic.core.metadata.MaturityLevel;

public class GeneralSettingsPanel
extends JPanel
implements SettingsPlugin {
    private JCheckBox showExpertItems;
    private JCheckBox openLastReport;
    private JCheckBox showDeprecatedItems;
    private JCheckBox showDebugItems;
    private JCheckBox experimentalFeatures;
    private JCheckBox notifyDevBuilds;
    private JCheckBox enableVersionChecker;
    private LookAndFeelModel lookAndFeelModel;
    private JTextField dateFormatField;
    private JTextField timeFormatField;
    private JTextField datetimeFormatField;
    private JCheckBox showIndexColumns;
    private String[] dateFormats;
    private String[] numberFormats;
    private DateFormatModel dateFormatModel;
    private NumberFormatModel numberFormatModel;

    public GeneralSettingsPanel() {
        this.setLayout(new BorderLayout());
        this.dateFormatModel = new DateFormatModel();
        this.numberFormatModel = new NumberFormatModel();
        this.dateFormats = new String[0];
        this.numberFormats = new String[0];
        WorkspaceSettings workspaceSettings = WorkspaceSettings.getInstance();
        this.dateFormatField = new JTextField();
        this.dateFormatField.setColumns(50);
        this.timeFormatField = new JTextField();
        this.timeFormatField.setColumns(50);
        this.datetimeFormatField = new JTextField();
        this.datetimeFormatField.setColumns(50);
        this.lookAndFeelModel = new LookAndFeelModel();
        this.lookAndFeelModel.setSelectedItem(workspaceSettings.getLNF());
        this.enableVersionChecker = new JCheckBox(SettingsMessages.getInstance().getString("GeneralSettingsPanel.EnableVersionChecker"));
        this.enableVersionChecker.setSelected(workspaceSettings.isUseVersionChecker());
        this.enableVersionChecker.addChangeListener(new EnableVersionCheckerSelectionHandler());
        this.notifyDevBuilds = new JCheckBox(SettingsMessages.getInstance().getString("GeneralSettingsPanel.NotifyUnsupportedVersions"));
        this.notifyDevBuilds.setSelected(workspaceSettings.isNotifyForAllBuilds());
        this.notifyDevBuilds.setEnabled(workspaceSettings.isUseVersionChecker());
        this.experimentalFeatures = new JCheckBox(SettingsMessages.getInstance().getString("GeneralSettingsPanel.EnableCommunityFeatures"));
        this.experimentalFeatures.setSelected(workspaceSettings.isExperimentalFeaturesVisible());
        this.showIndexColumns = new JCheckBox(SettingsMessages.getInstance().getString("GeneralSettingsPanel.ShowIndexColumns"));
        this.showIndexColumns.setSelected(workspaceSettings.isShowIndexColumns());
        this.showDeprecatedItems = new JCheckBox(SettingsMessages.getInstance().getString("GeneralSettingsPanel.ShowDeprecatedItems"));
        this.showDeprecatedItems.setSelected(workspaceSettings.isShowDeprecatedItems());
        this.showExpertItems = new JCheckBox(SettingsMessages.getInstance().getString("GeneralSettingsPanel.ShowExpertItems"));
        this.showExpertItems.setSelected(workspaceSettings.isShowExpertItems());
        this.showDebugItems = new JCheckBox(SettingsMessages.getInstance().getString("GeneralSettingsPanel.ShowDebugItems"));
        this.showDebugItems.setSelected(workspaceSettings.isDebugFeaturesVisible());
        this.openLastReport = new JCheckBox(SettingsMessages.getInstance().getString("GeneralSettingsPanel.OpenLastReport"));
        this.openLastReport.setSelected(workspaceSettings.isShowExpertItems());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        contentPanel.add((Component)this.createUpdatesPanel(), c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.fill = 2;
        contentPanel.add((Component)this.createLookandFeelPanel(), c);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 1.0;
        c.fill = 2;
        contentPanel.add((Component)this.createDataFormatSettings(), c);
        c.gridx = 0;
        c.gridy = 3;
        c.weightx = 1.0;
        c.fill = 2;
        contentPanel.add((Component)this.createOtherSettings(), c);
        this.add((Component)contentPanel, "North");
        this.reset();
    }

    private JPanel createLookandFeelPanel() {
        JComboBox lookAndFeels = new JComboBox(this.lookAndFeelModel);
        JPanel lookAndFeelPanel = new JPanel(new GridBagLayout());
        lookAndFeelPanel.setBorder(BorderFactory.createTitledBorder(SettingsMessages.getInstance().getString("GeneralSettingsPanel.LookAndFeel")));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 0;
        c.anchor = 17;
        lookAndFeelPanel.add(lookAndFeels, c);
        return lookAndFeelPanel;
    }

    private JPanel createUpdatesPanel() {
        JPanel updatesPanel = new JPanel();
        updatesPanel.setLayout(new GridBagLayout());
        updatesPanel.setBorder(BorderFactory.createTitledBorder(SettingsMessages.getInstance().getString("GeneralSettingsPanel.Updates")));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        updatesPanel.add((Component)this.enableVersionChecker, c);
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 17;
        updatesPanel.add((Component)this.notifyDevBuilds, c);
        return updatesPanel;
    }

    private JPanel createOtherSettings() {
        JPanel updatesPanel = new JPanel();
        updatesPanel.setLayout(new GridBagLayout());
        updatesPanel.setBorder(BorderFactory.createTitledBorder(SettingsMessages.getInstance().getString("GeneralSettingsPanel.OtherSettings")));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        updatesPanel.add((Component)this.showIndexColumns, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        updatesPanel.add((Component)this.experimentalFeatures, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        updatesPanel.add((Component)this.showDeprecatedItems, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        updatesPanel.add((Component)this.showExpertItems, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        updatesPanel.add((Component)this.showDebugItems, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        updatesPanel.add((Component)this.openLastReport, c);
        return updatesPanel;
    }

    private JPanel createDataFormatSettings() {
        JPanel updatesPanel = new JPanel();
        updatesPanel.setLayout(new GridBagLayout());
        updatesPanel.setBorder(BorderFactory.createTitledBorder(SettingsMessages.getInstance().getString("GeneralSettingsPanel.DataFormatSettings")));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        updatesPanel.add((Component)this.experimentalFeatures, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 10;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        updatesPanel.add((Component)new JLabel(SettingsMessages.getInstance().getString("GeneralSettingsPanel.DateFormatLabel")), c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 10;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        updatesPanel.add((Component)this.dateFormatField, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 11;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        updatesPanel.add((Component)new JLabel(SettingsMessages.getInstance().getString("GeneralSettingsPanel.TimeFormatLabel")), c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 11;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        updatesPanel.add((Component)this.timeFormatField, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 12;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        updatesPanel.add((Component)new JLabel(SettingsMessages.getInstance().getString("GeneralSettingsPanel.DatetimeFormatLabel")), c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 12;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        updatesPanel.add((Component)this.datetimeFormatField, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 13;
        c.gridwidth = 1;
        c.anchor = 17;
        updatesPanel.add((Component)new JButton(new EditFormatAction()), c);
        return updatesPanel;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getGeneralSettingsIcon32();
    }

    @Override
    public String getTitle() {
        return SettingsMessages.getInstance().getString("SettingsDialog.General");
    }

    @Override
    public ValidationResult validate(ValidationResult result) {
        return result;
    }

    @Override
    public void apply() {
        if (this.experimentalFeatures.isSelected()) {
            WorkspaceSettings.getInstance().setMaturityLevel(MaturityLevel.Community);
        } else {
            WorkspaceSettings.getInstance().setMaturityLevel(MaturityLevel.Production);
        }
        WorkspaceSettings.getInstance().setNotifyForAllBuilds(this.notifyDevBuilds.isSelected());
        WorkspaceSettings.getInstance().setUseVersionChecker(this.enableVersionChecker.isSelected());
        WorkspaceSettings.getInstance().setDateFormatPattern(this.dateFormatField.getText());
        WorkspaceSettings.getInstance().setDatetimeFormatPattern(this.datetimeFormatField.getText());
        WorkspaceSettings.getInstance().setTimeFormatPattern(this.timeFormatField.getText());
        WorkspaceSettings.getInstance().setShowIndexColumns(this.showIndexColumns.isSelected());
        WorkspaceSettings.getInstance().setShowDeprecatedItems(this.showDeprecatedItems.isSelected());
        WorkspaceSettings.getInstance().setShowExpertItems(this.showExpertItems.isSelected());
        WorkspaceSettings.getInstance().setDebugFeaturesVisible(this.showDebugItems.isSelected());
        WorkspaceSettings.getInstance().setReopenLastReport(this.openLastReport.isSelected());
        if (this.lookAndFeelModel.getSelectedItem() != null) {
            WorkspaceSettings.getInstance().setLNF(this.lookAndFeelModel.getSelectedItem().toString());
        }
        this.dateFormatModel.setNumberFormats(this.dateFormats);
        this.numberFormatModel.setNumberFormats(this.numberFormats);
    }

    @Override
    public void reset() {
        this.dateFormatField.setText(WorkspaceSettings.getInstance().getDateFormatPattern());
        this.datetimeFormatField.setText(WorkspaceSettings.getInstance().getDatetimeFormatPattern());
        this.timeFormatField.setText(WorkspaceSettings.getInstance().getTimeFormatPattern());
        MaturityLevel maturityLevel = WorkspaceSettings.getInstance().getMaturityLevel();
        this.experimentalFeatures.setSelected(!MaturityLevel.Limited.isMature(maturityLevel));
        this.lookAndFeelModel.setSelectedItem(WorkspaceSettings.getInstance().getLNF());
        this.notifyDevBuilds.setSelected(WorkspaceSettings.getInstance().isNotifyForAllBuilds());
        this.enableVersionChecker.setSelected(WorkspaceSettings.getInstance().isUseVersionChecker());
        this.showIndexColumns.setSelected(WorkspaceSettings.getInstance().isShowIndexColumns());
        this.showDeprecatedItems.setSelected(WorkspaceSettings.getInstance().isShowDeprecatedItems());
        this.showExpertItems.setSelected(WorkspaceSettings.getInstance().isShowExpertItems());
        this.showDebugItems.setSelected(WorkspaceSettings.getInstance().isDebugFeaturesVisible());
        this.openLastReport.setSelected(WorkspaceSettings.getInstance().isReopenLastReport());
        this.dateFormats = this.dateFormatModel.getNumberFormats();
        this.numberFormats = this.numberFormatModel.getNumberFormats();
    }

    static /* synthetic */ String[] access$202(GeneralSettingsPanel x0, String[] x1) {
        x0.dateFormats = x1;
        return x1;
    }

    static /* synthetic */ String[] access$302(GeneralSettingsPanel x0, String[] x1) {
        x0.numberFormats = x1;
        return x1;
    }

    private class EditFormatAction
    extends AbstractAction {
        private EditFormatAction() {
            this.putValue("Name", SettingsMessages.getInstance().getString("GeneralSettingsPanel.EditFormat.Name"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Window window = SwingUtilities.getWindowAncestor(GeneralSettingsPanel.this);
            FormatEditorDialog dialog = window instanceof Dialog ? new FormatEditorDialog((Dialog)window) : (window instanceof Frame ? new FormatEditorDialog((Frame)window) : new FormatEditorDialog());
            FormatEditorDialog.Result o = dialog.editArray(GeneralSettingsPanel.this.dateFormats, GeneralSettingsPanel.this.numberFormats);
            if (o == null) {
                return;
            }
            GeneralSettingsPanel.access$202(GeneralSettingsPanel.this, o.getDateFormats());
            GeneralSettingsPanel.access$302(GeneralSettingsPanel.this, o.getNumberFormats());
        }
    }

    private class LookAndFeelModel
    extends DefaultComboBoxModel {
        private UIManager.LookAndFeelInfo[] lnfs = UIManager.getInstalledLookAndFeels();
        private int selectedIndex = -1;

        @Override
        public int getSize() {
            return this.lnfs.length;
        }

        @Override
        public Object getElementAt(int index) {
            return this.lnfs[index].getName();
        }

        @Override
        public Object getSelectedItem() {
            if (this.selectedIndex >= 0) {
                return this.lnfs[this.selectedIndex].getName();
            }
            return null;
        }

        @Override
        public void setSelectedItem(Object anObject) {
            UIManager.LookAndFeelInfo lnf;
            int i;
            for (i = 0; anObject != null && i < this.lnfs.length; ++i) {
                lnf = this.lnfs[i];
                if (!lnf.getClassName().equalsIgnoreCase(anObject.toString())) continue;
                this.selectedIndex = i;
                return;
            }
            for (i = 0; anObject != null && i < this.lnfs.length; ++i) {
                lnf = this.lnfs[i];
                if (!lnf.getName().equalsIgnoreCase(anObject.toString())) continue;
                this.selectedIndex = i;
                return;
            }
            this.selectedIndex = -1;
        }
    }

    private class EnableVersionCheckerSelectionHandler
    implements ChangeListener {
        private EnableVersionCheckerSelectionHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            GeneralSettingsPanel.this.notifyDevBuilds.setEnabled(GeneralSettingsPanel.this.enableVersionChecker.isSelected());
        }
    }
}

