/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.settings.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.settings.SettingsMessages;
import org.pentaho.reporting.designer.core.settings.ui.BrowserSettingsPanel;
import org.pentaho.reporting.designer.core.settings.ui.ButtonTabbedPane;
import org.pentaho.reporting.designer.core.settings.ui.ColorSettingsPanel;
import org.pentaho.reporting.designer.core.settings.ui.ExternalToolSettingsPanel;
import org.pentaho.reporting.designer.core.settings.ui.GeneralSettingsPanel;
import org.pentaho.reporting.designer.core.settings.ui.NetworkSettingsPanel;
import org.pentaho.reporting.designer.core.settings.ui.SettingsPlugin;
import org.pentaho.reporting.designer.core.settings.ui.StorageLocationSettingsPanel;
import org.pentaho.reporting.designer.core.settings.ui.ValidationMessage;
import org.pentaho.reporting.designer.core.settings.ui.ValidationResult;
import org.pentaho.reporting.designer.core.util.GUIUtils;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class SettingsDialog
extends JDialog {
    private static final ValidationMessage.Severity[] ALL_SEVERITIES = new ValidationMessage.Severity[]{ValidationMessage.Severity.WARN, ValidationMessage.Severity.ERROR};
    private NetworkSettingsPanel networkSettingsPanel;
    private ArrayList<SettingsPlugin> settingsPlugins;

    public SettingsDialog() throws HeadlessException {
        this.init();
    }

    public SettingsDialog(Frame owner) {
        super(owner);
        this.init();
    }

    public SettingsDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    private void init() {
        this.setTitle(SettingsMessages.getInstance().getString("SettingsDialog.Title"));
        this.setModal(true);
        this.networkSettingsPanel = new NetworkSettingsPanel();
        this.settingsPlugins = new ArrayList();
        this.settingsPlugins.add(new GeneralSettingsPanel());
        this.settingsPlugins.add(this.networkSettingsPanel);
        this.settingsPlugins.add(new BrowserSettingsPanel());
        this.settingsPlugins.add(new ExternalToolSettingsPanel());
        this.settingsPlugins.add(new StorageLocationSettingsPanel());
        this.settingsPlugins.add(new ColorSettingsPanel());
        ButtonTabbedPane listTabbedPane = new ButtonTabbedPane();
        for (int i = 0; i < this.settingsPlugins.size(); ++i) {
            SettingsPlugin settingsPlugin = this.settingsPlugins.get(i);
            listTabbedPane.addTab(settingsPlugin.getIcon(), settingsPlugin.getTitle(), new JScrollPane(settingsPlugin.getComponent()));
        }
        listTabbedPane.showFirst();
        JButton applyButton = new JButton(new ApplyAction());
        JPanel buttonPane = new JPanel(new GridLayout(1, 3, 5, 5));
        buttonPane.add(applyButton);
        buttonPane.add(new JButton(new ResetAction()));
        buttonPane.add(new JButton(new CancelAction()));
        JPanel buttonCarrier = new JPanel(new FlowLayout(2));
        buttonCarrier.add(buttonPane);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)listTabbedPane, "Center");
        centerPanel.add((Component)buttonCarrier, "South");
        this.setContentPane(centerPanel);
        this.getRootPane().getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "cancel");
        this.getRootPane().getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "apply");
        this.getRootPane().getActionMap().put("apply", new ApplyAction());
        this.getRootPane().getActionMap().put("cancel", new CancelAction());
        this.getRootPane().setDefaultButton(applyButton);
        this.pack();
        GUIUtils.ensureMinimumDialogSize(this, 500, 400);
        LibSwingUtil.centerFrameOnScreen((Window)this);
    }

    public void performEdit(ReportDesignerContext context) {
        try {
            this.networkSettingsPanel.setReportDesignerContext(context);
            this.setVisible(true);
        }
        finally {
            this.networkSettingsPanel.setReportDesignerContext(null);
        }
    }

    private class CancelAction
    extends AbstractAction {
        private CancelAction() {
            this.putValue("Name", SettingsMessages.getInstance().getString("SettingsDialog.Cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < SettingsDialog.this.settingsPlugins.size(); ++i) {
                SettingsPlugin settingsPanel = (SettingsPlugin)SettingsDialog.this.settingsPlugins.get(i);
                settingsPanel.reset();
            }
            SettingsDialog.this.dispose();
        }
    }

    private class ResetAction
    extends AbstractAction {
        private ResetAction() {
            this.putValue("Name", SettingsMessages.getInstance().getString("SettingsDialog.Reset"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < SettingsDialog.this.settingsPlugins.size(); ++i) {
                SettingsPlugin settingsPanel = (SettingsPlugin)SettingsDialog.this.settingsPlugins.get(i);
                settingsPanel.reset();
            }
        }
    }

    private class ApplyAction
    extends AbstractAction {
        private ApplyAction() {
            this.putValue("Name", SettingsMessages.getInstance().getString("SettingsDialog.Apply"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SettingsPlugin settingsPanel;
            int i;
            for (i = 0; i < SettingsDialog.this.settingsPlugins.size(); ++i) {
                settingsPanel = (SettingsPlugin)SettingsDialog.this.settingsPlugins.get(i);
                ValidationResult validationResult = settingsPanel.validate(new ValidationResult());
                ValidationMessage[] validationMessages = validationResult.getValidationMessages(ALL_SEVERITIES);
                if (validationMessages.length == 0) continue;
                StringBuilder messages = new StringBuilder(100);
                for (ValidationMessage validationMessage : validationMessages) {
                    messages.append(validationMessage.getMessage());
                    messages.append('\n');
                }
                JOptionPane.showMessageDialog(SettingsDialog.this, messages, SettingsMessages.getInstance().getString("SettingsDialog.ErrorTitle"), 0);
                return;
            }
            for (i = 0; i < SettingsDialog.this.settingsPlugins.size(); ++i) {
                settingsPanel = (SettingsPlugin)SettingsDialog.this.settingsPlugins.get(i);
                settingsPanel.apply();
            }
            SettingsDialog.this.dispose();
        }
    }
}

