/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.settings.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.designer.core.settings.SettingsMessages;
import org.pentaho.reporting.designer.core.settings.ui.SettingsPlugin;
import org.pentaho.reporting.designer.core.settings.ui.ValidationResult;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.FileChooserService;

public class StorageLocationSettingsPanel
extends JPanel
implements SettingsPlugin {
    private LocationPanel[] locationPanels;
    private String[] locationTypes;

    public StorageLocationSettingsPanel() {
        this.setLayout(new BorderLayout());
        this.locationTypes = new String[]{"report", "resources", "mondrian", "kettle", "xmifile", "xls"};
        this.locationPanels = new LocationPanel[this.locationTypes.length];
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridBagLayout());
        for (int i = 0; i < this.locationTypes.length; ++i) {
            String locationType = this.locationTypes[i];
            this.locationPanels[i] = new LocationPanel(locationType);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = i;
            c.weightx = 0.0;
            c.anchor = 18;
            contentPanel.add((Component)new JLabel(SettingsMessages.getInstance().getString("StorageLocationSettingsPanel." + locationType)), c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = i;
            c.weightx = 1.0;
            c.fill = 2;
            contentPanel.add((Component)this.locationPanels[i], c);
        }
        this.add((Component)contentPanel, "North");
        this.reset();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getGeneralSettingsIcon32();
    }

    @Override
    public String getTitle() {
        return SettingsMessages.getInstance().getString("SettingsDialog.Locations");
    }

    @Override
    public ValidationResult validate(ValidationResult result) {
        return result;
    }

    @Override
    public void apply() {
        for (int i = 0; i < this.locationPanels.length; ++i) {
            LocationPanel locationPanel = this.locationPanels[i];
            locationPanel.apply();
        }
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.locationPanels.length; ++i) {
            LocationPanel locationPanel = this.locationPanels[i];
            locationPanel.reset();
        }
    }

    private static class LocationPanel
    extends JPanel {
        private JRadioButton noStoreButton;
        private JRadioButton lastLocationButton;
        private JRadioButton predefinedLocationButton;
        private JTextField predefinedLocationField;
        private String locationType;

        private LocationPanel(String locationType) {
            this.locationType = locationType;
            this.noStoreButton = new JRadioButton();
            this.lastLocationButton = new JRadioButton();
            this.predefinedLocationButton = new JRadioButton();
            this.predefinedLocationButton.addChangeListener(new PredefinedLocationSelectionHandler());
            this.predefinedLocationField = new JTextField();
            this.predefinedLocationField.setEnabled(false);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.noStoreButton);
            bg.add(this.lastLocationButton);
            bg.add(this.predefinedLocationButton);
            JButton browseButton = new JButton(new BrowseAction());
            JLabel noStoreLabel = new JLabel("Do not remember anything.");
            JLabel lastLocationLabel = new JLabel("Remember my last location.");
            JLabel predefinedLocationLabel = new JLabel("Always use this directory.");
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.add((Component)this.noStoreButton, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            this.add((Component)noStoreLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            this.add((Component)this.lastLocationButton, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            this.add((Component)lastLocationLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            this.add((Component)this.predefinedLocationButton, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            this.add((Component)predefinedLocationLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            this.add((Component)this.predefinedLocationField, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 3;
            this.add((Component)browseButton, gbc);
        }

        public void apply() {
            if (this.noStoreButton.isSelected()) {
                FileChooserService.getInstance().setStoreLocations(this.locationType, false);
                FileChooserService.getInstance().setStaticLocation(this.locationType, null);
            } else if (this.lastLocationButton.isSelected()) {
                FileChooserService.getInstance().setStoreLocations(this.locationType, true);
                FileChooserService.getInstance().setStaticLocation(this.locationType, null);
            } else {
                FileChooserService.getInstance().setStoreLocations(this.locationType, false);
                if (StringUtils.isEmpty((String)this.predefinedLocationField.getText(), (boolean)true)) {
                    FileChooserService.getInstance().setStaticLocation(this.locationType, null);
                } else {
                    FileChooserService.getInstance().setStaticLocation(this.locationType, new File(this.predefinedLocationField.getText()));
                }
            }
        }

        public void reset() {
            File staticLocation = FileChooserService.getInstance().getStaticLocation(this.locationType);
            boolean storePolicy = FileChooserService.getInstance().isStoreLocations(this.locationType);
            if (storePolicy) {
                this.lastLocationButton.setSelected(true);
                this.predefinedLocationField.setText(null);
            } else if (staticLocation == null) {
                this.noStoreButton.setSelected(true);
                this.predefinedLocationField.setText(null);
            } else {
                this.predefinedLocationButton.setSelected(true);
                this.predefinedLocationField.setText(staticLocation.getAbsolutePath());
            }
        }

        private class PredefinedLocationSelectionHandler
        implements ChangeListener {
            private PredefinedLocationSelectionHandler() {
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                LocationPanel.this.predefinedLocationField.setEnabled(LocationPanel.this.predefinedLocationButton.isSelected());
            }
        }

        private class BrowseAction
        extends AbstractAction {
            private JFileChooser fileChooser;

            private BrowseAction() {
                this.putValue("Name", "..");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.fileChooser == null) {
                    this.fileChooser = new JFileChooser();
                    this.fileChooser.setAcceptAllFileFilterUsed(false);
                    this.fileChooser.setFileSelectionMode(1);
                }
                if (this.fileChooser.showOpenDialog(LocationPanel.this) != 0) {
                    return;
                }
                File selectedFile = this.fileChooser.getSelectedFile();
                if (selectedFile != null) {
                    if (!selectedFile.isDirectory()) {
                        LocationPanel.this.predefinedLocationField.setText(selectedFile.getParentFile().getAbsolutePath());
                    } else {
                        LocationPanel.this.predefinedLocationField.setText(selectedFile.getAbsolutePath());
                    }
                }
            }
        }
    }
}

