/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Random;
import org.pentaho.reporting.engine.classic.core.util.PropertyLookupParser;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;

public class Anonymizer {
    private Random r = new Random();
    private HashMap<Object, Object> mappedValues = new HashMap();

    public Object anonymizeMessage(Object attribute) throws BeanException {
        if (!(attribute instanceof String)) {
            return this.anonymize(attribute);
        }
        String message = (String)attribute;
        MessageParser mp = new MessageParser(this.r);
        return mp.translateAndLookup(message);
    }

    public Object anonymize(Object value) throws BeanException {
        Object anonymized = this.anonymizeInternal(value);
        if (value != anonymized) {
            Object reused = this.mappedValues.get(value);
            if (reused != null) {
                return reused;
            }
            this.mappedValues.put(value, anonymized);
            return anonymized;
        }
        return anonymized;
    }

    private Object anonymizeInternal(Object value) throws BeanException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.generateRandomText(String.valueOf(value));
        }
        if (value instanceof Number) {
            Number n = this.generateRandomNumber((Number)value);
            return ConverterRegistry.toPropertyValue((String)ConverterRegistry.toAttributeValue((Object)n), value.getClass());
        }
        if (value instanceof Date) {
            Date n = this.generateRandomDate((Date)value);
            return ConverterRegistry.toPropertyValue((String)ConverterRegistry.toAttributeValue((Object)n), value.getClass());
        }
        return value;
    }

    private Date generateRandomDate(Date value) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(value);
        int min = c.getActualMinimum(6);
        int max = c.getActualMaximum(6);
        c.set(6, this.r.nextInt(max - min) + min);
        if (value instanceof java.sql.Date) {
            return c.getTime();
        }
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        long time = c.getTime().getTime();
        return new Date(time + (long)this.r.nextInt(86400000));
    }

    private Number generateRandomNumber(Number value) throws BeanException {
        double v = value.doubleValue();
        NumberFormat fmt = v == (double)value.longValue() ? NumberFormat.getIntegerInstance(Locale.US) : NumberFormat.getNumberInstance(Locale.US);
        String format = fmt.format(value);
        StringBuilder b = new StringBuilder(format);
        for (int i = 0; i < b.length(); ++i) {
            char c = b.charAt(i);
            if (Character.isDigit(c)) {
                b.setCharAt(i, (char)(this.r.nextInt(9) + 48));
                continue;
            }
            b.setCharAt(i, c);
        }
        try {
            return fmt.parse(b.toString());
        }
        catch (ParseException e) {
            throw new BeanException("Failed to parse text", (Throwable)e);
        }
    }

    private Object generateRandomText(String s) {
        StringBuilder b = new StringBuilder(s);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                b.setCharAt(i, ' ');
                continue;
            }
            if (Character.isUpperCase(c)) {
                b.setCharAt(i, (char)(this.r.nextInt(25) + 65));
                continue;
            }
            if (Character.isLetter(c)) {
                b.setCharAt(i, (char)(this.r.nextInt(25) + 97));
                continue;
            }
            if (Character.isDigit(c)) {
                b.setCharAt(i, (char)(this.r.nextInt(9) + 48));
                continue;
            }
            b.setCharAt(i, c);
        }
        return b.toString();
    }

    private static class MessageParser
    extends PropertyLookupParser {
        private Random r;

        private MessageParser(Random r) {
            this.setMarkerChar('$');
            this.setOpeningBraceChar('(');
            this.setClosingBraceChar(')');
            this.r = r;
        }

        protected String lookupVariable(String property) {
            return property;
        }

        protected char postProcessCharacter(char c) {
            if (Character.isWhitespace(c)) {
                return ' ';
            }
            if (Character.isUpperCase(c)) {
                return (char)(this.r.nextInt(25) + 65);
            }
            if (Character.isLetter(c)) {
                return (char)(this.r.nextInt(25) + 97);
            }
            return c;
        }
    }
}

