/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.Iterator;
import org.pentaho.openformula.ui.FormulaEditorDialog;
import org.pentaho.openformula.ui.FunctionParameterEditor;
import org.pentaho.reporting.designer.core.ReportDesignerBoot;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.util.DesignerFormulaEditorDialog;
import org.pentaho.reporting.designer.core.util.ReportDesignerFunctionParameterEditor;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class GUIUtils {
    public static final String FUNCTION_EDITOR_CONFIX_PREFIX = "org.pentaho.reporting.designer.core.function-editor.";

    private GUIUtils() {
    }

    private static void ensureMinimumDialogWidth(Dialog dialog, int minWidth) {
        if (dialog.getWidth() < minWidth) {
            dialog.setSize(minWidth, dialog.getHeight());
        }
    }

    private static void ensureMinimumDialogHeight(Dialog dialog, int minHeight) {
        if (dialog.getHeight() < minHeight) {
            dialog.setSize(dialog.getWidth(), minHeight);
        }
    }

    private static void ensureMaximumDialogWidth(Dialog dialog, int maxWidth) {
        if (dialog.getWidth() > maxWidth) {
            dialog.setSize(maxWidth, dialog.getHeight());
        }
    }

    private static void ensureMaximumDialogHeight(Dialog dialog, int maxHeight) {
        if (dialog.getHeight() > maxHeight) {
            dialog.setSize(dialog.getWidth(), maxHeight);
        }
    }

    public static void ensureMinimumDialogSize(Dialog dialog, int minWidth, int minHeight) {
        GUIUtils.ensureMinimumDialogWidth(dialog, minWidth);
        GUIUtils.ensureMinimumDialogHeight(dialog, minHeight);
    }

    public static void ensureMaximumDialogSize(Dialog dialog, int maxWidth, int maxHeight) {
        GUIUtils.ensureMaximumDialogWidth(dialog, maxWidth);
        GUIUtils.ensureMaximumDialogHeight(dialog, maxHeight);
    }

    public static FormulaEditorDialog createFormulaEditorDialog(ReportDesignerContext context, Component parent) {
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        DesignerFormulaEditorDialog editorDialog = window instanceof Frame ? new DesignerFormulaEditorDialog((Frame)window) : (window instanceof Dialog ? new DesignerFormulaEditorDialog((Dialog)window) : new DesignerFormulaEditorDialog());
        Configuration configuration = ReportDesignerBoot.getInstance().getGlobalConfig();
        Iterator propertyKeys = configuration.findPropertyKeys(FUNCTION_EDITOR_CONFIX_PREFIX);
        while (propertyKeys.hasNext()) {
            String key = (String)propertyKeys.next();
            String function = key.substring(FUNCTION_EDITOR_CONFIX_PREFIX.length());
            String editor = configuration.getConfigProperty(key);
            FunctionParameterEditor fnEditor = (FunctionParameterEditor)ObjectUtilities.loadAndInstantiate((String)editor, GUIUtils.class, FunctionParameterEditor.class);
            if (fnEditor instanceof ReportDesignerFunctionParameterEditor) {
                ReportDesignerFunctionParameterEditor rfn = (ReportDesignerFunctionParameterEditor)fnEditor;
                rfn.setReportDesignerContext(context);
            }
            editorDialog.setEditor(function, fnEditor);
        }
        return editorDialog;
    }
}

