/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.pentaho.reporting.designer.core.util.UtilMessages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.FixDefaultListCellRenderer;
import org.pentaho.reporting.libraries.designtime.swing.KeyedComboBoxModel;

public class QuerySelectorDialog
extends CommonDialog {
    private JList fieldList;
    private RSyntaxTextArea textArea;
    private KeyedComboBoxModel<String, String> syntaxModel;
    private JTabbedPane tab;

    public QuerySelectorDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public QuerySelectorDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public QuerySelectorDialog() throws HeadlessException {
        this.init();
    }

    protected void init() {
        this.setDefaultCloseOperation(2);
        this.fieldList = new JList();
        this.fieldList.setSelectionMode(0);
        this.fieldList.setVisibleRowCount(5);
        this.fieldList.setCellRenderer(new FixDefaultListCellRenderer());
        this.fieldList.addMouseListener(new MouseHandler());
        this.syntaxModel = new KeyedComboBoxModel();
        this.syntaxModel.add((Object)"text/plain", (Object)UtilMessages.getInstance().getString("RSyntaxAreaLanguages.None"));
        this.syntaxModel.add((Object)"text/java", (Object)UtilMessages.getInstance().getString("RSyntaxAreaLanguages.Java"));
        this.syntaxModel.add((Object)"text/javascript", (Object)UtilMessages.getInstance().getString("RSyntaxAreaLanguages.JavaScript"));
        this.syntaxModel.add((Object)"text/groovy", (Object)UtilMessages.getInstance().getString("RSyntaxAreaLanguages.Groovy"));
        this.syntaxModel.add((Object)"text/html", (Object)UtilMessages.getInstance().getString("RSyntaxAreaLanguages.Html"));
        this.syntaxModel.add((Object)"text/css", (Object)UtilMessages.getInstance().getString("RSyntaxAreaLanguages.CSS"));
        this.syntaxModel.add((Object)"text/sql", (Object)UtilMessages.getInstance().getString("RSyntaxAreaLanguages.SQL"));
        this.syntaxModel.add((Object)"text/xml", (Object)UtilMessages.getInstance().getString("RSyntaxAreaLanguages.XML"));
        this.syntaxModel.add((Object)"text/python", (Object)UtilMessages.getInstance().getString("RSyntaxAreaLanguages.Python"));
        this.syntaxModel.add((Object)"text/tcl", (Object)UtilMessages.getInstance().getString("RSyntaxAreaLanguages.TCL"));
        this.textArea = new RSyntaxTextArea();
        this.textArea.setBracketMatchingEnabled(true);
        this.textArea.setSyntaxEditingStyle("text/java");
        this.textArea.setColumns(60);
        this.textArea.setRows(20);
        JPanel syntaxSelectionPane = new JPanel();
        syntaxSelectionPane.setLayout(new FlowLayout());
        JComboBox syntaxBox = new JComboBox(this.syntaxModel);
        syntaxBox.addActionListener(new SyntaxHighlightAction());
        syntaxSelectionPane.add(syntaxBox);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)new RTextScrollPane(500, 300, (RTextArea)this.textArea, true), "Center");
        contentPane.add(syntaxBox, "North");
        this.tab = new JTabbedPane();
        this.tab.addTab(UtilMessages.getInstance().getString("QuerySelectorDialog.DefinedQueries"), new JScrollPane(this.fieldList));
        this.tab.addTab(UtilMessages.getInstance().getString("QuerySelectorDialog.CustomQuery"), contentPane);
        this.setTitle(UtilMessages.getInstance().getString("QuerySelectorDialog.SelectQuery"));
        super.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.QuerySelector";
    }

    protected Component createContentPane() {
        return this.tab;
    }

    public void setQueries(String[] queries, String reportQuery) {
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        boolean found = false;
        for (int i = 0; i < queries.length; ++i) {
            String query = queries[i];
            if (ObjectUtilities.equal((Object)query, (Object)reportQuery)) {
                found = true;
            }
            listModel.addElement(query);
        }
        this.fieldList.setModel(listModel);
        this.fieldList.setSelectedValue(reportQuery, true);
        this.textArea.setText(reportQuery);
        if (!found) {
            this.tab.setSelectedIndex(1);
        } else {
            this.tab.setSelectedIndex(0);
        }
    }

    public String performEdit(String[] queries, String selectedQuery) {
        this.setQueries(queries, selectedQuery);
        if (!this.performEdit()) {
            return selectedQuery;
        }
        if (this.tab.getSelectedIndex() == 1) {
            return this.textArea.getText();
        }
        return (String)this.fieldList.getSelectedValue();
    }

    private class SyntaxHighlightAction
    implements ActionListener {
        private SyntaxHighlightAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = QuerySelectorDialog.this.syntaxModel.getSelectedKey();
            if (o instanceof String) {
                QuerySelectorDialog.this.textArea.setSyntaxEditingStyle((String)o);
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1 && e.getButton() == 1) {
                QuerySelectorDialog.this.setConfirmed(true);
                QuerySelectorDialog.this.dispose();
            }
        }
    }
}

