/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util;

public enum Unit {
    POINTS(1.0),
    PICA(12.0),
    MM(2.834645669291339),
    CM(28.346456692913385),
    INCH(72.0);

    private double dotsPerUnit;

    private Unit(double dotsPerUnit) {
        this.dotsPerUnit = dotsPerUnit;
    }

    public double getDotsPerUnit() {
        return this.dotsPerUnit;
    }

    public double convertFromPoints(double points) {
        return points / this.dotsPerUnit;
    }

    public double convertToPoints(double unit) {
        return unit * this.dotsPerUnit;
    }

    public double getTickSize(double sf) {
        switch (this) {
            case POINTS: {
                if (sf < 0.2) {
                    return 200.0;
                }
                if (sf < 0.5) {
                    return 100.0;
                }
                if (sf < 2.0) {
                    return 50.0;
                }
                if (sf < 3.0) {
                    return 20.0;
                }
                return 10.0;
            }
            case INCH: {
                if (sf < 0.2) {
                    return 2.0;
                }
                if (sf < 0.5) {
                    return 1.0;
                }
                if (sf < 2.0) {
                    return 0.5;
                }
                if (sf < 3.0) {
                    return 0.2;
                }
                return 0.1;
            }
            case CM: {
                if (sf < 0.2) {
                    return 5.0;
                }
                if (sf < 0.5) {
                    return 2.0;
                }
                if (sf < 2.0) {
                    return 1.0;
                }
                if (sf < 4.0) {
                    return 0.5;
                }
                return 0.2;
            }
            case MM: {
                if (sf < 0.5) {
                    return 50.0;
                }
                if (sf < 1.0) {
                    return 20.0;
                }
                if (sf < 3.0) {
                    return 10.0;
                }
                if (sf < 4.0) {
                    return 5.0;
                }
                return 2.0;
            }
            case PICA: {
                if (sf < 0.2) {
                    return 20.0;
                }
                if (sf < 0.5) {
                    return 10.0;
                }
                if (sf < 2.0) {
                    return 5.0;
                }
                if (sf < 3.0) {
                    return 2.0;
                }
                return 1.0;
            }
        }
        return 1.0;
    }
}

