/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.docking;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import javax.swing.JPanel;

public class GradientPanel
extends JPanel {
    private Color[] gradientColors;
    private Direction direction;
    private boolean gradientSetByUser;

    public GradientPanel() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.gradientColors = new Color[]{this.getBackground().darker(), this.getBackground()};
        this.direction = Direction.DIRECTION_DOWN;
        this.gradientSetByUser = false;
    }

    public void setGradientColors(Color[] gradientColors) {
        if (gradientColors == null || gradientColors.length == 0) {
            throw new IllegalArgumentException("gradientColors must be array with more than zero elements");
        }
        this.gradientSetByUser = true;
        this.gradientColors = gradientColors.length == 1 ? new Color[]{gradientColors[0], gradientColors[0]} : (Color[])gradientColors.clone();
        this.repaint();
    }

    public Color[] getGradientColors() {
        return (Color[])this.gradientColors.clone();
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (!this.gradientSetByUser) {
            this.gradientColors = new Color[]{this.getBackground().darker(), this.getBackground()};
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D graphics2D = (Graphics2D)g;
        if (this.direction == Direction.DIRECTION_DOWN) {
            int heigthIncrement = this.getHeight() / (this.gradientColors.length - 1);
            for (int i = 0; i < this.gradientColors.length - 1; ++i) {
                GradientPaint gradientPaint = new GradientPaint(new Point2D.Double(0.0, heigthIncrement * i), this.gradientColors[i], new Point2D.Double(0.0, (i + 1) * heigthIncrement), this.gradientColors[i + 1]);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(0, i * heigthIncrement, this.getWidth(), heigthIncrement);
            }
        } else if (this.direction == Direction.DIRECTION_UP) {
            int heigthIncrement = this.getHeight() / (this.gradientColors.length - 1);
            for (int i = 0; i < this.gradientColors.length - 1; ++i) {
                Color gc1 = this.gradientColors[this.gradientColors.length - i - 1];
                Color gc2 = this.gradientColors[this.gradientColors.length - i - 2];
                GradientPaint gradientPaint = new GradientPaint(new Point2D.Double(0.0, heigthIncrement * i), gc1, new Point2D.Double(0.0, (i + 1) * heigthIncrement), gc2);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(0, i * heigthIncrement, this.getWidth(), heigthIncrement);
            }
        } else if (this.direction == Direction.DIRECTION_LEFT) {
            int widthIncrement = this.getWidth() / (this.gradientColors.length - 1);
            for (int i = 0; i < this.gradientColors.length - 1; ++i) {
                GradientPaint gradientPaint = new GradientPaint(new Point2D.Double(widthIncrement * i, 0.0), this.gradientColors[i], new Point2D.Double((i + 1) * widthIncrement, 0.0), this.gradientColors[i + 1]);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(i * widthIncrement, 0, widthIncrement, this.getHeight());
            }
        }
        super.paintComponent(g);
    }

    public static enum Direction {
        DIRECTION_UP,
        DIRECTION_DOWN,
        DIRECTION_LEFT;

    }
}

