/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.util.UtilMessages;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeUtil;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ClassicEngineFactoryParameters;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.event.DocumentChangeHandler;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.CommonFileChooser;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.FileChooserService;
import org.pentaho.reporting.libraries.designtime.swing.propertyeditors.ValidatingPropertyEditorComponent;
import org.pentaho.reporting.libraries.repository.DefaultMimeRegistry;
import org.pentaho.reporting.libraries.resourceloader.LoaderParameterKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ResourcePropertyEditorComponent
extends JComponent
implements ValidatingPropertyEditorComponent {
    private static final DefaultMimeRegistry mimeRegistry = new DefaultMimeRegistry();
    private JRadioButton linkToRadio;
    private JRadioButton embedRadio;
    private JTextField sourceTextField;
    private ReportDocumentContext reportRenderContext;
    private Object currentValue;
    private String lastTextValue;
    private DocumentLocation lastDocumentLocation;
    private boolean disableEvents;

    public ResourcePropertyEditorComponent(ReportDocumentContext reportRenderContext) {
        if (reportRenderContext == null) {
            throw new NullPointerException("The ReportRenderContext must not be null");
        }
        this.reportRenderContext = reportRenderContext;
        SourceChangeHandler changeHandler = new SourceChangeHandler();
        this.sourceTextField = new JTextField(35);
        this.sourceTextField.getDocument().addDocumentListener((DocumentListener)((Object)changeHandler));
        this.linkToRadio = new JRadioButton(UtilMessages.getInstance().getString("ResourcePropertyEditorComponent.LinkTo"));
        this.linkToRadio.setSelected(true);
        this.linkToRadio.addChangeListener(changeHandler);
        this.embedRadio = new JRadioButton(UtilMessages.getInstance().getString("ResourcePropertyEditorComponent.Embed"));
        this.embedRadio.addChangeListener(changeHandler);
        JPanel identifierSelectorPanel = new JPanel(new BorderLayout());
        identifierSelectorPanel.add((Component)this.sourceTextField, "Center");
        identifierSelectorPanel.add((Component)new JButton(new FileSelectAction()), "East");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.linkToRadio);
        buttonGroup.add(this.embedRadio);
        JPanel identifierPane = new JPanel(new BorderLayout());
        identifierPane.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        identifierPane.add((Component)new JLabel(UtilMessages.getInstance().getString("ResourcePropertyEditorComponent.SourceLabel")), "North");
        identifierPane.add((Component)identifierSelectorPanel, "Center");
        JPanel selectionPanel = new JPanel(new GridLayout(2, 1));
        selectionPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        selectionPanel.add(this.linkToRadio);
        selectionPanel.add(this.embedRadio);
        this.setLayout(new BorderLayout());
        this.add((Component)identifierPane, "Center");
        this.add((Component)selectionPanel, "South");
    }

    public Object getValue() {
        String currentTextValue = this.sourceTextField.getText();
        DocumentLocation currentDocumentLocation = this.getDocumentLocation();
        if (currentTextValue.equals(this.lastTextValue) && currentDocumentLocation.equals((Object)this.lastDocumentLocation)) {
            return this.currentValue;
        }
        if (StringUtils.isEmpty((String)currentTextValue)) {
            this.lastTextValue = currentTextValue;
            this.lastDocumentLocation = currentDocumentLocation;
            return null;
        }
        try {
            this.currentValue = this.createResourceKey(currentTextValue, currentDocumentLocation);
        }
        catch (Exception ignored) {
            this.currentValue = currentTextValue;
        }
        this.lastTextValue = currentTextValue;
        this.lastDocumentLocation = currentDocumentLocation;
        return this.currentValue;
    }

    private Object createResourceKey(String source, DocumentLocation docLoc) throws ResourceKeyCreationException, IOException, ResourceLoadingException {
        if (StringUtils.isEmpty((String)source, (boolean)true)) {
            return null;
        }
        if (DocumentLocation.EMBED.equals((Object)docLoc)) {
            String mimeType = mimeRegistry.getMimeType(source);
            String pattern = "resources/image{0}" + IOUtils.getInstance().getFileExtension(source);
            HashMap<LoaderParameterKey, String> parameters = new HashMap<LoaderParameterKey, String>();
            parameters.put(ClassicEngineFactoryParameters.ORIGINAL_VALUE, source);
            parameters.put(ClassicEngineFactoryParameters.MIME_TYPE, mimeType);
            parameters.put(ClassicEngineFactoryParameters.PATTERN, pattern);
            parameters.put(ClassicEngineFactoryParameters.EMBED, "true");
            ResourceKey key = ResourceKeyUtils.toResourceKey((Object)source, (ResourceManager)this.reportRenderContext.getResourceManager(), (ResourceKey)this.reportRenderContext.getReportDefinition().getContentBase(), parameters);
            return ResourceKeyUtils.embedResourceInKey((ResourceManager)this.reportRenderContext.getResourceManager(), (ResourceKey)key, (Map)key.getFactoryParameters());
        }
        ResourceKey contentBaseKey = this.reportRenderContext.getReportDefinition().getContentBase();
        ResourceKey resourceKey = ResourceKeyUtils.toResourceKey((Object)source, (ResourceManager)this.reportRenderContext.getResourceManager(), (ResourceKey)contentBaseKey, (Map)Collections.EMPTY_MAP);
        if (this.isDerivedKey(resourceKey, contentBaseKey)) {
            return source;
        }
        return resourceKey;
    }

    private boolean isDerivedKey(ResourceKey key, ResourceKey contentKey) {
        if (contentKey == null) {
            return false;
        }
        if (contentKey.getSchema().equals(key.getSchema())) {
            return true;
        }
        return this.isDerivedKey(key, contentKey.getParent());
    }

    public void setValue(String value) {
        this.sourceTextField.setText(value);
        this.setDocumentLocation(DocumentLocation.LINK);
        this.fireValueChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object object) {
        if (ObjectUtilities.equal((Object)this.currentValue, (Object)object)) {
            return;
        }
        try {
            this.disableEvents = true;
            if (object == null) {
                this.sourceTextField.setText("");
                this.setDocumentLocation(DocumentLocation.LINK);
            } else if (object instanceof ResourceKey) {
                ResourceKey resourceKey = (ResourceKey)object;
                Object originalValue = resourceKey.getFactoryParameters().get(ClassicEngineFactoryParameters.ORIGINAL_VALUE);
                if (originalValue != null) {
                    this.sourceTextField.setText(String.valueOf(originalValue));
                    this.setDocumentLocation(DocumentLocation.EMBED);
                } else {
                    this.sourceTextField.setText(resourceKey.getIdentifierAsString());
                    this.setDocumentLocation(DocumentLocation.LINK);
                }
            } else {
                this.sourceTextField.setText(String.valueOf(object));
                this.setDocumentLocation(DocumentLocation.LINK);
            }
            this.currentValue = object;
        }
        finally {
            this.disableEvents = false;
        }
        this.fireValueChangeEvent();
    }

    private DocumentLocation getDocumentLocation() {
        return this.linkToRadio.isSelected() ? DocumentLocation.LINK : DocumentLocation.EMBED;
    }

    private void setDocumentLocation(DocumentLocation documentLocation) {
        if (DocumentLocation.LINK.equals((Object)documentLocation)) {
            this.linkToRadio.setSelected(true);
            this.embedRadio.setSelected(false);
        } else {
            this.linkToRadio.setSelected(false);
            this.embedRadio.setSelected(true);
        }
    }

    public boolean isValidEditorValue() {
        if (this.getDocumentLocation().equals((Object)DocumentLocation.LINK)) {
            return true;
        }
        Object o = this.getValue();
        return o instanceof ResourceKey;
    }

    private void fireValueChangeEvent() {
        if (this.disableEvents) {
            return;
        }
        Object oldValue = this.currentValue;
        Object newValue = this.getValue();
        this.firePropertyChange(null, oldValue, newValue);
    }

    private void fireRadioChangeEvent() {
        if (this.disableEvents) {
            return;
        }
        DocumentLocation oldValue = this.lastDocumentLocation;
        DocumentLocation newValue = this.getDocumentLocation();
        this.firePropertyChange(null, (Object)oldValue, (Object)newValue);
    }

    private class FileSelectAction
    extends AbstractAction {
        private FileSelectAction() {
            this.putValue("Name", "..");
        }

        @Override
        public void actionPerformed(ActionEvent aEvt) {
            File reportContextFile = DesignTimeUtil.getContextAsFile((AbstractReportDefinition)ResourcePropertyEditorComponent.this.reportRenderContext.getReportDefinition());
            FileFilter[] filters = new FileFilter[]{new FilesystemFilter(".properties", Messages.getString("BundledResourceEditor.PropertiesTranslations", new Object[0])), new FilesystemFilter(new String[]{".xml", ".report", ".prpt", ".prpti", ".prptstyle"}, Messages.getString("BundledResourceEditor.Resources", new Object[0]), true), new FilesystemFilter(new String[]{".gif", ".jpg", ".jpeg", ".png", ".svg", ".wmf"}, Messages.getString("BundledResourceEditor.Images", new Object[0]), true)};
            CommonFileChooser fileChooser = FileChooserService.getInstance().getFileChooser("resources");
            fileChooser.setFilters(filters);
            String sourceFile = ResourcePropertyEditorComponent.this.sourceTextField.getText();
            if (!StringUtils.isEmpty((String)sourceFile)) {
                if (reportContextFile != null) {
                    fileChooser.setSelectedFile(new File(reportContextFile.getParentFile(), ResourcePropertyEditorComponent.this.sourceTextField.getText()));
                } else {
                    fileChooser.setSelectedFile(new File(ResourcePropertyEditorComponent.this.sourceTextField.getText()));
                }
            }
            if (!fileChooser.showDialog((Component)ResourcePropertyEditorComponent.this, 0)) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            String path = reportContextFile != null ? IOUtils.getInstance().createRelativePath(file.getPath(), reportContextFile.getAbsolutePath()) : file.getPath();
            ResourcePropertyEditorComponent.this.sourceTextField.setText(path);
        }
    }

    private class SourceChangeHandler
    extends DocumentChangeHandler
    implements ChangeListener {
        private SourceChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ResourcePropertyEditorComponent.this.fireRadioChangeEvent();
        }

        protected void handleChange(DocumentEvent e) {
            ResourcePropertyEditorComponent.this.fireValueChangeEvent();
        }
    }

    public static enum DocumentLocation {
        LINK,
        EMBED;

    }
}

