/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table.expressions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import org.pentaho.openformula.ui.FieldDefinition;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.UtilMessages;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.table.CellEditorUtility;
import org.pentaho.reporting.designer.core.util.table.expressions.ReportPreProcessorListCellRenderer;
import org.pentaho.reporting.designer.core.util.table.expressions.ReportPreProcessorPropertiesDialog;
import org.pentaho.reporting.engine.classic.core.ReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ReportPreProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ReportPreProcessorRegistry;
import org.pentaho.reporting.libraries.designtime.swing.EllipsisButton;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.SmartComboBox;
import org.pentaho.reporting.libraries.designtime.swing.ValuePassThroughCellEditor;

public class ReportPreProcessorCellEditor
implements TableCellEditor {
    private static final String POPUP_EDITOR = "popupEditor";
    private JPanel carrierPanel;
    private JComboBox expressionEditor;
    private EventListenerList eventListenerList = new EventListenerList();
    private ReportDocumentContext renderContext;

    public ReportPreProcessorCellEditor() {
        EllipsisButton ellipsisButton = new EllipsisButton("...");
        ellipsisButton.addActionListener((ActionListener)new ExtendedEditorAction());
        DefaultComboBoxModel<ReportPreProcessorMetaData> model = new DefaultComboBoxModel<ReportPreProcessorMetaData>();
        ReportPreProcessorMetaData[] datas = ReportPreProcessorRegistry.getInstance().getAllReportPreProcessorMetaDatas();
        model.addElement(null);
        for (int i = 0; i < datas.length; ++i) {
            ReportPreProcessorMetaData metaData = datas[i];
            if (metaData.isAutoProcessor() || metaData.isHidden() || !WorkspaceSettings.getInstance().isVisible((MetaData)metaData)) continue;
            model.addElement(metaData);
        }
        this.expressionEditor = new SmartComboBox(model);
        this.expressionEditor.addActionListener(new SelectionAction());
        this.expressionEditor.setEditor((ComboBoxEditor)new ValuePassThroughCellEditor(this.expressionEditor, (ListCellRenderer)new ReportPreProcessorListCellRenderer()));
        this.expressionEditor.setRenderer(new ReportPreProcessorListCellRenderer());
        this.expressionEditor.getInputMap().put(UtilMessages.getInstance().getKeyStroke("PropertyCellEditorWithEllipsis.PopupEditor.Accelerator"), POPUP_EDITOR);
        this.expressionEditor.getActionMap().put(POPUP_EDITOR, new ExtendedEditorAction());
        this.expressionEditor.setBorder(BorderFactory.createEmptyBorder());
        this.carrierPanel = new JPanel(new BorderLayout());
        this.carrierPanel.add((Component)this.expressionEditor, "Center");
        this.carrierPanel.add((Component)ellipsisButton, "East");
    }

    public void setRenderContext(ReportDocumentContext renderContext) {
        this.renderContext = renderContext;
    }

    public FieldDefinition[] getFields() {
        return CellEditorUtility.getFields(this.renderContext, new String[0]);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        ReportPreProcessor value1 = value instanceof ReportPreProcessor ? (ReportPreProcessor)value : null;
        this.expressionEditor.setSelectedItem(value1);
        return this.carrierPanel;
    }

    @Override
    public Object getCellEditorValue() {
        Object o = this.expressionEditor.getSelectedItem();
        if (o instanceof ReportPreProcessorMetaData) {
            try {
                ReportPreProcessorMetaData emd = (ReportPreProcessorMetaData)o;
                return emd.getPreProcessorType().newInstance();
            }
            catch (Throwable t) {
                UncaughtExceptionsModel.getInstance().addException(t);
                return null;
            }
        }
        if (o instanceof ReportPreProcessor) {
            return o;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)anEvent;
            return mouseEvent.getClickCount() >= 2 && mouseEvent.getButton() == 1;
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.expressionEditor.actionPerformed(new ActionEvent(this, 0, ""));
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    protected void fireEditingCanceled() {
        CellEditorListener[] listeners = (CellEditorListener[])this.eventListenerList.getListeners(CellEditorListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            CellEditorListener listener = listeners[i];
            listener.editingCanceled(event);
        }
    }

    protected void fireEditingStopped() {
        CellEditorListener[] listeners = (CellEditorListener[])this.eventListenerList.getListeners(CellEditorListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            CellEditorListener listener = listeners[i];
            listener.editingStopped(event);
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.eventListenerList.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.eventListenerList.remove(CellEditorListener.class, l);
    }

    private class SelectionAction
    implements ActionListener {
        private SelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReportPreProcessorCellEditor.this.stopCellEditing();
        }
    }

    private class ExtendedEditorAction
    extends AbstractAction {
        private ExtendedEditorAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Window window = LibSwingUtil.getWindowAncestor((Component)ReportPreProcessorCellEditor.this.carrierPanel);
            Object selectedItem = ReportPreProcessorCellEditor.this.expressionEditor.getSelectedItem();
            if (selectedItem instanceof ReportPreProcessor) {
                ReportPreProcessorPropertiesDialog optionPane = window instanceof JFrame ? new ReportPreProcessorPropertiesDialog((JFrame)window) : (window instanceof JDialog ? new ReportPreProcessorPropertiesDialog((JDialog)window) : new ReportPreProcessorPropertiesDialog());
                ReportPreProcessor expression = optionPane.editExpression((ReportPreProcessor)selectedItem);
                if (expression != selectedItem) {
                    ReportPreProcessorCellEditor.this.expressionEditor.setSelectedItem(expression);
                }
                ReportPreProcessorCellEditor.this.stopCellEditing();
            } else if (selectedItem instanceof ReportPreProcessorMetaData) {
                try {
                    ReportPreProcessorMetaData emd = (ReportPreProcessorMetaData)selectedItem;
                    ReportPreProcessor expression = (ReportPreProcessor)emd.getPreProcessorType().newInstance();
                    ReportPreProcessorPropertiesDialog optionPane = window instanceof JFrame ? new ReportPreProcessorPropertiesDialog((JFrame)window) : (window instanceof JDialog ? new ReportPreProcessorPropertiesDialog((JDialog)window) : new ReportPreProcessorPropertiesDialog());
                    ReportPreProcessor resultexpression = optionPane.editExpression(expression);
                    if (resultexpression != expression) {
                        ReportPreProcessorCellEditor.this.expressionEditor.setSelectedItem(resultexpression);
                    }
                    ReportPreProcessorCellEditor.this.stopCellEditing();
                }
                catch (Throwable e1) {
                    UncaughtExceptionsModel.getInstance().addException(e1);
                }
            }
        }
    }
}

