/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table.filter;

import java.util.BitSet;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.pentaho.reporting.designer.core.util.table.filter.CompoundFilter;
import org.pentaho.reporting.designer.core.util.table.filter.Filter;
import org.pentaho.reporting.designer.core.util.table.filter.FilterTableModel;

public class DefaultFilterTableModel
implements FilterTableModel {
    private EventListenerList eventListenerList = new EventListenerList();
    private TableModel backend;
    private int filterColumn;
    private CompoundFilter filters;
    private BitSet filteredSet;
    private int rowCount;

    public DefaultFilterTableModel(TableModel backend, int filterColumn) {
        this.filterColumn = filterColumn;
        this.filters = new CompoundFilter();
        this.filteredSet = new BitSet(backend.getRowCount());
        this.backend = backend;
        this.backend.addTableModelListener(new EventForwardHandler());
        this.recomputeRowCount();
    }

    protected void fireTableModelEvent(TableModelEvent event) {
        TableModelListener[] listeners = (TableModelListener[])this.eventListenerList.getListeners(TableModelListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            TableModelListener listener = listeners[i];
            listener.tableChanged(event);
        }
    }

    protected void recomputeRowCount() {
        this.rowCount = this.mapFromModel(this.backend.getRowCount());
    }

    @Override
    public Filter getFilter() {
        return this.filters;
    }

    public CompoundFilter getFilters() {
        return this.filters;
    }

    public void setFilters(CompoundFilter filters) {
        if (filters == null) {
            throw new NullPointerException();
        }
        this.filters = filters;
    }

    public void applyFilter() {
        int rowCount = this.backend.getRowCount();
        for (int r = 0; r < rowCount; ++r) {
            Object filterValue = this.backend.getValueAt(r, this.getFilterColumn());
            Filter.Result match = this.filters.isMatch(filterValue);
            if (match == Filter.Result.REJECT) {
                this.filteredSet.set(r, true);
                continue;
            }
            this.filteredSet.set(r, false);
        }
        this.recomputeRowCount();
    }

    @Override
    public int getFilterColumn() {
        return this.filterColumn;
    }

    public Class getColumnClass(int columnIndex) {
        return this.backend.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.backend.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.backend.getColumnName(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        int index = this.mapToModel(rowIndex);
        return this.backend.isCellEditable(index, columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.backend.getValueAt(this.mapToModel(rowIndex), columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        int index = this.mapToModel(rowIndex);
        this.backend.setValueAt(aValue, index, columnIndex);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.eventListenerList.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.eventListenerList.remove(TableModelListener.class, l);
    }

    public int mapToModel(int row) {
        int size = this.backend.getRowCount();
        int effectiveRow = -1;
        for (int i = 0; i < size; ++i) {
            if (this.filteredSet.get(i) || ++effectiveRow != row) continue;
            return i;
        }
        throw new IndexOutOfBoundsException("Unable to map row to model: " + row);
    }

    public int mapFromModel(int row) {
        if (row < 0) {
            return row;
        }
        int size = this.backend.getRowCount();
        int retval = 0;
        for (int i = 0; i < size; ++i) {
            if (!this.filteredSet.get(i)) {
                if (row == i) {
                    return retval;
                }
                ++retval;
                continue;
            }
            if (row != i) continue;
            return retval - 1;
        }
        return retval;
    }

    private class EventForwardHandler
    implements TableModelListener {
        private EventForwardHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            DefaultFilterTableModel.this.recomputeRowCount();
            if (e.getFirstRow() == 0 && e.getLastRow() == Integer.MAX_VALUE) {
                DefaultFilterTableModel.this.applyFilter();
                DefaultFilterTableModel.this.fireTableModelEvent(new TableModelEvent(DefaultFilterTableModel.this, e.getFirstRow(), e.getLastRow(), e.getColumn(), e.getType()));
                return;
            }
            TableModelEvent event = new TableModelEvent(DefaultFilterTableModel.this, DefaultFilterTableModel.this.mapFromModel(e.getFirstRow()), DefaultFilterTableModel.this.mapFromModel(e.getLastRow()), e.getColumn(), e.getType());
            DefaultFilterTableModel.this.fireTableModelEvent(event);
        }
    }
}

