/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.undo;

import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.AbstractRootLevelBand;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class BandedSubreportEditUndoEntry
implements UndoEntry {
    private InstanceID target;
    private int position;
    private SubReport oldElement;
    private SubReport newElement;

    public BandedSubreportEditUndoEntry(InstanceID target, int position, SubReport oldElement, SubReport newElement) {
        this.target = target;
        this.position = position;
        this.oldElement = oldElement;
        this.newElement = newElement;
    }

    @Override
    public void undo(ReportDocumentContext renderContext) {
        AbstractRootLevelBand elementById = (AbstractRootLevelBand)ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
        if (this.newElement != null) {
            elementById.removeSubreport(this.newElement);
        }
        if (this.oldElement != null) {
            elementById.addSubReport(this.position, this.oldElement);
        }
    }

    @Override
    public void redo(ReportDocumentContext renderContext) {
        AbstractRootLevelBand elementById = (AbstractRootLevelBand)ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
        if (this.oldElement != null) {
            elementById.removeSubreport(this.oldElement);
        }
        if (this.newElement != null) {
            elementById.addSubReport(this.position, this.newElement);
        }
    }

    @Override
    public UndoEntry merge(UndoEntry newEntry) {
        return null;
    }
}

