/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.undo;

import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;

public class CompoundUndoEntry
implements UndoEntry {
    private UndoEntry[] undoEntries;

    public CompoundUndoEntry(UndoEntry ... undoEntries) {
        this.undoEntries = (UndoEntry[])undoEntries.clone();
    }

    @Override
    public void undo(ReportDocumentContext renderContext) {
        for (int i = this.undoEntries.length - 1; i >= 0; --i) {
            UndoEntry undoEntry = this.undoEntries[i];
            undoEntry.undo(renderContext);
        }
    }

    @Override
    public void redo(ReportDocumentContext renderContext) {
        for (int i = 0; i < this.undoEntries.length; ++i) {
            UndoEntry undoEntry = this.undoEntries[i];
            undoEntry.redo(renderContext);
        }
    }

    @Override
    public UndoEntry merge(UndoEntry newEntry) {
        return null;
    }
}

