/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.undo;

import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class MassElementStyleUndoEntry
implements UndoEntry {
    private InstanceID[] visualElements;
    private Object[][] oldStyle;
    private Object[][] currentStyle;

    public MassElementStyleUndoEntry(InstanceID[] visualElements, Object[][] oldStyle, Object[][] currentStyle) {
        this.visualElements = visualElements;
        this.oldStyle = oldStyle;
        this.currentStyle = currentStyle;
    }

    protected InstanceID[] getVisualElements() {
        return this.visualElements;
    }

    @Override
    public void undo(ReportDocumentContext renderContext) {
        AbstractReportDefinition reportDefinition = renderContext.getReportDefinition();
        StyleKey[] keys = StyleKey.getDefinedStyleKeys();
        for (int i = 0; i < this.visualElements.length; ++i) {
            InstanceID visualElement = this.visualElements[i];
            ReportElement element = ModelUtility.findElementById(reportDefinition, visualElement);
            ElementStyleSheet styleSheet = element.getStyle();
            Object[] properties = this.oldStyle[i];
            for (int j = 0; j < keys.length; ++j) {
                StyleKey key = keys[j];
                styleSheet.setStyleProperty(key, properties[key.identifier]);
            }
        }
    }

    @Override
    public void redo(ReportDocumentContext renderContext) {
        AbstractReportDefinition reportDefinition = renderContext.getReportDefinition();
        StyleKey[] keys = StyleKey.getDefinedStyleKeys();
        for (int i = 0; i < this.visualElements.length; ++i) {
            InstanceID visualElement = this.visualElements[i];
            ReportElement element = ModelUtility.findElementById(reportDefinition, visualElement);
            ElementStyleSheet styleSheet = element.getStyle();
            Object[] properties = this.currentStyle[i];
            for (int j = 0; j < keys.length; ++j) {
                StyleKey key = keys[j];
                styleSheet.setStyleProperty(key, properties[key.identifier]);
            }
        }
    }

    @Override
    public UndoEntry merge(UndoEntry newEntry) {
        return null;
    }
}

