/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.versionchecker;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import org.pentaho.reporting.designer.core.util.HyperLink;
import org.pentaho.reporting.designer.core.versionchecker.Messages;
import org.pentaho.reporting.designer.core.widgets.HyperlinkHandler;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;

public class VersionCheckerEnableDialog
extends CommonDialog {
    public VersionCheckerEnableDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public VersionCheckerEnableDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public VersionCheckerEnableDialog() {
        this.init();
    }

    protected void init() {
        this.setTitle(Messages.getInstance().getString("VersionCheckerUtility.Title"));
        this.setModal(true);
        super.init();
        this.getConfirmAction().putValue("Name", Messages.getInstance().getString("VersionCheckerUtility.Yes"));
        this.getCancelAction().putValue("Name", Messages.getInstance().getString("VersionCheckerUtility.No"));
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.VersionCheckerEnable";
    }

    protected Component createContentPane() {
        Font font = UIManager.getFont("Label.font");
        if (font == null) {
            font = new Font("Dialog", 0, 10);
        }
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        JTextPane messageLabel = new JTextPane();
        messageLabel.setFont(font.deriveFont(1));
        messageLabel.setText(Messages.getInstance().getString("VersionCheckerUtility.Message"));
        messageLabel.setFocusable(false);
        messageLabel.setBackground(null);
        String url = Messages.getInstance().getString("VersionCheckerUtility.URL");
        HyperLink linkLbl = new HyperLink(url);
        linkLbl.addMouseListener(new HyperlinkHandler(url, linkLbl));
        String questionText = Messages.getInstance().getString("VersionCheckerUtility.Question");
        JTextPane questionLabel = new JTextPane();
        questionLabel.setFont(font.deriveFont(1));
        questionLabel.setText(questionText);
        questionLabel.setBackground(null);
        questionLabel.setFocusable(false);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 10, 0, 10);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 16;
        contentPane.add((Component)messageLabel, c);
        c.insets = new Insets(0, 15, 0, 10);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 18;
        contentPane.add((Component)linkLbl, c);
        c.insets = new Insets(0, 10, 10, 10);
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 16;
        contentPane.add((Component)questionLabel, c);
        return contentPane;
    }

    public boolean performEdit() {
        return super.performEdit();
    }
}

